/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableElement;
import org.makumba.analyser.AnalysableExpression;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.ELData;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.commons.GraphTS;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.list.tags.QueryTag;

public class ParseStatus {
    String makumbaPrefix = new String("dummy_prefix");
    String formPrefix = new String("dummy_prefix");
    String makumbaURI;
    String formMakumbaURI;
    List<AnalysableElement> elements = new ArrayList<AnalysableElement>();
    List<AnalysableTag> parents = new ArrayList<AnalysableTag>();
    protected PageCache pageCache = new PageCache();
    GraphTS formGraph = new GraphTS();

    void addTag(AnalysableTag t, TagData td) {
        if (!this.parents.isEmpty()) {
            t.setParent((Tag)this.parents.get(this.parents.size() - 1));
        } else {
            t.setParent(null);
        }
        JspParseData.fill((Tag)t, td.attributes);
        t.setTagKey(this.pageCache);
        if (t.getTagKey() != null && !t.allowsIdenticalKey()) {
            AnalysableTag sameKey = (AnalysableTag)((Object)this.pageCache.retrieve("org.makumba.tags", t.getTagKey()));
            if (sameKey != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("Due to limitations of the JSP standard, Makumba cannot make\n").append("a difference between the following two tags: \n");
                sameKey.addTagText(sb);
                sb.append("\n");
                t.addTagText(sb);
                sb.append("\nTo address this, add an id= attribute to one of the tags, and make sure that id is unique within the page.");
                throw new ProgrammerError(sb.toString());
            }
            this.pageCache.cache("org.makumba.tags", t.getTagKey(), (Object)t);
            if (t instanceof QueryTag) {
                this.pageCache.cache("org.makumba.tags", t.getId(), (Object)t);
            }
        }
        if (MakumbaJspAnalyzer.formTagNamesList.contains(this.getTagName(t.tagData.name))) {
            if (t.getParent() instanceof AnalysableTag) {
                AnalysableTag parent = (AnalysableTag)t.getParent();
                if (MakumbaJspAnalyzer.formTagNamesList.contains(this.getTagName(parent.tagData.name))) {
                    td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
                    this.formGraph.addEdge(td.nodeNumber, parent.tagData.nodeNumber);
                } else {
                    td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
                }
            } else if (t.getParent() == null) {
                td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
            }
        }
        this.pageCache.cache("org.makumba.tagData", t.getTagKey(), td);
        t.doStartAnalyze(this.pageCache);
        t.checkAttributeValues();
        this.elements.add(t);
    }

    void addExpression(AnalysableExpression e, ELData ed) {
        if (!this.parents.isEmpty()) {
            e.setParent(this.parents.get(this.parents.size() - 1));
        } else {
            e.setParent(null);
        }
        e.setKey(this.pageCache);
        this.pageCache.cache("org.makumba.el", e.getKey(), (Object)e);
        this.pageCache.cache("org.makumba.elData", e.getKey(), ed);
        e.analyze(this.pageCache);
        this.elements.add(e);
    }

    public void start(AnalysableTag t) {
        if (t == null) {
            return;
        }
        if (!(t instanceof BodyTag) && !t.canHaveBody()) {
            throw new ProgrammerError("This type of tag cannot have a body:\n " + t.getTagText());
        }
        this.parents.add(t);
    }

    public void end(TagData td) {
        String tagName = td.name;
        if (!tagName.startsWith(this.makumbaPrefix) && !tagName.startsWith(this.formPrefix)) {
            return;
        }
        if (this.parents.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Error: Closing tag never opened:\ntag \"").append(td.name).append("\" at line ");
            JspParseData.tagDataLine(td, sb);
            throw new ProgrammerError(sb.toString());
        }
        tagName = this.getTagName(tagName);
        AnalysableTag t = this.parents.get(this.parents.size() - 1);
        if (!((Object)((Object)t)).getClass().equals(MakumbaJspAnalyzer.tagClasses.get(tagName))) {
            StringBuffer sb = new StringBuffer();
            sb.append("Body tag nesting error:\ntag \"").append(td.name).append("\" at line ");
            JspParseData.tagDataLine(td, sb);
            sb.append("\n\ngot incorrect closing \"").append(td.name).append("\" at line ");
            JspParseData.tagDataLine(td, sb);
            throw new ProgrammerError(sb.toString());
        }
        this.parents.remove(this.parents.size() - 1);
    }

    private String getTagName(String tagName) {
        if (tagName.startsWith(this.makumbaPrefix)) {
            tagName = tagName.substring(this.makumbaPrefix.length() + 1);
        } else if (tagName.startsWith(this.formPrefix)) {
            tagName = tagName.substring(this.formPrefix.length() + 1);
        }
        return tagName;
    }

    public void endPage() {
        for (AnalysableElement analysableElement : this.elements) {
            if (!(analysableElement instanceof AnalysableTag)) continue;
            AnalysableTag t = (AnalysableTag)analysableElement;
            AnalysableElement.setAnalyzedElementData(t.tagData);
            t.doEndAnalyze(this.pageCache);
            AnalysableElement.setAnalyzedElementData(null);
        }
        this.formGraph.topo();
        this.pageCache.cache("org.makumba.dependency", "org.makumba.dependency", this.formGraph.getSortedKeys());
    }
}

