/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.DataTransformer;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;
import org.makumba.commons.NameResolver;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table {
    protected DataDefinition dd;
    Database db;
    Hashtable<String, DataDefinition> relatedTables = new Hashtable();
    String selectAllWithDbsv;
    Object[] selectLimits = null;
    static final int BAR = 75;
    DataTransformer insertHook;

    public Database getDatabase() {
        return this.db;
    }

    protected void setDataDefinition(DataDefinition dd) {
        this.dd = dd;
        for (String string : dd.getFieldNames()) {
            String name = string;
            FieldDefinition fd = dd.getFieldDefinition(name);
            if (fd.getType().equals("ptr") || fd.getType().equals("ptrRel")) {
                this.relatedTables.put(name, fd.getForeignTable());
                continue;
            }
            if ((!fd.getType().startsWith("ptr") || fd.getType().equals("ptrIndex")) && !fd.getType().startsWith("set")) continue;
            this.relatedTables.put(name, fd.getSubtable());
        }
    }

    public DataDefinition getDataDefinition() {
        return this.dd;
    }

    public FieldDefinition getFieldDefinition(String fieldName) {
        return this.dd.getFieldDefinition(fieldName);
    }

    public Table getRelatedTable(String field) {
        return this.getDatabase().getTable(this.relatedTables.get(field));
    }

    public abstract boolean canAdmin();

    public abstract boolean exists();

    public abstract int deleteFrom(DBConnection var1, DBConnection var2, boolean var3);

    public abstract boolean exists(String var1);

    void copyFrom(DBConnection dest, Table source, DBConnection sourceDB, boolean ignoreDbsv) {
        Vector<Dictionary<String, Object>> v;
        final String nm = this.getDataDefinition().getName();
        if (!source.exists() || nm.equals("org.makumba.db.makumba.Catalog")) {
            return;
        }
        if (this.selectAllWithDbsv == null) {
            StringBuffer list = new StringBuffer();
            String comma = "";
            for (String string : this.dd.getFieldNames()) {
                String name = string;
                if (this.dd.getFieldDefinition(name).getType().startsWith("set")) continue;
                list.append(comma);
                comma = ", ";
                list.append("t.").append(name);
            }
            String indexName = this.getDataDefinition().getIndexPointerFieldName();
            String dbsvLimitation = "";
            if (!ignoreDbsv) {
                dbsvLimitation = "WHERE t." + indexName + ">=$1 AND t." + indexName + " <=$2";
                this.selectLimits = new Object[2];
                final int dbsv = sourceDB.getHostDatabase().getDbsv();
                this.selectLimits[0] = new Pointer(){
                    private static final long serialVersionUID = 1L;

                    public String getType() {
                        return nm;
                    }

                    public long longValue() {
                        return dbsv << 24;
                    }
                };
                this.selectLimits[1] = new Pointer(){
                    private static final long serialVersionUID = 1L;

                    public String getType() {
                        return nm;
                    }

                    public long longValue() {
                        return (dbsv + 1 << 24) - 1;
                    }
                };
            }
            this.selectAllWithDbsv = "SELECT " + list + " FROM " + nm + " t " + dbsvLimitation;
        }
        if ((v = sourceDB.executeQuery(this.selectAllWithDbsv, this.selectLimits)).size() == 0) {
            Logger.getLogger("org.makumba.db.admin.copy").info(nm + ": no records to copy");
            return;
        }
        Logger.getLogger("org.makumba.db.admin.copy").info(nm + ": starting copying " + v.size() + " records");
        System.out.print("|");
        for (int b = 0; b < 75; ++b) {
            System.out.print("-");
        }
        System.out.print("|\n ");
        System.out.flush();
        float step = (float)v.size() / 75.0f;
        int stars = 0;
        Hashtable<String, Object> data = new Hashtable<String, Object>(23);
        Hashtable<String, String> nameKey = new Hashtable<String, String>(23);
        int f = 0;
        for (String string : this.dd.getFieldNames()) {
            String name = string;
            if (this.dd.getFieldDefinition(name).getType().startsWith("set")) continue;
            nameKey.put("col" + (f + 1), name);
            ++f;
        }
        for (int j = 0; j < v.size(); ++j) {
            Dictionary<String, Object> d = v.elementAt(j);
            Enumeration<String> e = d.keys();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                data.put((String)nameKey.get(k), d.get(k));
            }
            dest.insert(this.getDataDefinition().getName(), data);
            data.clear();
            v.setElementAt(null, j);
            int nstars = (int)(((float)j + 1.0f) / step);
            while (nstars > stars) {
                System.out.print("*");
                System.out.flush();
                ++stars;
            }
        }
        System.out.println();
    }

    protected abstract void open(Properties var1, NameResolver var2);

    void computeInsertHook() {
        String s;
        if (this.insertHook == null && (s = this.getDatabase().getConfiguration("insert#" + this.getDataDefinition().getName())) != null) {
            try {
                this.insertHook = (DataTransformer)Class.forName(s).newInstance();
            }
            catch (Exception e) {
                throw new DBError(e);
            }
        }
    }

    public abstract void close();

    public Pointer insertRecord(DBConnection c, Dictionary<String, Object> d) {
        return this.insertRecordImpl(c, d);
    }

    public abstract Pointer insertRecordImpl(DBConnection var1, Dictionary<String, Object> var2);

    public abstract void checkInsert(Dictionary<String, Object> var1, Dictionary<String, Object> var2, Dictionary<String, Object> var3);

    public abstract void checkUpdate(Pointer var1, Dictionary<String, Object> var2);

    public abstract void findDuplicates(DBConnection var1, Dictionary<String, Object> var2);
}

