/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.makumba.DBError;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.sql.Database;
import org.makumba.providers.TransactionProvider;

public class SQLDBConnection
extends DBConnection {
    static int nconn = 0;
    int n = nconn++;
    private Connection conn;

    SQLDBConnection(org.makumba.db.makumba.Database db, TransactionProvider tp, PooledDataSource pooledDataSource) throws SQLException {
        super(db, tp);
        this.makeConnection(pooledDataSource);
    }

    private void makeConnection(PooledDataSource pooledDataSource) throws SQLException {
        this.conn = pooledDataSource.getConnection();
        if (this.conn.getMetaData().supportsTransactions()) {
            this.conn.setAutoCommit(false);
        }
        if (this.conn.getMetaData().supportsTransactionIsolationLevel(4)) {
            this.conn.setTransactionIsolation(4);
        }
        if (Database.supportsUTF8()) {
            Statement st = this.createStatement();
            st.execute("SET CHARACTER SET utf8");
            st.close();
        }
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            Database.logException(e, this);
            throw new DBError(e);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            Database.logException(e, this);
            throw new DBError(e);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            Database.logException(e, this);
            throw new DBError(e);
        }
    }

    private Connection getConnection() throws SQLException {
        return this.conn;
    }

    public String toString() {
        return "connection " + this.n;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    public PreparedStatement getPreparedStatement(String s) {
        try {
            return this.getConnection().prepareStatement(s);
        }
        catch (SQLException e) {
            Database.logException(e);
            throw new DBError(e);
        }
    }
}

