/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import org.apache.commons.lang.StringUtils;
import org.makumba.commons.ReadableFormatter;

public class HtmlUtils {
    private static final int LENGTH_TO_CHECK = 32768;
    public static String[] specials = new String[]{"\"", "quot", "<", "lt", "&", "amp", ">", "gt"};
    public static String[] tagExamples = new String[]{"<head>", "<title>", "<html", "<meta", "<br>", "<p>", "</p>", "<b>", "</b>", "<font", "</font>", "</a>", "<ol>", "<ul>", "<li>", "<img ", "</table>", "<tr>", "</tr>", "<td>", "</td>", "<strong>", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>", "<em>", "<div>", "<span>"};

    public static boolean detectHtml(String s) {
        int i;
        if (s.length() > 32768) {
            s = s.substring(0, 32768);
        }
        s = s.toLowerCase();
        for (i = 1; i < specials.length; i += 2) {
            if (s.indexOf("&" + specials[i] + ";") == -1) continue;
            return true;
        }
        for (i = 0; i < tagExamples.length; ++i) {
            if (s.indexOf(tagExamples[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static String string2html(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            boolean special = false;
            for (int j = 0; j < specials.length; ++j) {
                if (s.charAt(i) != specials[j++].charAt(0)) continue;
                sb.append('&');
                sb.append(specials[j] + ";");
                special = true;
            }
            if (special) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static int maxLineLength(String s) {
        int r = 0;
        while (true) {
            int i;
            if ((i = s.indexOf(10)) == -1) {
                if (r > s.length()) {
                    return r;
                }
                return s.length();
            }
            if (i > r) {
                r = i;
            }
            if (i + 1 >= s.length()) break;
            s = s.substring(i + 1);
        }
        return r;
    }

    public static String text2html(String s, String startSeparator, String endSeparator) {
        s = HtmlUtils.string2html(s);
        String formatted = startSeparator;
        while (true) {
            int i;
            if ((i = s.indexOf(10)) == -1) {
                return formatted + s + endSeparator;
            }
            if (i > 0) {
                formatted = formatted + s.substring(0, i) + endSeparator + startSeparator;
            }
            if (i + 1 >= s.length()) break;
            s = s.substring(i + 1);
        }
        return formatted + endSeparator;
    }

    public static String stripHTMLTags(String str) {
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("<[^>]*>", "");
        return str;
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\"", "\\\"");
        str = str.replace("'", "\\'");
        return str;
    }

    public static void main(String[] args) {
        String s = "Indeed, during this event, we'll make a great general overview on all kind of transport, from planes to trains, cars and even subways; with a visit in well-known companies for each transport (Airbus, Toyota, TGV.). So lets. So mainly, you.ll be provided a lot of information about the new transportation systems either made or used in France. Do you really believe that this great topic will be the only main thing we.ll do ?? Come on !! Of course not !!! Lets so go. Another main issue of our event is FUN, FUN, FUN and FUN again !!!! At the same time you will discover our city, our region and their secrets. And maybe have the great opportunity to enjoy a week-end trip to Paris (it.s far to be sure but we.re trying our BEST to make you happy !) But don.t worry we.ll find something else if it.s not possible  ;-)  and want to watch the video of our last event click Come and have a look what we can do and if there are any bugs that should be tested and rooted out of here whle at it so what do you think about themall dinosaurs <b> BOLD TEXT </b> if not then the HTML auto detection does not work for this text.";
        int repeats = 50;
        s = StringUtils.repeat((String)s, (int)repeats);
        System.out.println("size: " + ReadableFormatter.readableBytes(s.length()));
        System.out.println("checking: " + ReadableFormatter.readableBytes(32768L));
        long start = System.currentTimeMillis();
        System.out.println("is HTML: " + HtmlUtils.detectHtml(s));
        long duration = System.currentTimeMillis() - start;
        System.out.println("took ms: " + duration);
    }
}

