/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.hibernate.Hibernate;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Transaction;
import org.makumba.commons.NamedResources;
import org.makumba.forms.html.CalendarEditorProvider;
import org.makumba.forms.html.KruseCalendarEditor;
import org.makumba.forms.validation.ClientsideValidationProvider;
import org.makumba.forms.validation.LiveValidationProvider;
import org.makumba.forms.validation.MDDLiveValidationProvider;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.mdd.MDDProvider;
import org.makumba.version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaSystem {
    private static DataDefinitionProvider MDDFactory = DataDefinitionProvider.getInstance();
    private static TransactionProvider tp = TransactionProvider.getInstance();
    public static final Date loadingTime = new Date();
    static String loggingRoot = "org.makumba";

    public static Map<String, int[]> getCacheInfo() {
        return NamedResources.getCacheInfo();
    }

    public static String getDefaultDatabaseName() {
        return tp.getDefaultDataSourceName();
    }

    @Deprecated
    public static Transaction getConnectionTo(String name) {
        return tp.getConnectionTo(name);
    }

    public static Transaction findDatabase() {
        return MakumbaSystem.getConnectionTo(tp.getDefaultDataSourceName());
    }

    public static Transaction getDatabase(String connectionFile) {
        return MakumbaSystem.getConnectionTo(connectionFile);
    }

    @Deprecated
    public static DataDefinition getDataDefinition(String typeName) {
        return MDDFactory.getDataDefinition(typeName);
    }

    @Deprecated
    public static DataDefinition getTemporaryDataDefinition(String name) {
        return MDDFactory.getVirtualDataDefinition(name);
    }

    @Deprecated
    public static FieldDefinition makeFieldDefinition(String name, String definition) {
        return MDDFactory.makeFieldDefinition(name, definition);
    }

    @Deprecated
    public static FieldDefinition makeFieldOfType(String name, String type) {
        return MDDFactory.makeFieldOfType(name, type);
    }

    @Deprecated
    public static FieldDefinition makeFieldWithName(String name, FieldDefinition type) {
        return MDDFactory.makeFieldWithName(name, type);
    }

    @Deprecated
    public static FieldDefinition makeFieldOfType(String name, String type, String description) {
        return MDDFactory.makeFieldOfType(name, type, description);
    }

    @Deprecated
    public static FieldDefinition makeFieldWithName(String name, FieldDefinition type, String description) {
        return MDDFactory.makeFieldWithName(name, type, description);
    }

    public static String getVersion() {
        return version.getVersion();
    }

    public static Date getBuildDate() {
        return version.getBuildDate();
    }

    public static Logger getMakumbaLogger(String suffix) {
        return Logger.getLogger("org.makumba." + suffix);
    }

    public static Logger getLogger(String suffix) {
        return Logger.getLogger("org.makumba.apps." + suffix);
    }

    public static Logger getLogger() {
        return Logger.getLogger("org.makumba.apps");
    }

    public static void setLoggingRoot(String root) {
        loggingRoot = root;
    }

    public static TimeZone getTimeZone() {
        String s = null;
        try {
            s = System.getProperty("makumba.displayTimeZone");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (s != null) {
            return TimeZone.getTimeZone(s);
        }
        return TimeZone.getDefault();
    }

    public static Locale getLocale() {
        return Locale.UK;
    }

    public static Vector<String> mddsInDirectory(String dirInClasspath) {
        return MDDFactory.getDataDefinitionsInLocation(dirInClasspath);
    }

    public static CalendarEditorProvider getCalendarProvider() {
        return KruseCalendarEditor.getInstance();
    }

    public static ClientsideValidationProvider getClientsideValidationProvider() {
        if (MDDFactory instanceof MDDProvider) {
            return new MDDLiveValidationProvider();
        }
        return new LiveValidationProvider();
    }

    public static String getHibernateVersionNumber() {
        String version2 = "unknown";
        String resourceName = "/" + Hibernate.class.getName().replaceAll("\\.", "/") + ".class";
        URL resource = Hibernate.class.getResource(resourceName);
        String pathToThisClass = resource.toString();
        String manifestPath = pathToThisClass.substring(0, pathToThisClass.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            if (manifest != null && manifest.getMainAttributes() != null && manifest.getMainAttributes().getValue("Hibernate-Version") != null) {
                version2 = manifest.getMainAttributes().getValue("Hibernate-Version");
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return version2;
    }
}

