/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser;

import java.util.ListIterator;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.makumba.MakumbaError;
import org.makumba.analyser.ElementData;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.analyser.interfaces.JspAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysableElement
extends TagSupport {
    private static final long serialVersionUID = 1L;
    public static final String ANALYSIS_STATE = "org.makumba.analysisState";
    private static ThreadLocal<ElementData> analyzedElement = new ThreadLocal();
    private static ThreadLocal<ElementData> runningElement = new ThreadLocal();
    private static ThreadLocal<Stack<ElementData>> elementStack = new ThreadLocal();
    private static transient ThreadLocal<JspParseData> jspParser = new ThreadLocal();

    public static void initializeThread(HttpSession session) {
        AnalysableElement.getThreadElementStack().clear();
        runningElement.set(null);
        analyzedElement.set(null);
        Object[] analysisState = (Object[])session.getServletContext().getAttribute(ANALYSIS_STATE + session.getId());
        if (analysisState != null) {
            analyzedElement.set((ElementData)analysisState[0]);
            runningElement.set((ElementData)analysisState[1]);
            elementStack.set((Stack)analysisState[2]);
            jspParser.set((JspParseData)analysisState[3]);
        }
    }

    public static void discardJSPParsingData() {
        if (jspParser.get() != null) {
            jspParser.get().discardParsingData();
        }
    }

    public static void keepAnalysisState(HttpSession session) {
        Object[] analysisState = new Object[]{analyzedElement.get(), runningElement.get(), AnalysableElement.getThreadElementStack(), jspParser.get()};
        session.getServletContext().setAttribute(ANALYSIS_STATE + session.getId(), (Object)analysisState);
    }

    public static ElementData getAnalyzedElementData() {
        return analyzedElement.get();
    }

    public static void setAnalyzedElementData(ElementData data) {
        analyzedElement.set(data);
    }

    public static ElementData getRunningElementData() {
        return runningElement.get();
    }

    public static void setRunningElementData(ElementData data) {
        runningElement.set(data);
    }

    public static Stack<ElementData> getThreadElementStack() {
        Stack<ElementData> s = elementStack.get();
        if (s == null) {
            s = new Stack();
            elementStack.set(s);
        }
        return s;
    }

    public static TagData getCurrentBodyTagData() {
        if (AnalysableElement.getThreadElementStack().isEmpty()) {
            return null;
        }
        ListIterator l = AnalysableElement.getThreadElementStack().listIterator(AnalysableElement.getThreadElementStack().size());
        while (l.hasPrevious()) {
            ElementData d = (ElementData)l.previous();
            if (!(d instanceof TagData)) continue;
            return (TagData)d;
        }
        return null;
    }

    public abstract ElementData getElementData();

    public static PageCache getPageCache(HttpServletRequest request, String realPath, JspAnalyzer analyzer) throws MakumbaError {
        JspParseData parseData = JspParseData.getParseData(realPath, TomcatJsp.getJspURI(request), analyzer);
        jspParser.set(parseData);
        Object result = parseData.getAnalysisResult(null);
        if (result instanceof Throwable) {
            if (result instanceof MakumbaError) {
                throw (MakumbaError)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            throw new RuntimeException((Throwable)result);
        }
        return (PageCache)result;
    }

    public static PageCache getPageCache(PageContext pageContext, JspAnalyzer analyzer) {
        PageCache pageCache = (PageCache)pageContext.getAttribute("makumba.parse.cache");
        if (pageCache == null) {
            pageCache = AnalysableElement.getPageCache((HttpServletRequest)pageContext.getRequest(), pageContext.getServletConfig().getServletContext().getRealPath("/"), analyzer);
            pageContext.setAttribute("makumba.parse.cache", (Object)pageCache);
        }
        return pageCache;
    }
}

