/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.ProgrammerError;
import org.makumba.analyser.engine.SyntaxPoint;

public class SourceSyntaxPoints {
    File file;
    PreprocessorClient client;
    long lastChanged;
    TreeSet<SyntaxPoint> syntaxPoints = new TreeSet();
    ArrayList<SyntaxPoint> lineBeginnings = new ArrayList();
    ArrayList<Integer> fileBeginningIndexes = new ArrayList();
    ArrayList<SourceSyntaxPoints> fileBeginnings = new ArrayList();
    String originalText;
    String content;
    int offset;
    SourceSyntaxPoints parent;

    public String toString() {
        return this.file.toString() + " " + this.offset;
    }

    public SourceSyntaxPoints(File f, PreprocessorClient cl) {
        this(f, cl, null, null, 0);
    }

    public SourceSyntaxPoints(File f, PreprocessorClient cl, SourceSyntaxPoints parent, String includeDirective, int offset) {
        int i;
        this.offset = offset;
        this.parent = parent;
        this.file = f;
        this.client = cl;
        this.lastChanged = this.file.lastModified();
        this.content = this.originalText = this.readFile(includeDirective);
        this.fileBeginningIndexes.add(new Integer(0));
        this.fileBeginnings.add(this);
        this.findLineBreaks();
        if (this.client.getLiteralPatterns() != null) {
            for (i = 0; i < this.client.getLiteralPatterns().length; ++i) {
                this.treatLiterals(i);
            }
        }
        if (this.client.getCommentPatterns() != null) {
            for (i = 0; i < this.client.getCommentPatterns().length; ++i) {
                this.unComment(i);
            }
        }
        if (this.client.getIncludePattern() != null) {
            this.include();
        }
    }

    void findLineBreaks() {
        int start = 0;
        int line = 1;
        int max = this.originalText.length();
        for (int i = 0; i < max; ++i) {
            if (this.originalText.charAt(i) == '\r') {
                if (i + 1 < max && this.originalText.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (this.originalText.charAt(i) != '\n') continue;
            this.addSyntaxPointsLine(start, i, "TextLine", new Integer(line));
            start = i + 1;
            ++line;
        }
        if (start < max) {
            this.addSyntaxPointsLine(start, max, "TextLine", new Integer(line));
        }
    }

    public String getLineText(int n) {
        SyntaxPoint line = this.lineBeginnings.get(n - 1);
        if (n == this.lineBeginnings.size()) {
            return this.originalText.substring(line.getOriginalPosition());
        }
        SyntaxPoint nextline = this.lineBeginnings.get(n);
        return this.originalText.substring(line.getOriginalPosition(), nextline.getOriginalPosition() - 1);
    }

    void include() {
        Matcher m;
        while ((m = this.client.getIncludePattern().matcher(this.content)).find()) {
            SyntaxPoint.End end = this.addSyntaxPoints(m.start() + this.offset, m.end() + this.offset, "JSPIncludeDirective", this.content.substring(m.start(), m.end()));
            SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
            this.client.treatInclude(m.start(), this.content.substring(m.start(), m.end()), start, end, this);
        }
        return;
    }

    public void include(File f, int position, String includeDirective) {
        SourceSyntaxPoints sf = new SourceSyntaxPoints(f, this.client, this, includeDirective, position + this.offset);
        int delta = sf.getContent().length() - includeDirective.length();
        StringBuffer sb = new StringBuffer();
        sb.append(this.content.substring(0, position)).append(sf.getContent()).append(this.content.substring(position + includeDirective.length()));
        this.content = sb.toString();
        for (SyntaxPoint sp : this.syntaxPoints) {
            if (sp.position <= position + this.offset || sp.getType().equals("JSPIncludeDirective")) continue;
            sp.moveByInclude(delta);
        }
        int n = this.fileBeginningIndexes.size() - 1;
        if (this.fileBeginningIndexes.get(n) == position) {
            this.fileBeginnings.set(n, sf);
        } else {
            this.fileBeginningIndexes.add(position);
            this.fileBeginnings.add(sf);
        }
        this.fileBeginningIndexes.add(new Integer(position + delta));
        this.fileBeginnings.add(this);
    }

    void unComment(int patternIndex) {
        this.unComment(this.client.getCommentPatterns()[patternIndex], this.client.getCommentPatternNames()[patternIndex]);
    }

    private void unComment(Pattern pattern, String patternName) {
        Matcher m = pattern.matcher(this.content);
        int endOfLast = 0;
        StringBuffer uncommentedContent = new StringBuffer();
        while (m.find()) {
            uncommentedContent.append(this.content.substring(endOfLast, m.start()));
            for (int i = m.start(); i < m.end(); ++i) {
                uncommentedContent.append(' ');
            }
            endOfLast = m.end();
            Logger.getLogger("org.makumba.syntaxpoint.comment").fine("UNCOMMENT " + patternName + " : " + m.group());
            this.addSyntaxPoints(m.start() + this.offset, m.end() + this.offset, patternName, null);
        }
        uncommentedContent.append(this.content.substring(endOfLast));
        this.content = uncommentedContent.toString();
    }

    void treatLiterals(int patternIndex) {
        this.unComment(this.client.getLiteralPatterns()[patternIndex], this.client.getLiteralPatternNames()[patternIndex]);
    }

    public SyntaxPoint.End addSyntaxPoints(int start, int end, String type, Object extra) {
        SourceSyntaxPoints ssp = this.findSourceFile(start);
        if (ssp == this) {
            return this.addSyntaxPoints1(start, end, type, extra);
        }
        return ssp.addSyntaxPoints(start, end, type, extra);
    }

    SyntaxPoint.End addSyntaxPoints1(int start, int end, String type, Object extra) {
        SyntaxPoint.End e = this.addSyntaxPointsCommon(start, end, type, extra);
        this.setLineAndColumn(e);
        this.setLineAndColumn((SyntaxPoint)e.getOtherInfo());
        return e;
    }

    void setLineAndColumn(SyntaxPoint point) {
        SyntaxPoint lineBegin = this.lineBeginnings.get(-1 * Collections.binarySearch(this.lineBeginnings, point) - 2);
        point.line = lineBegin.line;
        point.column = point.position - lineBegin.position + 1;
        point.sourceFile = this;
    }

    SourceSyntaxPoints findSourceFile(int position) {
        int index = Collections.binarySearch(this.fileBeginningIndexes, new Integer(position - this.offset));
        if (index < 0) {
            index = -index - 2;
        }
        return this.fileBeginnings.get(index);
    }

    SyntaxPoint.End addSyntaxPointsCommon(int start, int end, String type, Object extra) {
        final String type1 = type;
        final Object extra1 = extra;
        SyntaxPoint point = new SyntaxPoint(start){

            public String getType() {
                return type1;
            }

            public Object getOtherInfo() {
                return extra1;
            }
        };
        this.syntaxPoints.add(point);
        SyntaxPoint.End theEnd = (SyntaxPoint.End)SyntaxPoint.makeEnd(point, end);
        this.syntaxPoints.add(theEnd);
        return theEnd;
    }

    void addSyntaxPointsLine(int start, int end, String type, Object extra) {
        SyntaxPoint.End e = this.addSyntaxPointsCommon(start, end, type, extra);
        e.moveByInclude(this.offset);
        SyntaxPoint lineBegin = (SyntaxPoint)e.getOtherInfo();
        lineBegin.moveByInclude(this.offset);
        lineBegin.line = e.line = ((Integer)lineBegin.getOtherInfo()).intValue();
        lineBegin.column = 1;
        e.column = end - start + 1;
        e.sourceFile = lineBegin.sourceFile = this;
        this.lineBeginnings.add(lineBegin);
    }

    boolean unchanged() {
        if (this.file.lastModified() != this.lastChanged) {
            return false;
        }
        for (SourceSyntaxPoints ss : this.fileBeginnings) {
            if (ss == this || ss.unchanged()) continue;
            return false;
        }
        return true;
    }

    String readFile(String includeDirective) {
        StringBuffer sb = new StringBuffer();
        try {
            int n;
            BufferedReader rd = new BufferedReader(new FileReader(this.file));
            char[] buffer = new char[2048];
            while ((n = rd.read(buffer)) != -1) {
                sb.append(buffer, 0, n);
            }
        }
        catch (FileNotFoundException e) {
            String msg = "File '" + this.file.getName() + "' not found.\n\t(" + e.getMessage() + ")";
            msg = includeDirective != null ? "Error in include directive:\n\n" + includeDirective + "\n\n" + msg : "Error in reading a file: " + msg;
            throw new ProgrammerError(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    String getContent() {
        return this.content;
    }

    public SyntaxPoint[] getSyntaxPoints() {
        ArrayList<SyntaxPoint> list = new ArrayList<SyntaxPoint>(this.syntaxPoints);
        Collections.sort(list);
        SyntaxPoint[] result = list.toArray(new SyntaxPoint[this.syntaxPoints.size()]);
        int i = 0;
        while (i + 1 < result.length) {
            if (result[i].getType().equals("TextLine") && result[i + 1].getType().equals("TextLine") && result[i].getLine() == result[i + 1].getLine() && result[i].getColumn() == result[i + 1].getColumn() && !result[i].isBegin() && result[i + 1].isBegin()) {
                SyntaxPoint temp = result[i];
                result[i] = result[i + 1];
                result[i + 1] = temp;
            }
            ++i;
        }
        return result;
    }

    public void discardPoints() {
        for (SourceSyntaxPoints s : this.fileBeginnings) {
            if (s == this) continue;
            s.discardPoints();
        }
        this.originalText = null;
        this.content = null;
        this.fileBeginningIndexes = null;
        this.lineBeginnings = null;
        this.syntaxPoints = null;
    }

    public File getFile() {
        return this.file;
    }

    public static interface PreprocessorClient {
        public void treatInclude(int var1, String var2, SyntaxPoint var3, SyntaxPoint var4, SourceSyntaxPoints var5);

        public Pattern[] getCommentPatterns();

        public String[] getCommentPatternNames();

        public Pattern[] getLiteralPatterns();

        public String[] getLiteralPatternNames();

        public Pattern getIncludePattern();

        public String getIncludePatternName();

        public SourceSyntaxPoints getSyntaxPoints();

        public SyntaxPoint[] getSyntaxPointArray(Object var1);
    }
}

