/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

public class Base64 {
    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(Base64.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Base64.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        for (int i2 = 0; i2 < base64.length(); i2 += 4) {
            int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
            for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }
}

