/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.makumba.commons.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final Logger logger = Logger.getLogger("org.makumba.fileutils");

    public static ArrayList<String> getAllFilesInDirectory(String root, String[] skipPaths, FileFilter filter) {
        File f = new File(root);
        ArrayList<String> allFiles = new ArrayList<String>();
        FileUtils.processFilesInDirectory(root, skipPaths, f, allFiles, filter);
        return allFiles;
    }

    public static void processFilesInDirectory(String root, String[] skipPaths, File f, ArrayList<String> allFiles, FileFilter filter) {
        if (!f.exists()) {
            logger.warning("Couldn't read files of directory " + f.getAbsolutePath() + ": file does not exist");
            return;
        }
        File[] fileList = f.listFiles(filter);
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) {
                FileUtils.processFilesInDirectory(root, skipPaths, fileList[i], allFiles, filter);
                continue;
            }
            try {
                String fileName = fileList[i].getCanonicalPath().substring(root.length());
                if (StringUtils.startsWith(fileName, skipPaths)) {
                    logger.info("Skipping file " + fileName + ", indicated in skip-list " + Arrays.toString(skipPaths));
                    continue;
                }
                allFiles.add(fileName);
                continue;
            }
            catch (IOException e) {
                logger.warning("Could not compute canonical path for " + fileList[i].getAbsolutePath());
            }
        }
    }

    public static InputStream getInputStream(URL url) throws IOException {
        if (!url.toExternalForm().startsWith("jar:")) {
            return url.openStream();
        }
        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
        return jar.getInputStream(((JarURLConnection)url.openConnection()).getJarEntry());
    }
}

