/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import org.makumba.commons.MultipleKey;
import org.makumba.commons.Vertex;

public class GraphTS {
    private final int MAX_VERTS = 40;
    private Vertex[] vertexList = new Vertex[40];
    private int[][] matrix = new int[40][40];
    private int numVerts = 0;
    private MultipleKey[] sortedArray;

    public GraphTS() {
        for (int i = 0; i < 40; ++i) {
            for (int k = 0; k < 40; ++k) {
                this.matrix[i][k] = 0;
            }
        }
        this.sortedArray = new MultipleKey[40];
    }

    public void addVertex(char lab) {
        this.vertexList[this.numVerts++] = new Vertex(lab);
    }

    public int addVertex(MultipleKey tagKey) {
        this.vertexList[this.numVerts++] = new Vertex(tagKey);
        return this.numVerts - 1;
    }

    public void addEdge(int start, int end) {
        this.matrix[start][end] = 1;
    }

    public void displayVertex(int v) {
        System.out.print(this.vertexList[v].label);
    }

    public MultipleKey[] getSortedKeys() {
        return this.sortedArray;
    }

    public void topo() {
        while (this.numVerts > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                System.out.println("ERROR: Graph has cycles");
                return;
            }
            this.sortedArray[this.numVerts - 1] = this.vertexList[currentVertex].tagKey;
            this.deleteVertex(currentVertex);
        }
    }

    public int noSuccessors() {
        for (int row = 0; row < this.numVerts; ++row) {
            boolean isEdge = false;
            for (int col = 0; col < this.numVerts; ++col) {
                if (this.matrix[row][col] <= 0) continue;
                isEdge = true;
                break;
            }
            if (isEdge) continue;
            return row;
        }
        return -1;
    }

    public void deleteVertex(int delVert) {
        if (delVert != this.numVerts - 1) {
            for (int j = delVert; j < this.numVerts - 1; ++j) {
                this.vertexList[j] = this.vertexList[j + 1];
            }
            for (int row = delVert; row < this.numVerts - 1; ++row) {
                this.moveRowUp(row, this.numVerts);
            }
            for (int col = delVert; col < this.numVerts - 1; ++col) {
                this.moveColLeft(col, this.numVerts - 1);
            }
        }
        --this.numVerts;
    }

    private void moveRowUp(int row, int length) {
        for (int col = 0; col < length; ++col) {
            this.matrix[row][col] = this.matrix[row + 1][col];
        }
    }

    private void moveColLeft(int col, int length) {
        for (int row = 0; row < length; ++row) {
            this.matrix[row][col] = this.matrix[row][col + 1];
        }
    }

    public static void main(String[] args) {
        GraphTS g = new GraphTS();
        g.addVertex('A');
        g.addVertex('B');
        g.addVertex('C');
        g.addVertex('D');
        g.addVertex('E');
        g.addVertex('F');
        g.addVertex('G');
        g.addVertex('H');
        g.addEdge(0, 3);
        g.addEdge(0, 4);
        g.addEdge(1, 4);
        g.addEdge(2, 5);
        g.addEdge(3, 6);
        g.addEdge(4, 6);
        g.addEdge(5, 7);
        g.addEdge(6, 7);
        g.topo();
    }
}

