/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class HtmlTagEnumerator {
    Reader source;
    StringBuffer tag;
    StringBuffer string;
    String lastString;
    String lastTag;
    boolean inTag = false;
    boolean ended = false;

    void init() {
        this.tag = new StringBuffer();
        this.string = new StringBuffer();
    }

    public HtmlTagEnumerator(Reader r) {
        this.source = r;
        this.init();
    }

    public boolean next() throws IOException {
        int c;
        if (this.ended) {
            return false;
        }
        while ((c = this.source.read()) != -1) {
            if (c == 60) {
                this.lastString = this.string.toString();
                this.inTag = true;
                this.string = new StringBuffer();
                continue;
            }
            if (c == 62 && this.inTag) {
                this.lastTag = this.tag.toString();
                this.tag = new StringBuffer();
                this.inTag = false;
                return true;
            }
            if (this.inTag) {
                this.tag.append((char)c);
                continue;
            }
            this.string.append((char)c);
        }
        this.source.close();
        this.ended = true;
        return false;
    }

    public String getNonHtml() {
        return this.lastString;
    }

    public String getTag() {
        return this.lastTag;
    }

    public String getTagType() {
        String s = this.lastTag.trim();
        int i = 0;
        if (s.startsWith("/")) {
            i = 1;
        }
        while (i < s.length() && Character.isLetter(s.charAt(i))) {
            ++i;
        }
        return s.substring(0, i);
    }

    public static void main(String[] argv) throws IOException {
        HtmlTagEnumerator e = new HtmlTagEnumerator(new FileReader(argv[0]));
        while (e.next()) {
            System.out.println(e.getNonHtml() + " " + e.getTag() + " " + e.getTagType());
        }
    }
}

