/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Logger;
import org.makumba.Text;

public class LongData {
    int length = 0;
    LongDataStrategy ds = new EmptyStrategy();

    public LongData() {
    }

    public LongData(InputStream is) throws IOException {
        this.appendFrom(new InputStreamReader(is));
    }

    public void appendFrom(Reader r) throws IOException {
        int n;
        char[] buffer = new char[Text.FILE_LIMIT];
        while ((n = r.read(buffer, 0, buffer.length)) != -1) {
            byte[] b = new String(buffer, 0, n).getBytes();
            this.ds.append(b, 0, b.length);
            this.length += b.length;
        }
    }

    public void appendFrom(InputStream i) throws IOException {
        int n;
        byte[] buffer = new byte[Text.FILE_LIMIT];
        while ((n = i.read(buffer, 0, buffer.length)) != -1) {
            this.ds.append(buffer, 0, n);
            this.length += n;
        }
    }

    public int getLength() {
        return this.length;
    }

    public InputStream getInputStream() throws IOException {
        return this.ds.getInputStream();
    }

    class FileStrategy
    implements LongDataStrategy {
        File temp = File.createTempFile("makumbaLongContent", ".bin", null);
        OutputStream out;

        FileStrategy() throws IOException {
            this.temp.deleteOnExit();
            Logger.getLogger("org.makumba.util.longContent").fine("writing to " + this.temp);
            this.out = new BufferedOutputStream(new FileOutputStream(this.temp), Text.FILE_LIMIT);
        }

        public void append(byte[] b, int start, int len) throws IOException {
            this.out.write(b, start, len);
        }

        public InputStream getInputStream() throws IOException {
            this.out.close();
            return new BufferedInputStream(new FileInputStream(this.temp));
        }

        protected void finalize() {
            this.temp.delete();
        }
    }

    class DataStrategy
    implements LongDataStrategy {
        ByteArrayOutputStream bout;

        DataStrategy(int n) {
            this.bout = new ByteArrayOutputStream(n);
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bout.toByteArray(), 0, this.bout.size());
        }

        public void append(byte[] b, int start, int len) throws IOException {
            if (LongData.this.length + len >= Text.FILE_LIMIT) {
                LongData.this.ds = new FileStrategy();
                LongData.this.ds.append(this.bout.toByteArray(), 0, this.bout.size());
                LongData.this.ds.append(b, start, len);
                this.bout = null;
            } else {
                this.bout.write(b, start, len);
            }
        }
    }

    class EmptyStrategy
    implements LongDataStrategy {
        EmptyStrategy() {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(new byte[0], 0, 0);
        }

        public void append(byte[] b, int start, int len) throws IOException {
            LongData.this.ds = LongData.this.length + len >= Text.FILE_LIMIT ? new FileStrategy() : new DataStrategy(len);
            LongData.this.ds.append(b, start, len);
        }
    }

    static interface LongDataStrategy {
        public InputStream getInputStream() throws IOException;

        public void append(byte[] var1, int var2, int var3) throws IOException;
    }
}

