/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.makumba.commons.StringUtils;
import org.makumba.version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaTLDGenerator {
    private static final String TAGLIB_MAK = "taglib.tld";
    private static final String TAGLIB_HIBERNATE = "taglib-hibernate.tld";
    private static final String HIBERNATE_TLD_URI = "http://www.makumba.org/view-hql";
    private static final String TAGLIB_DOCUMENTED_XML = "taglib-documented.xml";

    public static void main(String[] args) {
        HashMap<String, Element> processedTags = new HashMap<String, Element>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        String sourcePath = new File(args[0]) + File.separator + TAGLIB_DOCUMENTED_XML;
        String documentationPath = new File(args[1]).getAbsolutePath();
        try {
            document = saxReader.read(sourcePath);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        String errorMsg = "Error processing '" + sourcePath + "': ";
        Element root = document.getRootElement();
        for (Element tag : root.elements()) {
            if (tag.getName().equals("description")) {
                tag.setText(tag.getText().replace("@version@", version.getVersion()));
            }
            boolean isTag = false;
            isTag = tag.getName().equals("tag") || tag.getName().equals("function");
            if (!isTag) continue;
            Element name = tag.element("name");
            String tagName = name.getText();
            for (Element tagContent : tag.elements()) {
                if (tagContent.getName().equals("attribute")) {
                    if (tagContent.attributeValue("name") != null || tagContent.attributeValue("specifiedIn") != null) {
                        Element newTag = MakumbaTLDGenerator.getReferencedAttributes(processedTags, errorMsg, tag, tagName, tagContent);
                        tagContent.setAttributes(newTag.attributes());
                        List elements = newTag.elements();
                        for (Element element : elements) {
                            tagContent.add((Element)element.clone());
                        }
                    } else {
                        for (Element attributeContent : tagContent.elements()) {
                            String inheritedFrom = null;
                            if (attributeContent.getName().equals("inheritedFrom")) {
                                inheritedFrom = attributeContent.getText();
                            }
                            if (StringUtils.equalsAny(attributeContent.getName(), "comments", "deprecated", "descriptionPage", "commentsPage", "inheritedFrom")) {
                                attributeContent.getParent().remove(attributeContent);
                            }
                            if (!attributeContent.getName().equals("description")) continue;
                            String descriptionFileName = "";
                            descriptionFileName = inheritedFrom != null ? descriptionFileName + org.apache.commons.lang.StringUtils.capitalize((String)inheritedFrom) + (isTag ? "Tag" : "Function") : descriptionFileName + org.apache.commons.lang.StringUtils.capitalize((String)tagName) + (isTag ? "Tag" : "Function");
                            descriptionFileName = descriptionFileName + "Attribute" + org.apache.commons.lang.StringUtils.capitalize((String)tagContent.elementText("name")) + "AttributeDescription";
                            File d = new File(documentationPath + File.separator + descriptionFileName + ".txt");
                            if (!d.exists()) {
                                throw new RuntimeException("Could not find attribute description file " + d);
                            }
                            String desc = "";
                            try {
                                desc = MakumbaTLDGenerator.readFileAsString(d.getAbsolutePath());
                            }
                            catch (IOException e) {
                                System.err.println("Could not read attribute description file " + d);
                            }
                            attributeContent.setText(desc.trim());
                        }
                    }
                }
                if (StringUtils.equalsAny(tagContent.getName(), "see", "example")) {
                    tagContent.getParent().remove(tagContent);
                }
                if (!tagContent.getName().equals("descriptionPage")) continue;
                String descriptionFileName = org.apache.commons.lang.StringUtils.capitalize((String)tagName) + (isTag ? "Tag" : "Function") + "Description";
                String desc = "";
                try {
                    desc = MakumbaTLDGenerator.readFileAsString(documentationPath + File.separator + descriptionFileName + ".txt");
                }
                catch (IOException e1) {
                    System.err.println("Could not read tag description file " + documentationPath + File.separator + descriptionFileName + ".txt");
                }
                Element d = null;
                d = tagContent.getParent().element("description");
                if (d == null) {
                    d = tagContent.getParent().addElement("description");
                }
                d.setText(desc.trim());
                tagContent.getParent().remove(tagContent);
            }
            processedTags.put(tagName, tag);
        }
        String tldPath = args[0] + File.separator + TAGLIB_MAK;
        System.out.println("Writing general Makumba TLD at path " + tldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(tldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        Document hibernateTLD = document;
        hibernateTLD.getRootElement().element("uri").setText(HIBERNATE_TLD_URI);
        String hibernateTldPath = args[0] + File.separator + TAGLIB_HIBERNATE;
        System.out.println("Writing hibernate Makumba TLD at path " + hibernateTldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(hibernateTldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
    }

    public static Element getReferencedAttributes(HashMap<String, Element> processedTags, String errorMsg, Element tag, String tagName, Element tagContent) {
        Element element;
        String specifiedIn = tagContent.attributeValue("specifiedIn");
        String attribute = tagContent.attributeValue("name");
        Element copyFrom = processedTags.get(specifiedIn);
        if (copyFrom == null) {
            System.out.println(errorMsg + "tag '" + tagName + "' specifies an invalid source tag to copy attributes from: '" + specifiedIn + "'. Make sure that the source tag exists and is defined BEFORE the tag copying!");
            System.exit(-1);
        }
        if ((element = MakumbaTLDGenerator.getAttributeFromTag(copyFrom, attribute)) == null) {
            System.out.println(errorMsg + "tag '" + tagName + "' specifies an not-existing source attribute '" + attribute + "' to copy from tag '" + specifiedIn + "'!");
            System.exit(-1);
        }
        element.addAttribute("inheritedFrom", specifiedIn);
        return element;
    }

    private static Element getAttributeFromTag(Element tag, String attribute) {
        for (Element tagContent : tag.elements()) {
            if (!tagContent.getName().equals("attribute") || tagContent.element("name") == null || !tagContent.element("name").getText().equals(attribute)) continue;
            return (Element)tagContent.clone();
        }
        return null;
    }

    public static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(filePath));
        f.read(buffer);
        return new String(buffer);
    }
}

