/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.logging.Logger;
import org.makumba.Pointer;

public class SQLPointer
extends Pointer {
    private static final long serialVersionUID = 1L;

    static long compute(int dbsv, int uid) {
        return (dbsv << 24) + uid;
    }

    public static int getMaskOrder() {
        return 24;
    }

    private SQLPointer(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public SQLPointer(String type, long n) {
        this(type);
        this.n = n;
    }

    public SQLPointer(String type, int dbsv, int uid) {
        this(type);
        if (uid > 0x1000000) {
            Logger.getLogger("org.makumba.debug.db").finest("p");
            this.n = uid;
        } else {
            this.n = SQLPointer.compute(dbsv, uid);
        }
    }

    public SQLPointer(String type, String s) {
        this(type);
        int separator = s.indexOf(":");
        int dbsv = new Integer(s.substring(0, separator));
        int uid = new Integer(s.substring(separator + 1, s.length()));
        this.n = SQLPointer.compute(dbsv, uid);
    }
}

