/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.collections.EnumerationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final String DEFAULT_DELIMETER = ", ";

    public static String lowerCaseBeginning(String s) {
        return String.valueOf(s.charAt(0)).toLowerCase() + s.substring(1);
    }

    public static String upperCaseBeginning(String s) {
        return String.valueOf(s.charAt(0)).toUpperCase() + s.substring(1);
    }

    public static boolean notEmpty(Object o) {
        return o != null && o instanceof String && o.toString().length() > 0;
    }

    public static boolean anyNotEmpty(String[] o) {
        for (String element : o) {
            if (!org.apache.commons.lang.StringUtils.isNotEmpty((String)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean allNotEmpty(String[] o) {
        for (String element : o) {
            if (!org.apache.commons.lang.StringUtils.isBlank((String)element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object o) {
        return o == null || o instanceof String && org.apache.commons.lang.StringUtils.isEmpty((String)((String)o));
    }

    public static String toString(Object[] array) {
        return StringUtils.toString(array, true);
    }

    public static String toString(Object[] array, String delimeter) {
        return StringUtils.toString(array, true, delimeter);
    }

    public static String toString(Object[] array, boolean frame) {
        return StringUtils.toString(array, frame, DEFAULT_DELIMETER);
    }

    public static String toString(Object[] array, boolean frame, String delimeter) {
        StringBuffer b = new StringBuffer();
        if (frame) {
            b.append('[');
        }
        for (int i = 0; i < array.length; ++i) {
            b.append(array[i]);
            if (i >= array.length - 1) continue;
            b.append(delimeter);
        }
        if (frame) {
            b.append(']');
        }
        return b.toString();
    }

    public static String toString(Collection<?> collection, boolean frame, String delimeter) {
        return StringUtils.toString(collection.toArray(new Object[collection.size()]), frame, delimeter);
    }

    public static String toString(Collection<?> collection, boolean frame) {
        return StringUtils.toString(collection, frame, DEFAULT_DELIMETER);
    }

    public static String toString(Collection<?> collection) {
        return StringUtils.toString(collection, true);
    }

    public static String concatAsString(Object[] array) {
        return StringUtils.concatAsString(array, "_");
    }

    public static String concatAsString(Object[] array, String delim) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            b.append(array[i]);
            if (i >= array.length - 1) continue;
            b.append(delim);
        }
        return b.toString();
    }

    public static boolean equals(String s, Object o) {
        return o instanceof String && org.apache.commons.lang.StringUtils.equals((String)s, (String)((String)o));
    }

    public static boolean equals(Object o, String s) {
        return StringUtils.equals(s, o);
    }

    public static boolean equalsAny(Object o, String ... options) {
        return o instanceof String && StringUtils.equalsAny((String)o, options);
    }

    public static boolean equalsAny(String s, String ... options) {
        if (s == null || options == null) {
            return false;
        }
        for (String element : options) {
            if (!s.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String s, String[] options) {
        if (s == null) {
            return false;
        }
        for (String element : options) {
            if (!s.startsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static String getStartsWith(String s, String[] options) {
        if (s == null) {
            return null;
        }
        for (String element : options) {
            if (!s.startsWith(element)) continue;
            return element;
        }
        return null;
    }

    public static boolean endsWith(String s, String[] options) {
        if (s == null) {
            return false;
        }
        for (String element : options) {
            if (!s.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String toString(Enumeration<?> enumeration) {
        return StringUtils.toString(EnumerationUtils.toList(enumeration));
    }

    public static String[] append(String[] functionNames, String toAppend) {
        String[] s = new String[functionNames.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = functionNames[i] + toAppend;
        }
        return s;
    }

    public static String getParam(String paramName, String queryString) {
        int n = queryString.indexOf(paramName + "=");
        String param = null;
        if (n > -1) {
            param = queryString.substring(n + paramName.length() + 2);
            if (param.indexOf("&") > -1) {
                param = param.substring(0, param.indexOf("&"));
            }
            param = param.substring(0, param.length() - 2);
        }
        return param;
    }

    public static String getAbsolutePath(String requestURI, String page) {
        try {
            if (!page.startsWith("/")) {
                if (requestURI.lastIndexOf("/") != -1) {
                    requestURI = requestURI.substring(0, requestURI.lastIndexOf("/") + 1);
                }
                page = requestURI + page;
            }
            return new File("/", page).getCanonicalPath();
        }
        catch (IOException e) {
            return page;
        }
    }

    public static String reverseString(String s) {
        return new StringBuilder(s).reverse().toString();
    }
}

