/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.attributes;

import eu.medsea.util.MimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.makumba.LogicException;
import org.makumba.Text;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.attributes.HttpParameters;

public class MultipartHttpParameters
extends HttpParameters {
    Hashtable<String, Object> parameters = new Hashtable();
    static DiskFileItemFactory factory = new DiskFileItemFactory();

    void computeAtStart() {
    }

    public boolean knownAtStart(String s) {
        return this.parameters.get(s) != null;
    }

    public MultipartHttpParameters(HttpServletRequest req) {
        super(req);
        Logger.getLogger("org.makumba.fileUpload").fine("\n\n---- code with apache.commons.fileupload  ------\n");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = null;
        try {
            items = upload.parseRequest(this.request);
        }
        catch (FileUploadException e1) {
            throw new RuntimeWrappedException(e1);
        }
        for (DiskFileItem item : items) {
            Text contentToSave;
            String name;
            if (item.isFormField()) {
                name = item.getFieldName();
                String value = item.getString();
                this.addParameter(name, value);
                continue;
            }
            name = item.getFieldName();
            String fileName = item.getName();
            if (fileName != null) {
                fileName = FilenameUtils.getName((String)fileName);
            }
            String mimeType = MimeUtil.getMimeType((File)item.getStoreLocation());
            String browserContentType = item.getContentType();
            if (mimeType == "application/x-unknown-mime-type" && StringUtils.isBlank((String)(mimeType = browserContentType))) {
                mimeType = MimeUtil.getMimeType((String)item.getName());
            }
            if (MimeUtil.getMajorComponent((String)mimeType).equals("image")) {
                try {
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(mimeType);
                    if (iterator == null) {
                        throw new RuntimeWrappedException(new LogicException("Could not read image information, unknown content-type '" + mimeType + "' provided."));
                    }
                    Logger.getLogger("org.makumba.fileUpload").severe("Could not read image information, unknown content-type '" + mimeType + "' provided.\nAttribute name: '" + name + "'\n" + "Page: " + this.request.getRequestURI());
                    ImageReader reader = iterator.next();
                    ImageInputStream iis = ImageIO.createImageInputStream(item.getInputStream());
                    reader.setInput(iis, false);
                    this.parameters.put(name + "_imageWidth", reader.getWidth(0));
                    this.parameters.put(name + "_imageHeight", reader.getHeight(0));
                    reader.dispose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                contentToSave = new Text(item.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeWrappedException(e);
            }
            int contentSize = contentToSave.length();
            this.parameters.put(name + "_contentType", mimeType);
            this.parameters.put(name + "_filename", fileName);
            this.parameters.put(name + "_contentLength", contentSize);
            this.parameters.put(name, contentToSave);
            Logger.getLogger("org.makumba.fileUpload").fine("Parameters set: contentType=" + mimeType + ", fileName=" + fileName + ", contentSize=" + contentSize);
        }
    }

    void addParameter(String name, String value) {
        Object o = this.parameters.get(name);
        if (o != null) {
            if (o instanceof Vector) {
                ((Vector)o).addElement(value);
            } else {
                Vector<Object> v = new Vector<Object>();
                v.addElement(o);
                v.addElement(value);
                this.parameters.put(name, v);
            }
        } else {
            this.parameters.put(name, value);
        }
    }

    public Object getParameter(String s) {
        return MultipartHttpParameters.compose(this.parameters.get(s), super.getParameter(s));
    }

    static Object compose(Object a1, Object a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        if (a1 instanceof Vector) {
            if (a2 instanceof Vector) {
                Enumeration e = ((Vector)a2).elements();
                while (e.hasMoreElements()) {
                    ((Vector)a1).addElement(e.nextElement());
                }
                return a1;
            }
            ((Vector)a1).addElement(a2);
            return a1;
        }
        if (a2 instanceof Vector) {
            ((Vector)a2).addElement(a1);
            return a2;
        }
        Vector<Object> v = new Vector<Object>();
        v.addElement(a1);
        v.addElement(a2);
        return v;
    }
}

