/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.attributes;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.makumba.AttributeNotFoundException;
import org.makumba.Attributes;
import org.makumba.LogicException;
import org.makumba.commons.attributes.RequestAttributes;

public class PageAttributes
implements Attributes {
    PageContext pageContext;

    public static PageAttributes getAttributes(PageContext pc) {
        if (pc.getAttribute("makumba.attributes") == null) {
            pc.setAttribute("makumba.attributes", (Object)new PageAttributes(pc));
        }
        return (PageAttributes)pc.getAttribute("makumba.attributes");
    }

    PageAttributes(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public static void setAttribute(PageContext pc, String var, Object o) {
        if (o != null) {
            pc.setAttribute(var, o);
            pc.removeAttribute(var + "_null");
        } else {
            pc.removeAttribute(var);
            pc.setAttribute(var + "_null", (Object)"null");
        }
    }

    public Object setAttribute(String s, Object o) throws LogicException {
        return RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).setAttribute(s, o);
    }

    public void removeAttribute(String s) throws LogicException {
        RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).removeAttribute(s);
    }

    public boolean hasAttribute(String s) {
        try {
            return RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).hasAttribute(s) || this.checkPageForAttribute(s) != RequestAttributes.notFound;
        }
        catch (LogicException e) {
            return false;
        }
    }

    public String toString() {
        String[] scopeNames = new String[]{"Session", "Application", "Request", "Page"};
        int[] scopes = new int[]{3, 4, 2, 1};
        String s = "";
        for (int i = 0; i < scopes.length; ++i) {
            s = s + scopeNames[i] + ": {";
            Enumeration enumeration = this.pageContext.getAttributeNamesInScope(scopes[i]);
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                s = s + name + "=";
                Object value = this.pageContext.getAttribute(name, scopes[i]);
                s = value instanceof PageAttributes ? s + value.getClass() : s + value;
                if (!enumeration.hasMoreElements()) continue;
                s = s + ", ";
            }
            s = s + "}\n";
        }
        return s;
    }

    public Object getAttribute(String s) throws LogicException {
        RequestAttributes reqAttrs = RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest());
        Object o = reqAttrs.checkSessionForAttribute(s);
        if (o != RequestAttributes.notFound) {
            return o;
        }
        o = reqAttrs.checkServletLoginForAttribute(s);
        if (o != RequestAttributes.notFound) {
            return o;
        }
        o = this.checkPageForAttribute(s);
        if (o != RequestAttributes.notFound) {
            return o;
        }
        o = reqAttrs.checkLogicForAttribute(s);
        if (o != RequestAttributes.notFound) {
            return o;
        }
        o = reqAttrs.checkParameterForAttribute(s);
        if (o != RequestAttributes.notFound) {
            return o;
        }
        throw new AttributeNotFoundException(s, false);
    }

    public Object checkPageForAttribute(String s) {
        String snull = s + "_null";
        Object value = this.pageContext.getAttribute(s);
        if (value != null) {
            return value;
        }
        if (this.pageContext.getAttribute(snull) != null) {
            return null;
        }
        return RequestAttributes.notFound;
    }
}

