/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.documentation;

import com.ecyrd.jspwiki.ReferenceManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.AbstractReferralPlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class InsertCategoryMenu
extends AbstractReferralPlugin
implements WikiPlugin {
    private static final String PARAM_PAGE = "page";
    private static final String PARAM_CURRENTCATEGORY = "showCurrentCategory";
    private static final String PARAM_MENUPAGE = "showCurrentCategoryMenu";
    private static final String[] DEFAULT_CATEGORIES = new String[]{"CategoryMain", "CategoryQuickStart", "CategoryConfiguration", "CategoryUsage", "CategoryDocumentation", "CategoryShowcase", "CategoryDownload"};
    private static String[] categories = null;

    public String execute(WikiContext context, Map params) throws PluginException {
        File f;
        WikiPage page;
        if (categories == null) {
            String categoriesConf = (String)context.getEngine().getWikiProperties().get("navigation.categories");
            categories = categoriesConf == null ? DEFAULT_CATEGORIES : categoriesConf.split(",");
        }
        boolean showCurrentCategory = params.get(PARAM_CURRENTCATEGORY) != null && ((String)params.get(PARAM_CURRENTCATEGORY)).equals("true");
        boolean showCurrentCategoryMenu = params.get(PARAM_MENUPAGE) != null && ((String)params.get(PARAM_MENUPAGE)).equals("true");
        ReferenceManager refmgr = context.getEngine().getReferenceManager();
        String pageName = (String)params.get(PARAM_PAGE);
        if (pageName == null) {
            pageName = context.getPage().getName();
        }
        if ((page = context.getEngine().getPage(pageName)) == null) {
            return "Page " + pageName + " does not exist yet so no menu for it can be computed.";
        }
        String toBeInserted = null;
        if (Arrays.asList(categories).contains(pageName)) {
            toBeInserted = page.getName();
        } else {
            for (String cat : categories) {
                Collection links = refmgr.findReferrers(cat);
                if (links == null || !links.contains(pageName)) continue;
                toBeInserted = cat;
                break;
            }
        }
        if (toBeInserted == null && !showCurrentCategory) {
            return "Warning: you should add the page " + page.getName() + " to one of the following categories " + Arrays.toString(categories) + " so that it gets a side menu";
        }
        if (showCurrentCategory) {
            boolean categoryFound = toBeInserted != null;
            return categoryFound ? toBeInserted : "";
        }
        if (showCurrentCategoryMenu) {
            boolean menuExists = context.getEngine().pageExists(toBeInserted + "Menu");
            return menuExists ? toBeInserted + "Menu" : "";
        }
        String wikiMarkup = "[{MenuTreePlugin menuPage='" + toBeInserted + "Menu" + "'}]";
        String html = context.getEngine().textToHTML(context, wikiMarkup);
        if (toBeInserted.equals("CategoryDocumentation") && (!(f = new File(new File(".").getAbsolutePath() + "/doc-jspwiki/JSPWiki/api/leftMenu.html")).exists() || f.exists() && new Date(f.lastModified()).before(context.getEngine().getPage(toBeInserted + "Menu").getLastModified()))) {
            try {
                f.getParentFile().mkdirs();
                f.createNewFile();
                FileWriter fw = new FileWriter(f);
                fw.write(html);
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return html;
    }
}

