/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class EmptyLineFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        EmptyLineFilterWrapper emptyLineFilterWrapper = new EmptyLineFilterWrapper(response);
        chain.doFilter(request, (ServletResponse)emptyLineFilterWrapper);
        emptyLineFilterWrapper.getOutputStream().close();
    }

    public void destroy() {
    }

    public void deleteEmptyLines(Reader reader, Writer writer) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        boolean inPreTag = false;
        while ((line = in.readLine()) != null) {
            String lineRest = line;
            int indexPreTagOpen = -1;
            if (inPreTag && line.indexOf("</pre") != -1) {
                inPreTag = false;
                lineRest = lineRest.substring(lineRest.indexOf(">", line.indexOf("</pre")));
            }
            while ((indexPreTagOpen = lineRest.indexOf("<pre")) != -1) {
                inPreTag = true;
                int indexPreTagClosing = lineRest.indexOf(">", indexPreTagOpen);
                int indexEndTagPre = (lineRest = lineRest.substring(indexPreTagClosing + 1)).indexOf("</pre");
                if (indexEndTagPre == -1) continue;
                inPreTag = false;
                lineRest = lineRest.substring(lineRest.indexOf(">", indexEndTagPre));
            }
            if (!inPreTag && line.trim().equals("")) continue;
            writer.write(line + "\n");
        }
    }

    public String deleteEmptyLines(Reader reader) throws IOException {
        StringBuffer result = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        boolean inPreTag = false;
        while ((line = in.readLine()) != null) {
            String lineRest = line;
            int indexPreTagOpen = -1;
            if (inPreTag && line.indexOf("</pre") != -1) {
                inPreTag = false;
                lineRest = lineRest.substring(lineRest.indexOf(">", line.indexOf("</pre")));
            }
            while ((indexPreTagOpen = lineRest.indexOf("<pre")) != -1) {
                inPreTag = true;
                int indexPreTagClosing = lineRest.indexOf(">", indexPreTagOpen);
                int indexEndTagPre = (lineRest = lineRest.substring(indexPreTagClosing + 1)).indexOf("</pre");
                if (indexEndTagPre == -1) continue;
                inPreTag = false;
                lineRest = lineRest.substring(lineRest.indexOf(">", indexEndTagPre));
            }
            if (!inPreTag && line.trim().equals("")) continue;
            result.append(line).append("\n");
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        String text = "<html>\n\n\n<pre>\n\n</pre>\n<pre> some stuff </pre> bla <pre>\nstuff\nnext line stuff\n</pre>\n\n\n\n\n hhh";
        StringReader r = new StringReader(text);
        StringWriter w = new StringWriter();
        new EmptyLineFilter().deleteEmptyLines(r, w);
        System.out.println("*** Original ***");
        System.out.print(text);
        System.out.println("-----------------");
        System.out.println("*** Filtered ***");
        System.out.print(w.toString());
        System.out.println("-----------------");
    }

    class EmptyLineFilterPrintWriter
    extends PrintWriter {
        private OutputStream outStream;

        public EmptyLineFilterPrintWriter(OutputStream out) {
            super(out);
            this.outStream = out;
        }

        public void write(char[] buf, int off, int len) {
            try {
                this.outStream.write(new String(buf).getBytes(), off, len);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class EmptyLineFilterWrapper
    extends HttpServletResponseWrapper {
        private PrintWriter tpWriter;
        private EmptyLineFilterStream tpStream;

        public EmptyLineFilterWrapper(ServletResponse inResp) throws IOException {
            super((HttpServletResponse)inResp);
            this.tpStream = new EmptyLineFilterStream((OutputStream)inResp.getOutputStream());
            this.tpWriter = new EmptyLineFilterPrintWriter((OutputStream)((Object)this.tpStream));
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.tpStream;
        }

        public PrintWriter getWriter() throws IOException {
            return this.tpWriter;
        }
    }

    class EmptyLineFilterStream
    extends ServletOutputStream {
        private OutputStream intStream;
        private ByteArrayOutputStream baStream;
        private boolean closed = false;

        public EmptyLineFilterStream(OutputStream outStream) {
            this.intStream = outStream;
            this.baStream = new ByteArrayOutputStream();
        }

        public void write(int i) throws IOException {
            this.baStream.write(i);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baStream.write(b, off, len);
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.processStream();
                this.intStream.close();
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.baStream.size() != 0 && !this.closed) {
                this.processStream();
                this.baStream = new ByteArrayOutputStream();
            }
        }

        public void processStream() throws IOException {
            this.intStream.write(this.replaceContent(this.baStream.toByteArray()));
            this.intStream.flush();
        }

        public byte[] replaceContent(byte[] inBytes) {
            System.out.println("replace content: ");
            StringReader reader = new StringReader(new String(inBytes));
            try {
                return EmptyLineFilter.this.deleteEmptyLines(reader).getBytes();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

