/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.collections.set.ListOrderedSet;
import org.makumba.analyser.AnalysableElement;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.providers.Configuration;

public class MakumbaResponseWrapper
extends HttpServletResponseWrapper {
    private PrintWriter originalWriter;
    private PrintWriter makumbaWriter;
    private boolean headOpenPassed = false;
    private boolean headClosedPassed = false;
    private String makumbaStyleSheet;
    private HttpServletRequest request;
    private String cssResources = "";
    private String javaScriptResources = "";

    public MakumbaResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
        super(response);
        this.request = request;
        this.makumbaStyleSheet = "<link rel=\"StyleSheet\" type=\"text/css\" media=\"all\" href=\"" + request.getContextPath() + Configuration.getMakumbaResourcesLocation() + "/" + "css/" + "makumba.css\"/>";
    }

    public PrintWriter getWriter() throws IOException {
        if (this.request.getRequestURI().endsWith(".jsp") && this.request.getAttribute("javax.servlet.jsp.jspException") == null) {
            if (this.makumbaWriter == null) {
                this.originalWriter = super.getWriter();
                this.makumbaWriter = new MakumbaPrintWriter(this.originalWriter);
                this.initResourceReplacements();
            }
            return this.makumbaWriter;
        }
        return super.getWriter();
    }

    public void initResourceReplacements() {
        ListOrderedSet resources;
        PageCache pageCache = AnalysableElement.getPageCache(this.request, this.request.getSession().getServletContext().getRealPath("/"), MakumbaJspAnalyzer.getInstance());
        if (pageCache != null && (resources = pageCache.retrieveSetValues("org.makumba.neededResources")) != null) {
            for (Object object : resources) {
                String resource = (String)object;
                if (resource.endsWith(".js")) {
                    this.javaScriptResources = this.javaScriptResources + "  <script type=\"text/javascript\" src=\"" + this.request.getContextPath() + Configuration.getMakumbaResourcesLocation() + "/javaScript/" + resource + "\"></script>\n";
                    continue;
                }
                if (!resource.endsWith(".css")) continue;
                this.cssResources = this.cssResources + "\n  <link rel=\"StyleSheet\" type=\"text/css\" media=\"all\" href=\"" + this.request.getContextPath() + Configuration.getMakumbaResourcesLocation() + "/css/makumbaDevelStyles.css\"/>";
            }
        }
    }

    class MakumbaPrintWriter
    extends PrintWriter {
        public MakumbaPrintWriter(Writer originalWriter) {
            super(originalWriter);
        }

        public void print(String s) {
            this.write(s);
        }

        public void println(String s) {
            this.write(s);
            this.println();
        }

        public PrintWriter printf(String format, Object ... args) {
            return this.format(format, args);
        }

        public void print(Object obj) {
            this.write(String.valueOf(obj));
        }

        public void println(Object obj) {
            this.write(String.valueOf(obj));
            this.println();
        }

        public void print(char c) {
            this.write(c);
        }

        public void println(char c) {
            this.write(c);
            this.println();
        }

        public void print(char[] c) {
            this.write(c);
        }

        public void println(char[] c) {
            this.write(c);
            this.println();
        }

        public void write(char[] buf) {
            this.write(buf, 0, buf.length);
        }

        public void write(char[] buf, int off, int len) {
            if (!MakumbaResponseWrapper.this.headClosedPassed) {
                int indexOfHeadOpen;
                String s = null;
                if (!MakumbaResponseWrapper.this.headOpenPassed && (indexOfHeadOpen = (s = new String(buf, off, len)).indexOf("<head>")) != -1 && indexOfHeadOpen > off) {
                    MakumbaResponseWrapper.this.headOpenPassed = true;
                    s = this.injectStyleSheets(s);
                    buf = s.toCharArray();
                    len = s.length();
                }
                if (MakumbaResponseWrapper.this.headOpenPassed) {
                    int indexOfHeadClosed;
                    if (s == null) {
                        s = new String(buf, off, len);
                    }
                    if ((indexOfHeadClosed = s.indexOf("</head>")) != -1 && indexOfHeadClosed > off) {
                        MakumbaResponseWrapper.this.headClosedPassed = true;
                        s = this.injectJavaScriptsResources(s);
                        buf = s.toCharArray();
                        len = s.length();
                    }
                }
            }
            super.write(buf, off, len);
        }

        public void write(String s) {
            this.write(s, 0, s.length());
        }

        public void write(String s, int off, int len) {
            if (!MakumbaResponseWrapper.this.headClosedPassed) {
                int indexOfHeadClosed;
                int indexOfHeadOpen;
                if (!MakumbaResponseWrapper.this.headOpenPassed && (indexOfHeadOpen = s.indexOf("<head>")) != -1 && indexOfHeadOpen > off) {
                    MakumbaResponseWrapper.this.headOpenPassed = true;
                    s = this.injectStyleSheets(s);
                    len = s.length();
                }
                if (MakumbaResponseWrapper.this.headOpenPassed && (indexOfHeadClosed = s.indexOf("</head>")) != -1 && indexOfHeadClosed > off) {
                    MakumbaResponseWrapper.this.headClosedPassed = true;
                    s = this.injectJavaScriptsResources(s);
                    len = s.length();
                }
            }
            super.write(s, off, len);
        }

        private String injectJavaScriptsResources(String s) {
            return s.replace("</head>", MakumbaResponseWrapper.this.javaScriptResources + "</head>");
        }

        private String injectStyleSheets(String s) {
            return s.replace("<head>", "<head>\n  " + MakumbaResponseWrapper.this.makumbaStyleSheet + MakumbaResponseWrapper.this.cssResources);
        }
    }
}

