/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.NoSuchFieldException;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHolder {
    private Transaction t;
    private TransactionProvider tp;
    Dictionary<String, Object> dictionnary = new Hashtable<String, Object>();
    Dictionary<String, Object> others = new Hashtable<String, Object>();
    Dictionary<String, Object> sets = new Hashtable<String, Object>();
    private Dictionary<String, Object> fullData;
    private DataDefinitionProvider ddp;
    private String type;
    private DataDefinition typeDef;

    public DataHolder(Transaction t, Dictionary<String, Object> data, String type) {
        String o;
        this.t = t;
        this.fullData = data;
        this.type = type;
        this.ddp = DataDefinitionProvider.getInstance();
        this.tp = t.getTransactionProvider();
        this.typeDef = this.ddp.getDataDefinition(type);
        Enumeration<String> e = data.keys();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            this.dictionnary.put(o, data.get(o));
        }
        e = data.keys();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof String)) {
                throw new NoSuchFieldException(this.typeDef, "Dictionaries passed to makumba DB operations should have String keys. Key <" + o + "> is of type " + o.getClass() + this.typeDef.getName());
            }
            String s = o;
            int dot = s.indexOf(".");
            if (dot == -1) {
                FieldDefinition fi = this.typeDef.getFieldDefinition(s);
                if (fi == null) {
                    throw new NoSuchFieldException(this.typeDef, o);
                }
                if (!fi.getType().equals("set") && !fi.getType().equals("setintEnum") && !fi.getType().equals("setcharEnum")) continue;
                Object v = this.dictionnary.remove(s);
                fi.checkValue(v);
                this.sets.put(s, v);
                continue;
            }
            String fld = s.substring(0, dot);
            Hashtable<String, Object> oth = (Hashtable<String, Object>)this.others.get(fld);
            if (oth == null) {
                oth = new Hashtable<String, Object>();
                this.others.put(fld, oth);
            }
            ((Dictionary)oth).put(s.substring(dot + 1), this.dictionnary.remove(s));
        }
        Dictionary<String, Object> others1 = this.others;
        this.others = new Hashtable<String, Object>();
        Enumeration<String> e2 = others1.keys();
        while (e2.hasMoreElements()) {
            String fld = e2.nextElement();
            FieldDefinition fd = this.typeDef.getFieldDefinition(fld);
            if (fd == null) {
                throw new NoSuchFieldException(this.typeDef, fld);
            }
            if (this.dictionnary.get(fld) != null) {
                throw new InvalidValueException(fd, "you cannot indicate both a subfield and the field itself. Values for " + fld + "." + this.others.get(fld) + " were also indicated");
            }
            if (!(fd.getType().equals("ptrOne") || fd.isNotNull() && fd.isFixed())) {
                throw new InvalidFieldTypeException(fd, "subpointer or base pointer, so it cannot be used for composite insert/edit");
            }
            this.others.put(fld, new DataHolder(t, (Dictionary)others1.get(fld), fd.getPointedType().getName()));
        }
    }

    public String toString() {
        return "data: " + this.dictionnary + " others: " + this.others;
    }

    public void checkInsert() {
        Enumeration<Object> e = this.others.elements();
        while (e.hasMoreElements()) {
            ((DataHolder)e.nextElement()).checkInsert();
        }
        this.tp.getCRUD().checkInsert(this.t, this.type, this.dictionnary, this.others, this.fullData);
    }

    void checkUpdate(Pointer pointer) {
        Enumeration<Object> e = this.others.elements();
        while (e.hasMoreElements()) {
            ((DataHolder)e.nextElement()).checkUpdate(pointer);
        }
        this.tp.getCRUD().checkUpdate(this.t, this.type, pointer, this.dictionnary, this.others, this.fullData);
    }

    public Pointer insert() {
        Enumeration<String> e = this.others.keys();
        while (e.hasMoreElements()) {
            String fld = e.nextElement();
            this.dictionnary.put(fld, ((DataHolder)this.others.get(fld)).insert());
        }
        Pointer p = this.tp.getCRUD().insert(this.t, this.type, this.dictionnary);
        Enumeration<String> e2 = this.sets.keys();
        while (e2.hasMoreElements()) {
            String fld = e2.nextElement();
            FieldDefinition fi = this.ddp.getDataDefinition(p.getType()).getFieldDefinition(fld);
            this.tp.getCRUD().updateSet(this.t, p, fi, this.sets.get(fld));
        }
        return p;
    }

    int update(Pointer p) {
        String fld;
        Vector<String> ptrsx = new Vector<String>();
        Enumeration<String> e = this.others.keys();
        while (e.hasMoreElements()) {
            ptrsx.addElement(e.nextElement());
        }
        e = this.dictionnary.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (!this.dictionnary.get(s).equals(Pointer.Null) || !this.typeDef.getFieldDefinition(s).getType().equals("ptrOne")) continue;
            ptrsx.addElement(s);
        }
        Dictionary<String, Object> ptrs = null;
        if (ptrsx.size() > 0) {
            ptrs = this.t.read(p, ptrsx);
        }
        Enumeration<Object> e2 = this.others.keys();
        while (e2.hasMoreElements()) {
            fld = e2.nextElement();
            Pointer ptr = (Pointer)ptrs.remove(fld);
            if (ptr == null || ptr == Pointer.Null) {
                this.dictionnary.put(fld, ((DataHolder)this.others.get(fld)).insert());
                continue;
            }
            ((DataHolder)this.others.get(fld)).update(ptr);
        }
        if (ptrs != null) {
            e2 = ptrs.elements();
            while (e2.hasMoreElements()) {
                this.tp.getCRUD().delete(this.t, (Pointer)e2.nextElement());
            }
        }
        this.tp.getCRUD().update1(this.t, p, this.typeDef, this.dictionnary);
        e2 = this.sets.keys();
        while (e2.hasMoreElements()) {
            fld = (String)e2.nextElement();
            FieldDefinition fi = this.ddp.getDataDefinition(p.getType()).getFieldDefinition(fld);
            this.tp.getCRUD().updateSet(this.t, p, fi, this.sets.get(fld));
        }
        return 1;
    }
}

