/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.OQLParseError;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.db.TransactionImplementation;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.Query;
import org.makumba.db.makumba.Table;
import org.makumba.db.makumba.Update;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBConnection
extends TransactionImplementation {
    protected String dataSource;
    protected Database db;
    Map<String, Pointer> locks = new HashMap<String, Pointer>(13);
    Hashtable<String, Object> lockRecord = new Hashtable(5);
    static final String whereDelim = " ##### ";

    protected DBConnection(TransactionProvider tp) {
        super(tp);
    }

    public DBConnection(Database database, TransactionProvider tp) {
        this(tp);
        this.db = database;
        this.ddp = DataDefinitionProvider.getInstance();
    }

    public DBConnection(Database database, String dataSource, TransactionProvider tp) {
        this(database, tp);
        this.dataSource = dataSource;
    }

    public Database getHostDatabase() {
        return this.db;
    }

    @Override
    public String getName() {
        return this.db.getName();
    }

    @Override
    public void lock(String symbol) {
        this.lockRecord.clear();
        this.lockRecord.put("name", symbol);
        this.locks.put(symbol, this.insert("org.makumba.db.makumba.Lock", this.lockRecord));
    }

    @Override
    public void unlock(String symbol) {
        Pointer p = this.locks.get(symbol);
        if (p == null) {
            throw new ProgrammerError(symbol + " not locked in connection " + this);
        }
        this.deleteLock(symbol);
    }

    protected void deleteLock(String symbol) {
        this.locks.remove(symbol);
        this.delete("org.makumba.db.makumba.Lock l", "l.name=$1", symbol);
    }

    protected void unlockAll() {
        Iterator<String> i = this.locks.keySet().iterator();
        while (i.hasNext()) {
            this.deleteLock(i.next());
        }
    }

    @Override
    protected StringBuffer writeReadQuery(Pointer p, Enumeration<String> e) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        String separator = "";
        while (e.hasMoreElements()) {
            String o = e.nextElement();
            DataDefinition r = this.ddp.getDataDefinition(p.getType());
            if (!(o instanceof String)) {
                throw new NoSuchFieldException(r, "Dictionaries passed to makumba DB operations should have String keys. Key <" + o + "> is of type " + o.getClass() + r.getName());
            }
            if (r.getFieldDefinition(o) == null) {
                throw new NoSuchFieldException(r, o);
            }
            String s = o;
            sb.append(separator).append("p.").append(s).append(" as ").append(s);
            separator = ",";
        }
        sb.append(" FROM " + p.getType() + " p WHERE p=$1");
        return sb;
    }

    @Override
    protected Vector<Dictionary<String, Object>> executeReadQuery(Pointer p, StringBuffer sb) {
        Object[] params = new Object[]{p};
        Vector<Dictionary<String, Object>> v = this.executeQuery(sb.toString(), params);
        return v;
    }

    @Override
    public Pointer insert(String type, Dictionary<String, Object> data) {
        Table t = this.db.getTable(type);
        t.computeInsertHook();
        if (t.insertHook != null) {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            Enumeration<String> e = data.keys();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                h.put(k, data.get(k));
            }
            data = h;
        }
        if (t.insertHook == null || t.insertHook.transform(data, this)) {
            return super.insert(type, data);
        }
        return null;
    }

    @Override
    public Vector<Pointer> insert(String type, Collection<Dictionary<String, Object>> data) {
        throw new MakumbaError("Not implemented");
    }

    @Override
    public Vector<Dictionary<String, Object>> executeQuery(String OQL, Object args, int offset, int limit) {
        Object[] k = new Object[]{OQL, ""};
        return ((Query)this.getHostDatabase().queries.getResource(k)).execute(this.paramsToMap(args), this, offset, limit);
    }

    @Override
    protected int insertFromQueryImpl(String type, String OQL, Object args) {
        Object[] k = new Object[]{OQL, type};
        return ((Query)this.getHostDatabase().queries.getResource(k)).insert(this.paramsToMap(args), this);
    }

    @Override
    public Vector<Dictionary<String, Object>> executeQuery(String OQL, Object args) {
        return this.executeQuery(OQL, args, 0, -1);
    }

    @Override
    public int executeUpdate(String type, String set, String where, Object args) {
        if (set != null && set.trim().length() == 0) {
            throw new OQLParseError("Invalid empty update 'set' section in: UPDATE " + type + " SET (empty!) WHERE " + where);
        }
        if (where != null && where.trim().length() == 0) {
            where = null;
        }
        Object[] multi = new Object[]{type, (set == null ? "" : set) + whereDelim + (where == null ? "" : where), whereDelim};
        return ((Update)this.getHostDatabase().updates.getResource(multi)).execute(this, this.paramsToMap(args));
    }

    public Query getQuery(String OQL) {
        Object[] k = new Object[]{OQL, ""};
        return (Query)this.getHostDatabase().queries.getResource(k);
    }

    @Override
    public String getNullConstant() {
        return "nil";
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    protected Object[] treatParam(Object args) {
        if (args == null) {
            return new Object[0];
        }
        if (args instanceof Vector) {
            Vector v = (Vector)args;
            Object[] param = new Object[v.size()];
            v.copyInto(param);
            return param;
        }
        if (args instanceof Object[]) {
            return (Object[])args;
        }
        Object[] p = new Object[]{args};
        return p;
    }
}

