/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.Attributes;
import org.makumba.Pointer;
import org.makumba.db.makumba.ClosedDBConnection;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Database;
import org.makumba.providers.TransactionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConnectionWrapper
extends DBConnection {
    DBConnection wrapped;
    Throwable t;
    Date created;

    public DBConnection getWrapped() {
        return this.wrapped;
    }

    DBConnectionWrapper(TransactionProvider tp) {
        super(tp);
    }

    DBConnectionWrapper(DBConnection wrapped, String dataSource, TransactionProvider tp) {
        this(tp);
        this.t = new Throwable();
        this.created = new Date();
        this.wrapped = wrapped;
        this.dataSource = dataSource;
    }

    @Override
    public String getName() {
        return this.getWrapped().getName();
    }

    @Override
    public Database getHostDatabase() {
        return this.getWrapped().getHostDatabase();
    }

    @Override
    public Dictionary<String, Object> read(Pointer ptr, Object fields) {
        return this.getWrapped().read(ptr, fields);
    }

    @Override
    public Vector<Dictionary<String, Object>> executeQuery(String OQL, Object parameterValues, int offset, int limit) {
        return this.getWrapped().executeQuery(OQL, parameterValues, offset, limit);
    }

    @Override
    public Pointer insert(String type, Dictionary<String, Object> data) {
        return this.getWrapped().insert(type, data);
    }

    @Override
    public Pointer insert(Pointer host, String subsetField, Dictionary<String, Object> data) {
        return this.getWrapped().insert(host, subsetField, data);
    }

    @Override
    public int insertFromQuery(String type, String OQL, Object parameterValues) {
        return this.getWrapped().insertFromQuery(type, OQL, parameterValues);
    }

    @Override
    public int update(Pointer ptr, Dictionary<String, Object> fieldsToChange) {
        return this.getWrapped().update(ptr, fieldsToChange);
    }

    @Override
    public int update(String from, String set, String where, Object parameters) {
        return this.getWrapped().update(from, set, where, parameters);
    }

    @Override
    public void delete(Pointer ptr) {
        this.getWrapped().delete(ptr);
    }

    @Override
    public int delete(String from, String where, Object parameters) {
        return this.getWrapped().delete(from, where, parameters);
    }

    @Override
    public void commit() {
        this.getWrapped().unlockAll();
        this.getWrapped().commit();
    }

    @Override
    public void rollback() {
        this.getWrapped().unlockAll();
        this.getWrapped().rollback();
    }

    @Override
    public void lock(String symbol) {
        this.getWrapped().lock(symbol);
    }

    @Override
    public void unlock(String symbol) {
        this.getWrapped().lock(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            this.getWrapped().setContext(null);
            this.commit();
            this.getWrapped().close();
        }
        finally {
            this.wrapped = ClosedDBConnection.getInstance();
        }
    }

    protected synchronized void finalize() {
        if (this.wrapped != ClosedDBConnection.getInstance()) {
            Logger.getLogger("org.makumba.db").severe("Makumba connection " + this.getName() + " not closed\n" + this.getCreationStack());
            this.close();
        }
    }

    @Override
    public void setContext(Attributes a) {
        this.getWrapped().setContext(a);
    }

    public String getCreationStack() {
        StringWriter sbw = new StringWriter();
        PrintWriter output = new PrintWriter(sbw);
        output.print("connection created on" + this.created + " with stacktrace: ");
        this.t.printStackTrace(output);
        return sbw.toString();
    }

    public String toString() {
        return this.getWrapped() + " " + this.getCreationStack();
    }
}

