/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.db.makumba.StalePreventionTask;

public abstract class ResourcePool {
    Stack<Object> stack = new Stack();
    Stack<Date> timeStack = new Stack();
    Vector<Object> all = new Vector();
    WeakReference<ResourcePool> poolRef = new WeakReference<ResourcePool>(this);
    long sleeping;
    long stale;
    Timer stalePreventionTimer;

    public abstract Object create() throws Exception;

    Object createAndCount() throws Exception {
        Object o = this.create();
        this.all.addElement(o);
        Logger.getLogger("org.makumba.util.pool").fine("pool size: " + this.all.size());
        return o;
    }

    public void init(int n) throws Exception {
        while (n > 0) {
            this.put(this.createAndCount());
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws Exception {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            if (this.stack.isEmpty()) {
                return this.createAndCount();
            }
            this.timeStack.pop();
            Logger.getLogger("org.makumba.util.pool.member").fine("pool members: " + this.timeStack.size());
            Object r = this.stack.pop();
            if (!this.check(r)) {
                return this.get();
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            this.stack.push(o);
            this.timeStack.push(new Date());
            Logger.getLogger("org.makumba.util.pool.member").fine("pool members: " + this.timeStack.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.poolRef.clear();
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            if (this.stalePreventionTimer != null) {
                this.stalePreventionTimer.cancel();
            }
            this.stack.clear();
            this.timeStack.clear();
            for (int i = 0; i < this.all.size(); ++i) {
                this.close(this.all.elementAt(i));
            }
            this.all.clear();
        }
    }

    protected void finalize() {
        this.close();
    }

    public abstract boolean renew(Object var1);

    public abstract void close(Object var1);

    public abstract boolean check(Object var1);

    public void startStalePreventionTimer(long sleepingTime, long staleTime) {
        this.sleeping = sleepingTime;
        this.stale = staleTime;
        this.stalePreventionTimer = new Timer(true);
        this.stalePreventionTimer.scheduleAtFixedRate((TimerTask)new StalePreventionTask(this.poolRef), new Date(), sleepingTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renewAll() {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            for (int i = 0; i < this.timeStack.size(); ++i) {
                if (((Date)this.timeStack.elementAt(i)).getTime() + this.stale >= new Date().getTime() + this.sleeping) continue;
                Logger.getLogger("org.makumba.util.pool").fine("renewing resource " + this.stack.elementAt(i) + " not used since " + this.timeStack.elementAt(i));
                if (this.renew(this.stack.elementAt(i))) {
                    this.timeStack.setElementAt(new Date(), i);
                    continue;
                }
                Logger.getLogger("org.makumba.util.pool").fine("removing resource " + this.stack.elementAt(i) + " as it could not be renewed. was last used at " + this.timeStack.get(i));
                this.stack.remove(i);
                this.timeStack.remove(i);
            }
        }
    }

    public int getSize() {
        return this.stack.size();
    }
}

