/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Transaction;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

public class UniquenessServlet
extends HttpServlet {
    public static final String resourceDirectory = "makumbaResources";
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH_JAVASCRIPT = "javaScript/";
    public static final SimpleDateFormat dfLastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        PrintWriter writer = resp.getWriter();
        String value = req.getParameter("value");
        String tableName = req.getParameter("table");
        String fieldName = req.getParameter("field");
        if (StringUtils.isBlank((String)value) || StringUtils.isBlank((String)tableName) || StringUtils.isBlank((String)fieldName)) {
            writer.println("{error: \"All 'value', 'table' and 'field' parameters need to be not-empty!\"}");
            return;
        }
        Transaction transaction = null;
        try {
            void var11_16;
            block22: {
                DataDefinition dd;
                transaction = TransactionProvider.getInstance().getConnectionTo(TransactionProvider.getInstance().getDefaultDataSourceName());
                try {
                    dd = DataDefinitionProvider.getInstance().getDataDefinition(tableName);
                    if (dd == null) {
                        writer.println("{error: \"No such table!\"}");
                        return;
                    }
                }
                catch (Throwable e) {
                    writer.println("{error: \"No such table!\"}");
                    return;
                }
                FieldDefinition fd = dd.getFieldDefinition(fieldName);
                if (fd == null) {
                    writer.println("{error: \"No such field!\"}");
                    return;
                }
                String OQL = "select 1 from " + tableName + " p where p." + fieldName + "=$1";
                Vector vector = new Vector();
                if (fd.isIntegerType()) {
                    try {
                        Integer valueOf = Integer.valueOf(value);
                        Vector<Dictionary<String, Object>> vector2 = transaction.executeQuery(OQL, valueOf);
                    }
                    catch (NumberFormatException e) {}
                } else {
                    if (fd.isDateType()) {
                        if (req.getParameter("year") != null && req.getParameter("month") != null && req.getParameter("day") != null && req.getParameter("year").matches("/[0-9]+/") && req.getParameter("month").matches("/[0-9]+/") && req.getParameter("day").matches("/[0-9]+/")) {
                            Calendar c = Calendar.getInstance();
                            c.clear();
                            c.set(Integer.valueOf(req.getParameter("year")), Integer.valueOf(req.getParameter("month")), Integer.valueOf(req.getParameter("day")));
                            Date date = c.getTime();
                            Vector<Dictionary<String, Object>> vector3 = transaction.executeQuery(OQL, date);
                            break block22;
                        } else {
                            writer.println("{error: \"incorrect date\"}");
                            return;
                        }
                    }
                    Vector<Dictionary<String, Object>> vector4 = transaction.executeQuery(OQL, value);
                }
            }
            if (var11_16.size() > 0) {
                writer.print("{success: \"not unique\"}");
            } else {
                writer.print("{success: \"unique\"}");
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        writer.flush();
        writer.close();
    }
}

