/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.SQLQueryGenerator;

public class ParameterAssigner {
    TableManager paramHandler;
    Database db;
    QueryAnalysis qA;
    SQLQueryGenerator qG;
    static final Object[] empty = new Object[0];

    ParameterAssigner(Database db, QueryAnalysis qA, SQLQueryGenerator qG) {
        this.qA = qA;
        this.qG = qG;
        this.db = db;
    }

    public String assignParameters(PreparedStatement ps, Object[] args) throws SQLException {
        if (this.qG.getSQLArgumentNumber() == 0) {
            return null;
        }
        if (this.qG.getSQLArgumentNumber() > 0) {
            this.paramHandler = (TableManager)this.db.makePseudoTable(this.qG.getSQLQueryArgumentTypes());
        }
        try {
            Hashtable<String, Integer> correct = new Hashtable<String, Integer>();
            Hashtable<String, InvalidValueException> errors = new Hashtable<String, InvalidValueException>();
            for (int i = 0; i < this.qG.getSQLArgumentNumber(); ++i) {
                FieldDefinition fd = this.qG.getSQLQueryArgumentTypes().getFieldDefinition(i);
                if (fd == null) {
                    throw new IllegalStateException("No type assigned for param" + i + " of query " + this.qA.getQuery());
                }
                String spara = "$" + i;
                Object value = args[i];
                if (value == Pointer.Null) {
                    value = fd.getNull();
                }
                try {
                    value = fd.checkValue(value);
                }
                catch (InvalidValueException e) {
                    if (correct.get(spara) == null) {
                        errors.put(spara, e);
                    }
                    this.paramHandler.setNullArgument(fd.getName(), ps, i + 1);
                    continue;
                }
                correct.put(spara, i);
                errors.remove(spara);
                this.paramHandler.setUpdateArgument(fd.getName(), ps, i + 1, value);
            }
            if (errors.size() > 0) {
                String s = "";
                Enumeration e = errors.keys();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    s = s + "\nargument: " + o + "; exception:\n" + errors.get(o);
                }
                return s;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MakumbaError("wrong number of arguments to query ");
        }
        return null;
    }
}

