/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Dictionary;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.commons.ArrayMap;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.sql.ParameterAssigner;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.SQLQueryGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements org.makumba.db.makumba.Query {
    String query;
    TableManager resultHandler;
    QueryAnalysis qA;
    SQLQueryGenerator qG;
    ParameterAssigner assigner;
    String limitSyntax;
    boolean offsetFirst;
    boolean supportsLimitInQuery;
    String insertIn;
    org.makumba.db.makumba.sql.Database db;
    TableManager insertHandler;

    public String getCommand() {
        return this.qG.getSQLQuery(this.db.getNameResolverHook());
    }

    public Query(org.makumba.db.makumba.sql.Database db, String MQLQuery, String insertIn) {
        QueryAnalysisProvider qap = null;
        this.db = db;
        this.query = MQLQuery;
        try {
            qap = (QueryAnalysisProvider)Class.forName("org.makumba.providers.query.mql.MqlQueryAnalysisProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.qA = insertIn != null && insertIn.length() > 0 ? qap.getQueryAnalysis(MQLQuery, insertIn) : qap.getQueryAnalysis(MQLQuery);
        this.qG = (SQLQueryGenerator)((Object)this.qA);
        this.resultHandler = (TableManager)db.makePseudoTable(this.qA.getProjectionType());
        this.limitSyntax = db.getLimitSyntax();
        this.offsetFirst = db.isLimitOffsetFirst();
        this.supportsLimitInQuery = db.supportsLimitInQuery();
        this.insertIn = insertIn;
        if (insertIn != null && insertIn.length() > 0) {
            this.analyzeInsertIn(this.qA.getProjectionType(), db);
        }
    }

    @Override
    public Vector<Dictionary<String, Object>> execute(Map<String, Object> args, DBConnection dbc, int offset, int limit) {
        this.qG.setArguments(args);
        this.assigner = new ParameterAssigner(this.db, this.qA, this.qG);
        String com = this.getCommand();
        if (this.supportsLimitInQuery) {
            com = com + " " + this.limitSyntax;
        }
        PreparedStatement ps = ((SQLDBConnection)dbc).getPreparedStatement(com);
        try {
            String s = this.assigner.assignParameters(ps, this.qG.getSQLQueryArguments());
            if (this.supportsLimitInQuery) {
                int limit1;
                int n = limit1 = limit == -1 ? Integer.MAX_VALUE : limit;
                if (this.offsetFirst) {
                    ps.setInt(this.assigner.qG.getSQLArgumentNumber() + 1, offset);
                    ps.setInt(this.assigner.qG.getSQLArgumentNumber() + 2, limit1);
                } else {
                    ps.setInt(this.assigner.qG.getSQLArgumentNumber() + 1, limit1);
                    ps.setInt(this.assigner.qG.getSQLArgumentNumber() + 2, offset);
                }
            }
            if (s != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + com + "\n" + s);
            }
            Logger.getLogger("org.makumba.db.query.execution").fine("" + this.db.getWrappedStatementToString(ps));
            Date d = new Date();
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
            }
            catch (SQLException se) {
                org.makumba.db.makumba.sql.Database.logException(se, dbc);
                throw new DBError(se, com);
            }
            long diff = new Date().getTime() - d.getTime();
            Logger.getLogger("org.makumba.db.query.performance").fine("" + diff + " ms " + this.db.getWrappedStatementToString(ps));
            Vector<Dictionary<String, Object>> vector = this.goThru(rs, this.resultHandler);
            return vector;
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }

    private Vector<Dictionary<String, Object>> goThru(ResultSet rs, TableManager rm) {
        int size = rm.keyIndex.size();
        Vector<Dictionary<String, Object>> ret = new Vector<Dictionary<String, Object>>(100, 100);
        try {
            while (rs.next()) {
                Object[] dt = new Object[size];
                rm.fillResult(rs, dt);
                ret.addElement(new ArrayMap(rm.keyIndex, dt));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DBError(e, rm.getDataDefinition().getName());
        }
        return ret;
    }

    private void analyzeInsertIn(DataDefinition proj, Database db) {
        DataDefinition insert = DataDefinitionProvider.getInstance().getDataDefinition(this.insertIn);
        for (String string : proj.getFieldNames()) {
            if (insert.getFieldDefinition(string) != null) continue;
            throw new NoSuchFieldException(insert, string);
        }
        this.insertHandler = (TableManager)db.getTable(insert);
    }

    @Override
    public int insert(Map<String, Object> args, DBConnection dbc) {
        this.qG.setArguments(args);
        this.assigner = new ParameterAssigner(this.db, this.qA, this.qG);
        String comma = "";
        StringBuffer fieldList = new StringBuffer();
        for (String string : this.resultHandler.getDataDefinition().getFieldNames()) {
            fieldList.append(comma);
            comma = ",";
            fieldList.append(this.insertHandler.getFieldDBName(string));
        }
        String tablename = "temp_" + (int)(Math.random() * 10000.0);
        String com = "INSERT INTO " + tablename + " ( " + fieldList + ") " + this.getCommand();
        try {
            SQLDBConnection sqldbc = (SQLDBConnection)dbc;
            this.resultHandler.create(sqldbc, tablename, true);
            PreparedStatement ps = sqldbc.getPreparedStatement(com);
            String s = this.assigner.assignParameters(ps, this.qG.getSQLQueryArguments());
            if (s != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + com + "\n" + s);
            }
            int n = ps.executeUpdate();
            ps.close();
            com = "INSERT INTO " + this.insertHandler.getDBName() + " (" + fieldList + ") SELECT " + fieldList + " FROM " + tablename;
            ps = sqldbc.getPreparedStatement(com);
            int m = ps.executeUpdate();
            if (m != n) {
                throw new MakumbaError("inserted in temp " + n + " inserted in final " + m);
            }
            Statement st = sqldbc.createStatement();
            st.execute("DROP TABLE " + tablename);
            st.close();
            ps.close();
            return n;
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
    }
}

