/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.makumba.DBError;
import org.makumba.ForeignKeyError;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NotUniqueException;
import org.makumba.OQLParseError;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Update;
import org.makumba.db.makumba.sql.Database;
import org.makumba.db.makumba.sql.ParameterAssigner;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.SQLQueryGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLUpdate
implements Update {
    ParameterAssigner assigner;
    String debugString;
    String updateCommand;
    String type;
    String setWhere;
    String DELIM;
    Database db;
    QueryAnalysisProvider qP = QueryProvider.getQueryAnalzyer("oql");
    SQLQueryGenerator qG;

    SQLUpdate(Database db, String from, String setWhere, String DELIM) {
        this.type = from;
        this.db = db;
        this.setWhere = setWhere;
        this.DELIM = DELIM;
    }

    private void compileUpdateCommand(Database db, String from, String setWhere, String DELIM, Map<String, Object> args) throws OQLParseError, MakumbaError {
        int lastN;
        String fakeCommand;
        String label;
        int whereMark = setWhere.indexOf(DELIM);
        String set = setWhere.substring(0, whereMark);
        String where = setWhere.substring(whereMark + DELIM.length());
        this.debugString = (set == null ? "delete" : "update") + " on type: <" + from + ">" + (set == null ? " " : " setting: <" + set + ">") + " where: <" + where + ">";
        if (set.trim().length() == 0) {
            set = null;
        }
        if (where.trim().length() == 0) {
            where = null;
        }
        if (from != null && from.indexOf(44) >= 0) {
            throw new OQLParseError("Only 1 table can be involved in " + this.debugString);
        }
        from = from.replace('\t', ' ');
        try {
            label = from.substring(from.trim().indexOf(32) + 1).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new OQLParseError("Invalid delete/update 'type' section: " + from);
        }
        String OQLQuery = "SELECT " + (set == null ? label : set) + " FROM " + from;
        if (where != null) {
            OQLQuery = OQLQuery + " WHERE " + where;
        }
        QueryAnalysis qA = this.qP.getQueryAnalysis(OQLQuery);
        this.qG = (SQLQueryGenerator)((Object)qA);
        this.qG.setArguments(args);
        try {
            this.assigner = new ParameterAssigner(db, qA, this.qG);
        }
        catch (OQLParseError e) {
            throw new OQLParseError(e.getMessage() + "\r\nin " + this.debugString + "\n" + OQLQuery, e);
        }
        try {
            fakeCommand = this.qG.getSQLQuery(db.getNameResolverHook());
        }
        catch (RuntimeException e) {
            throw new MakumbaError(e, this.debugString + "\n" + OQLQuery);
        }
        String fakeCommandUpper = fakeCommand.toUpperCase();
        StringBuffer replaceLabel = new StringBuffer();
        int n = 0;
        int maxN = fakeCommandUpper.indexOf(" FROM ");
        while (true) {
            lastN = n;
            n = fakeCommand.indexOf(label + ".", lastN);
            if (n == -1 || n > maxN) break;
            replaceLabel.append(fakeCommand.substring(lastN, n));
            n += label.length() + 1;
        }
        replaceLabel.append(fakeCommand.substring(lastN, maxN));
        lastN = fakeCommandUpper.indexOf(" WHERE ");
        if (lastN < 0) {
            lastN = fakeCommand.length();
        }
        n = fakeCommand.lastIndexOf(" " + label, lastN);
        replaceLabel.append(fakeCommand.substring(maxN, n));
        n = lastN;
        while (true) {
            lastN = n;
            n = fakeCommand.indexOf(label + ".", lastN);
            if (n == -1) break;
            replaceLabel.append(fakeCommand.substring(lastN, n));
            n += label.length() + 1;
        }
        replaceLabel.append(fakeCommand.substring(lastN));
        fakeCommand = replaceLabel.toString();
        fakeCommandUpper = fakeCommand.toUpperCase();
        StringBuffer command = new StringBuffer();
        command.append(set == null ? "DELETE FROM" : "UPDATE");
        command.append(fakeCommand.substring(fakeCommandUpper.indexOf(" FROM ") + 5, fakeCommandUpper.indexOf(" WHERE ")));
        if (set != null) {
            String setString = fakeCommand.substring(fakeCommandUpper.indexOf("SELECT ") + 7, fakeCommandUpper.indexOf(" FROM "));
            n = 0;
            while (true) {
                if ((n = setString.toLowerCase().indexOf("is null", n)) == -1) {
                    n = setString.toLowerCase().indexOf("is  null", n);
                    if (n == -1) break;
                    setString = setString.substring(0, n) + " = null" + setString.substring(n + 8);
                    continue;
                }
                setString = setString.substring(0, n) + " = null" + setString.substring(n + 7);
            }
            command.append(" SET ").append(setString);
        }
        if (where != null) {
            command.append(fakeCommand.substring(fakeCommandUpper.indexOf(" WHERE ")));
        }
        this.debugString = this.debugString + "\n generated SQL: " + command;
        this.updateCommand = command.toString();
    }

    @Override
    public int execute(DBConnection dbc, Map<String, Object> args) {
        this.compileUpdateCommand(this.db, this.type, this.setWhere, this.DELIM, args);
        PreparedStatement ps = ((SQLDBConnection)dbc).getPreparedStatement(this.updateCommand);
        try {
            int rez;
            String s = this.assigner.assignParameters(ps, this.qG.getSQLQueryArguments());
            if (s != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to update:\n" + this.debugString + "\n" + s);
            }
            Logger.getLogger("org.makumba.db.update.execution").fine("" + this.db.getWrappedStatementToString(ps));
            Date d = new Date();
            try {
                rez = ps.executeUpdate();
            }
            catch (SQLException se) {
                Database db = (Database)dbc.getHostDatabase();
                if (db.isForeignKeyViolationException(se)) {
                    throw new ForeignKeyError(db.parseReadableForeignKeyErrorMessage(se));
                }
                if (db.isDuplicateException(se)) {
                    NotUniqueException nue = new NotUniqueException(se.getMessage());
                    nue.setFields(db.getDuplicateFields(se));
                    throw nue;
                }
                Database.logException(se);
                throw new DBError(se, this.debugString);
            }
            long diff = new Date().getTime() - d.getTime();
            Logger.getLogger("org.makumba.db.update.performance").fine("" + diff + " ms " + this.debugString);
            int n = rez;
            return n;
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }
}

