/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.makumba.CompositeValidationException;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NotUniqueException;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.commons.NameResolver;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.SQLPointer;
import org.makumba.commons.StringUtils;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.Table;
import org.makumba.db.makumba.sql.Database;
import org.makumba.db.makumba.sql.SQLDBConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableManager
extends Table {
    protected String tbname;
    protected String handlerList;
    protected String handlerListAutoIncrement;
    protected String indexDBField;
    protected String indexField;
    protected String modTable;
    protected long primaryKeyCurrentIndex;
    protected int dbsv;
    boolean alter;
    boolean exists_;
    Hashtable<String, Object> handlerExist = new Hashtable();
    Dictionary<String, Integer> keyIndex;
    String preparedInsertString;
    String preparedInsertAutoIncrementString;
    String preparedDeleteString;
    String preparedDeleteFromString;
    String preparedDeleteFromIgnoreDbsvString;
    Hashtable<String, String> checkDuplicate = new Hashtable();
    Hashtable<String, String> checkNullDuplicate = new Hashtable();
    boolean admin;
    Hashtable<String, Boolean> indexes = new Hashtable();
    Boolean parsedForeignKeys = false;
    Hashtable<String, String[]> foreignKeys = new Hashtable();
    Hashtable<String, String[]> extraIndexes;
    private boolean autoIncrementAlter;
    static SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    @Override
    public boolean exists() {
        return this.exists_;
    }

    @Override
    public boolean exists(String s) {
        return this.handlerExist.get(s) != null;
    }

    public String getDBName() {
        return this.tbname;
    }

    protected Database getSQLDatabase() {
        return (Database)this.getDatabase();
    }

    protected boolean usesHidden() {
        return true;
    }

    void makeKeyIndex() {
        if (this.keyIndex == null) {
            this.keyIndex = new Hashtable<String, Integer>();
            for (int i = 0; i < this.getDataDefinition().getFieldNames().size(); ++i) {
                FieldDefinition fi = this.getDataDefinition().getFieldDefinition(i);
                if (fi.getType().startsWith("set")) continue;
                this.keyIndex.put(fi.getName(), new Integer(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void open(Properties config, NameResolver nr) {
        this.setTableAndFieldNames(nr);
        if (!this.getDataDefinition().isTemporary()) {
            DBConnectionWrapper dbcw = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
            SQLDBConnection dbc = (SQLDBConnection)dbcw.getWrapped();
            try {
                this.checkStructure(dbc, config);
                this.initFields(dbc, config);
                this.preparedInsertString = this.prepareInsert(false);
                this.preparedInsertAutoIncrementString = this.prepareInsert(true);
                this.preparedDeleteString = this.prepareDelete();
                this.preparedDeleteFromIgnoreDbsvString = "DELETE FROM " + this.getDBName();
                this.preparedDeleteFromString = "DELETE FROM " + this.getDBName() + " WHERE " + this.indexDBField + " >= ? AND " + this.indexDBField + " <= ?";
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                dbcw.close();
            }
        } else {
            this.makeKeyIndex();
        }
    }

    @Override
    public void close() {
        this.resetPrimaryKey();
    }

    protected void setTableAndFieldNames(NameResolver nr) {
        this.tbname = nr.resolveTypeName(this.dd);
    }

    @Override
    public boolean canAdmin() {
        return this.admin;
    }

    protected void checkStructure(SQLDBConnection dbc, Properties config) {
        String s = Database.findConfig(config, "admin#" + this.getDataDefinition().getName());
        this.admin = s != null && config.getProperty(s).trim().equals("true");
        s = Database.findConfig(config, "alter#" + this.getDataDefinition().getName());
        this.alter = s != null && config.getProperty(s).trim().equals("true");
        Logger.getLogger("org.makumba.db.init.tablechecking").info(this.getDatabase().getName() + ": checking " + this.getDataDefinition().getName() + " as " + this.tbname);
        try {
            CatalogChecker cs = null;
            if (this.getSQLDatabase().catalog == null) {
                throw new MakumbaError(this.getDatabase().getName() + ": could not open catalog");
            }
            cs = new CatalogChecker(this.getSQLDatabase().catalog);
            if (cs.shouldCreate()) {
                this.create(dbc, this.tbname, this.alter);
                this.exists_ = this.alter;
                config.put("makumba.wasCreated", "");
                this.makeKeyIndex();
            } else {
                this.exists_ = true;
                this.alter(dbc, cs, this.alter);
            }
        }
        catch (SQLException sq) {
            sq.printStackTrace();
            throw new DBError(sq);
        }
    }

    protected void initFields(SQLDBConnection dbc, Properties config) throws SQLException {
        try {
            ResultSet rs = dbc.getMetaData().getIndexInfo(null, null, this.getDBName(), false, false);
            while (rs.next()) {
                String iname = rs.getString("INDEX_NAME");
                boolean non_unique = rs.getBoolean("NON_UNIQUE");
                if (iname == null) continue;
                this.indexes.put(iname.toLowerCase(), new Boolean(non_unique));
            }
            rs.close();
            ResultSet rs2 = dbc.getMetaData().getImportedKeys(null, null, this.getDBName());
            while (rs2.next()) {
                String[] temp_foreign = new String[]{rs2.getString("PKTABLE_NAME"), rs2.getString("PKCOLUMN_NAME")};
                if (this.foreignKeys.get(rs2.getString("FKCOLUMN_NAME")) != null) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").info("WARNING: duplicate foreign keys for table `" + rs2.getString("FKTABLE_NAME") + "`, field `" + rs2.getString("FKCOLUMN_NAME") + "`");
                    continue;
                }
                this.foreignKeys.put(rs2.getString("FKCOLUMN_NAME").toLowerCase(), temp_foreign);
            }
            rs2.close();
        }
        catch (SQLException e) {
            Database.logException(e, dbc);
            throw new DBError(e);
        }
        this.extraIndexes = (Hashtable)this.indexes.clone();
        for (String string : this.dd.getFieldNames()) {
            String fieldName = string;
            if (this.getFieldDefinition(fieldName).getType().startsWith("set")) continue;
            this.onStartup(fieldName, config, dbc);
        }
        DataDefinition.MultipleUniqueKeyDefinition[] multiFieldUniqueKeys = this.getDataDefinition().getMultiFieldUniqueKeys();
        for (int i = 0; i < multiFieldUniqueKeys.length; ++i) {
            Object[] fieldNames = multiFieldUniqueKeys[i].getFields();
            if (!multiFieldUniqueKeys[i].isKeyOverSubfield() && !this.isIndexOk((String[])fieldNames)) {
                String fields = StringUtils.toString(fieldNames);
                String briefMulti = this.getDataDefinition().getName() + "#" + fields.toLowerCase();
                try {
                    Statement st = dbc.createStatement();
                    st.executeUpdate(this.indexCreateUniqueSyntax((String[])fieldNames));
                    Logger.getLogger("org.makumba.db.init.tablechecking").info("INDEX ADDED on " + briefMulti);
                    st.close();
                    this.indexCreated(dbc);
                }
                catch (SQLException e) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").warning("Problem adding multi-field INDEX on " + briefMulti + ": " + e.getMessage() + " [ErrorCode: " + e.getErrorCode() + ", SQLstate:" + e.getSQLState() + "]");
                    if (this.getDatabase().isDuplicateException(e)) {
                        throw new DBError("Error adding unique key for " + this.getDataDefinition().getName() + " on fields " + fields + ": " + e.getMessage());
                    }
                    throw new DBError(e);
                }
            }
            this.extraIndexes.remove(StringUtils.concatAsString(fieldNames).toLowerCase());
        }
        if (!this.getDatabase().usesHibernateIndexes()) {
            if (this.alter) {
                Enumeration<String> ei = this.extraIndexes.keys();
                while (ei.hasMoreElements()) {
                    String indexName = ei.nextElement();
                    String syntax = "DROP INDEX " + indexName + " ON " + this.getDBName();
                    try {
                        Statement st = dbc.createStatement();
                        st.executeUpdate(syntax);
                        Logger.getLogger("org.makumba.db.init.tablechecking").info("INDEX DROPPED on " + this.getDataDefinition().getName() + "#" + indexName);
                        st.close();
                    }
                    catch (SQLException e) {
                        this.treatIndexException(e, syntax, dbc);
                    }
                }
            } else {
                StringBuffer extraList = new StringBuffer();
                String separator = "";
                Enumeration<String> ei = this.extraIndexes.keys();
                while (ei.hasMoreElements()) {
                    extraList.append(separator).append(ei.nextElement());
                    separator = ", ";
                }
                if (extraList.length() > 0) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").warning("Extra indexes on " + this.getDataDefinition().getName() + ": " + extraList);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        this.fieldList(sb, this.dd.getFieldNames().elements());
        this.handlerList = sb.toString();
        sb = new StringBuffer();
        Enumeration<String> e = this.dd.getFieldNames().elements();
        e.nextElement();
        this.fieldList(sb, e);
        this.handlerListAutoIncrement = sb.toString();
        this.indexField = this.dd.getIndexPointerFieldName();
        this.indexDBField = this.getFieldDBName(this.indexField);
    }

    private void treatIndexException(SQLException e, String command, SQLDBConnection dbc) {
        Level lev = Level.FINE;
        if (e.getMessage().indexOf("check that column/key exists") != -1) {
            lev = Level.FINEST;
        }
        if (command.indexOf("fk") != -1) {
            lev = Level.WARNING;
        }
        if (!Logger.getLogger("org.makumba.db.exception").isLoggable(lev)) {
            return;
        }
        Logger.getLogger("org.makumba.db.exception").log(lev, "Unsuccessful: " + command);
        Database.logException(e, dbc, lev);
    }

    @Override
    public int deleteFrom(DBConnection here, DBConnection source, boolean ignoreDbsv) {
        if (!this.exists()) {
            return 0;
        }
        if (!this.canAdmin()) {
            throw new MakumbaError("no administration approval for " + this.getDataDefinition().getName());
        }
        if (here instanceof DBConnectionWrapper) {
            here = ((DBConnectionWrapper)here).getWrapped();
        }
        PreparedStatement ps = null;
        if (ignoreDbsv) {
            ps = ((SQLDBConnection)here).getPreparedStatement(this.preparedDeleteFromIgnoreDbsvString);
        } else {
            ps = ((SQLDBConnection)here).getPreparedStatement(this.preparedDeleteFromString);
            try {
                ps.setInt(1, source.getHostDatabase().getMinPointerValue());
                ps.setInt(2, source.getHostDatabase().getMaxPointerValue());
            }
            catch (SQLException e) {
                Database.logException(e);
                throw new DBError(e);
            }
        }
        int n = this.getSQLDatabase().exec(ps);
        if (!this.getSQLDatabase().isAutoIncrement()) {
            this.resetPrimaryKey();
        }
        return n;
    }

    protected void alter(SQLDBConnection dbc, CheckingStrategy cs, boolean alter) throws SQLException {
        Vector<String> present = new Vector<String>();
        Vector<String> add = new Vector<String>();
        Vector<String> modify = new Vector<String>();
        Vector<String> drop = new Vector<String>();
        Object withness = new Object();
        while (cs.hasMoreColumns()) {
            String dbfn = cs.columnName();
            boolean found = false;
            for (String string : this.dd.getFieldNames()) {
                String fieldName = string;
                if (this.getFieldDefinition(fieldName).getType().startsWith("set") || !this.getFieldDBName(fieldName).toLowerCase().equals(dbfn.toLowerCase())) continue;
                this.handlerExist.put(fieldName, withness);
                present.addElement(fieldName);
                if (!(cs.checkColumn(fieldName) || alter && this.alter(dbc, fieldName, this.getColumnAlterKeyword()))) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").warning("should modify: " + fieldName + " " + this.getFieldDBName(fieldName) + " " + this.getFieldDBType(fieldName) + " " + cs.columnType() + " " + cs.columnName());
                    modify.addElement(fieldName);
                }
                found = true;
            }
            if (found) continue;
            drop.addElement(dbfn);
            Logger.getLogger("org.makumba.db.init.tablechecking").warning("extra field: " + cs.columnName() + " " + cs.columnType() + " " + cs.columnTypeName());
        }
        Vector<String> v = new Vector<String>();
        this.keyIndex = new Hashtable<String, Integer>();
        for (String fieldName : this.dd.getFieldNames()) {
            if (this.getFieldDefinition(fieldName).getType().startsWith("set")) continue;
            if (!(this.handlerExist.get(fieldName) != null || alter && this.alter(dbc, fieldName, "ADD"))) {
                add.addElement(fieldName);
                Logger.getLogger("org.makumba.db.init.tablechecking").warning("should add " + fieldName + " " + this.getFieldDBName(fieldName) + " " + this.getFieldDBType(fieldName));
                continue;
            }
            this.keyIndex.put(fieldName, new Integer(v.size()));
            v.addElement(fieldName);
        }
        this.doAlter(dbc, drop, present, add, modify);
    }

    protected String getColumnAlterKeyword() {
        return "MODIFY";
    }

    boolean alter(SQLDBConnection dbc, String fieldName, String op) throws SQLException {
        Statement st = dbc.createStatement();
        String command = null;
        if (!this.autoIncrementAlter) {
            try {
                command = "DROP INDEX " + this.getFieldDBIndexName(fieldName) + " ON " + this.getDBName();
                st.executeUpdate(command);
                Logger.getLogger("org.makumba.db.init.tablechecking").info("SUCCESS: " + command);
            }
            catch (SQLException e) {
                this.treatIndexException(e, command, dbc);
            }
        }
        this.autoIncrementAlter = false;
        String s = "ALTER TABLE " + this.getDBName() + " " + op + " " + this.inCreate(fieldName, this.getSQLDatabase());
        Logger.getLogger("org.makumba.db.init.tablechecking").info(this.getSQLDatabase().getName() + ": " + s);
        st.executeUpdate(s);
        this.handlerExist.put(fieldName, "");
        dbc.commit();
        st.close();
        return true;
    }

    protected void doAlter(SQLDBConnection dbc, Vector<String> drop, Vector<String> present, Vector<String> add, Vector<String> modify) throws SQLException {
        if (add.size() == 0 && modify.size() == 0) {
            return;
        }
        if (present.size() == 0) {
            this.create(dbc, this.tbname, this.alter);
        }
    }

    protected void create(SQLDBConnection dbc, String tblname, boolean really) throws SQLException {
        Statement st = dbc.createStatement();
        if (really && !tblname.startsWith("temp")) {
            try {
                st.executeUpdate("DROP TABLE " + tblname);
            }
            catch (SQLException e) {
                this.getSQLDatabase().checkState(e, this.getTableMissingStateName(dbc));
            }
        }
        StringBuffer ret = new StringBuffer();
        String sep = "";
        for (String fieldName : this.dd.getFieldNames()) {
            if (this.getFieldDefinition(fieldName).getType().startsWith("set")) continue;
            ret.append(sep).append(this.inCreate(fieldName, this.getSQLDatabase()));
            sep = ",";
        }
        String command = "CREATE TABLE " + tblname + "(" + ret + ")";
        command = this.createDbSpecific(command);
        if (!really) {
            Logger.getLogger("org.makumba.db.init.tablechecking").warning("would be:\n" + command);
            return;
        }
        if (!tblname.startsWith("temp")) {
            Logger.getLogger("org.makumba.db.init.tablechecking").info(command);
        }
        st.executeUpdate(command);
        if (!tblname.startsWith("temp")) {
            dbc.commit();
        }
        st.close();
    }

    protected void fieldList(StringBuffer command, Enumeration<String> e) {
        String comma = "";
        while (e.hasMoreElements()) {
            String fieldName = e.nextElement();
            if (this.getFieldDefinition(fieldName).getType().startsWith("set")) continue;
            command.append(comma);
            comma = ", ";
            command.append(this.getFieldDBName(fieldName));
        }
    }

    protected String prepareInsert(boolean autoIncrement) {
        StringBuffer ret = new StringBuffer();
        String sep = "";
        for (String fieldName : this.dd.getFieldNames()) {
            if (this.getFieldDefinition(fieldName).getType().startsWith("set") || this.getFieldDefinition(fieldName).getIntegerType() == 3 && autoIncrement) continue;
            ret.append(sep).append(this.inPreparedInsert(fieldName));
            sep = ",";
        }
        return "INSERT INTO " + this.tbname + " (" + (autoIncrement ? this.handlerListAutoIncrement : this.handlerList) + ") VALUES (" + ret + ")";
    }

    @Override
    public Pointer insertRecordImpl(DBConnection dbc, Dictionary<String, Object> d) {
        boolean wasIndex = d.get(this.indexField) != null;
        boolean wasCreate = d.get("TS_create") != null;
        boolean wasModify = d.get("TS_create") != null;
        try {
            if (dbc instanceof DBConnectionWrapper) {
                dbc = ((DBConnectionWrapper)dbc).getWrapped();
            }
            PreparedStatement ps = wasIndex || !this.getSQLDatabase().isAutoIncrement() ? ((SQLDBConnection)dbc).getPreparedStatement(this.preparedInsertString) : ((SQLDBConnection)dbc).getPreparedStatement(this.preparedInsertAutoIncrementString);
            int n = 0;
            for (String fieldName : this.dd.getFieldNames()) {
                if (this.getFieldDefinition(fieldName).getType().startsWith("set") || this.getFieldDefinition(fieldName).getIntegerType() == 3 && !wasIndex && this.getSQLDatabase().isAutoIncrement()) continue;
                ++n;
                try {
                    this.setInsertArgument(fieldName, ps, n, d);
                }
                catch (Throwable ex) {
                    throw new DBError(ex, "insert into \"" + this.getDataDefinition().getName() + "\" at field \"" + fieldName + "\" could not assign value \"" + d.get(fieldName) + "\" " + (d.get(fieldName) != null ? "of type \"" + d.get(fieldName).getClass().getName() + "\"" : ""));
                }
            }
            if (this.getSQLDatabase().exec(ps) == -1) {
                this.findDuplicates((SQLDBConnection)dbc, d);
            }
            if (!wasIndex && this.getSQLDatabase().isAutoIncrement()) {
                ps = ((SQLDBConnection)dbc).getPreparedStatement(this.getQueryAutoIncrementSyntax());
                ResultSet rs = ps.executeQuery();
                rs.next();
                d.put(this.indexField, new SQLPointer(this.getDataDefinition().getName(), rs.getInt(1)));
                rs.close();
                ps.close();
            }
            Pointer ret = (Pointer)d.get(this.indexField);
            if (!wasIndex) {
                d.remove(this.indexField);
            }
            if (!wasCreate) {
                d.remove("TS_create");
            }
            if (!wasModify) {
                d.remove("TS_modify");
            }
            return ret;
        }
        catch (Throwable t2) {
            DBError t2;
            if (t2 instanceof CompositeValidationException) {
                throw (CompositeValidationException)t2;
            }
            if (!(t2 instanceof DBError)) {
                t2 = new DBError(t2);
            }
            throw (DBError)t2;
        }
    }

    @Override
    public void findDuplicates(DBConnection dbc, Dictionary<String, Object> d) {
        CompositeValidationException notUnique = new CompositeValidationException();
        Iterator<String> i$ = this.dd.getFieldNames().iterator();
        while (i$.hasNext()) {
            String string;
            String fieldName = string = i$.next();
            Object val = d.get(fieldName);
            if (this.getFieldDefinition(fieldName).getType().startsWith("set") || !this.checkDuplicate(fieldName, dbc, d)) continue;
            FieldDefinition fd = this.dd.getFieldDefinition(fieldName);
            if (fd.getNotUniqueErrorMessage() == null) {
                notUnique.addException(new NotUniqueException(this.getFieldDefinition(fieldName), val));
                continue;
            }
            notUnique.addException(new NotUniqueException(fd.getNotUniqueErrorMessage()));
        }
        DataDefinition.MultipleUniqueKeyDefinition[] multiFieldUniqueKeys = this.getDataDefinition().getMultiFieldUniqueKeys();
        for (int i = 0; i < multiFieldUniqueKeys.length; ++i) {
            if (multiFieldUniqueKeys[i].isKeyOverSubfield()) continue;
            String[] fields = multiFieldUniqueKeys[i].getFields();
            Object[] values = new Object[fields.length];
            for (int j = 0; j < fields.length; ++j) {
                values[j] = d.get(fields[j]);
            }
            if (!this.checkDuplicate(fields, values, dbc)) continue;
            notUnique.addException(new NotUniqueException(multiFieldUniqueKeys[i].getFields()[0], multiFieldUniqueKeys[i].getErrorMessage(values)));
        }
        if (notUnique.getExceptions().size() > 0) {
            throw notUnique;
        }
    }

    protected String prepareDelete() {
        return "DELETE FROM " + this.tbname + " WHERE " + this.inPreparedUpdate(this.indexField);
    }

    public void deleteRecord(DBConnection dbc, Pointer uid) {
        if (dbc instanceof DBConnectionWrapper) {
            dbc = ((DBConnectionWrapper)dbc).getWrapped();
        }
        PreparedStatement ps = ((SQLDBConnection)dbc).getPreparedStatement(this.preparedDeleteString);
        try {
            this.setUpdateArgument(this.getDBName(), ps, 1, uid);
            this.getSQLDatabase().exec(ps);
        }
        catch (SQLException f) {
            Database.logException(f);
            throw new DBError(f);
        }
    }

    @Deprecated
    public void updateRecord(DBConnection dbc, Pointer uid, Dictionary<String, Object> d) {
        if (dbc instanceof DBConnectionWrapper) {
            dbc = ((DBConnectionWrapper)dbc).getWrapped();
        }
        d.remove(this.indexField);
        d.remove("TS_create");
        d.put("TS_modify", new Date());
        StringBuffer command = new StringBuffer("UPDATE ").append(this.tbname).append(" SET ");
        String s = "";
        Enumeration<String> e = d.keys();
        while (e.hasMoreElements()) {
            String fieldName;
            String fieldDBName;
            if (s.length() > 0) {
                command.append(",");
            }
            if ((fieldDBName = this.getFieldDBName(fieldName = e.nextElement())) == null) {
                throw new DBError(new Exception("no such field " + fieldDBName + " in " + this.getDBName()));
            }
            s = this.inPreparedUpdate(fieldName);
            command.append(s);
        }
        command.append(" WHERE " + this.inPreparedUpdate(this.indexField));
        try {
            PreparedStatement st = ((SQLDBConnection)dbc).getPreparedStatement(command.toString());
            int n = 1;
            Enumeration<String> e2 = d.keys();
            while (e2.hasMoreElements()) {
                String ss = e2.nextElement();
                this.setUpdateArgument(ss, st, n, d);
                ++n;
            }
            this.setUpdateArgument(this.getDBName(), st, n, uid);
            if (this.getSQLDatabase().exec(st) == -1) {
                this.findDuplicates((SQLDBConnection)dbc, d);
            }
            return;
        }
        catch (SQLException se) {
            throw new DBError(se);
        }
    }

    protected void fillResult(ResultSet rs, Dictionary<String, Object> p) throws SQLException {
        int n = this.dd.getFieldNames().size();
        int i = 0;
        while (i < n) {
            if (this.dd.getFieldDefinition(i).getType().startsWith("set")) continue;
            this.setValue(this.dd.getFieldDefinition(i).getName(), p, rs, ++i);
        }
    }

    protected void fillResult(ResultSet rs, Object[] data) throws SQLException {
        int n = this.dd.getFieldNames().size();
        for (int i = 0; i < n; ++i) {
            if (this.dd.getFieldDefinition(i).getType().startsWith("set")) continue;
            try {
                data[i] = this.getValue(this.dd.getFieldDefinition(i).getName(), rs, i + 1);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.getLogger("org.makumba.db.query.execution").log(Level.SEVERE, "" + i + " " + this.dd.getName() + " " + this.keyIndex + " " + this.dd.getFieldNames(), e);
                throw e;
            }
        }
    }

    public Object getValue(ResultSet rs, String fieldName, int i) {
        try {
            return this.getValue(fieldName, rs, i);
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
    }

    public Object getValue(String fieldName, ResultSet rs, int i) throws SQLException {
        if (!this.getFieldDefinition(fieldName).getType().startsWith("set")) {
            switch (this.getFieldDefinition(fieldName).getIntegerType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return this.get_ptrDB_Value(fieldName, rs, i);
                }
                case 4: 
                case 5: {
                    return this.get_int_Value(fieldName, rs, i);
                }
                case 6: 
                case 7: {
                    return this.get_char_Value(fieldName, rs, i);
                }
                case 8: {
                    return this.get_text_Value(fieldName, rs, i);
                }
                case 18: {
                    return this.get_binary_Value(fieldName, rs, i);
                }
                case 19: {
                    return this.get_boolean_Value(fieldName, rs, i);
                }
                case 9: {
                    return this.get_dateTime_Value(fieldName, rs, i);
                }
                case 10: 
                case 11: {
                    return this.get_timeStamp_Value(fieldName, rs, i);
                }
                case 14: {
                    return this.get_nil_Value(fieldName, rs, i);
                }
                case 15: {
                    return this.get_real_Value(fieldName, rs, i);
                }
            }
            return this.base_getValue(fieldName, rs, i);
        }
        throw new RuntimeException("shouldn't be here");
    }

    private Object get_real_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        double n = rs.getDouble(i);
        if (rs.wasNull()) {
            return null;
        }
        return new Double(n);
    }

    public Object base_getValue(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = rs.getObject(i);
        if (rs.wasNull()) {
            return null;
        }
        return o;
    }

    public Object get_ptrDB_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = this.base_getValue(fieldName, rs, i);
        if (o == null) {
            return o;
        }
        return new SQLPointer(this.dd.getFieldDefinition(fieldName).getPointedType().getName(), ((Number)o).longValue());
    }

    public Object get_int_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        int n = rs.getInt(i);
        if (rs.wasNull()) {
            return null;
        }
        return new Integer(n);
    }

    public Object get_char_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = this.base_getValue(fieldName, rs, i);
        if (o instanceof byte[]) {
            String a = new String((byte[])o);
        }
        if (o == null) {
            return o;
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        return o;
    }

    public Object get_text_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = this.base_getValue(fieldName, rs, i);
        if (o == null) {
            return o;
        }
        if (o instanceof byte[]) {
            return new Text(new String((byte[])o));
        }
        return o;
    }

    public Object get_binary_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = this.base_getValue(fieldName, rs, i);
        if (o == null) {
            return o;
        }
        return Text.getText(o);
    }

    public Object get_boolean_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        boolean b = rs.getBoolean(i);
        if (rs.wasNull()) {
            return null;
        }
        return b;
    }

    public Object get_dateTime_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Object o = rs.getObject(i);
        if (rs.wasNull()) {
            return null;
        }
        if (o instanceof String) {
            try {
                o = sqlDateFormat.parse((String)o);
            }
            catch (ParseException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return o;
    }

    public Object get_nil_Value(String fieldName, ResultSet rs, int i) {
        return null;
    }

    public Object get_timeStamp_Value(String fieldName, ResultSet rs, int i) throws SQLException {
        Timestamp o = rs.getTimestamp(i);
        if (rs.wasNull()) {
            return null;
        }
        return o;
    }

    public void setUpdateArgument(String fieldName, PreparedStatement ps, int n, Object o) throws SQLException {
        if (o == this.getFieldDefinition(fieldName).getNull()) {
            this.setNullArgument(fieldName, ps, n);
        } else {
            try {
                this.setArgument(fieldName, ps, n, o);
            }
            catch (SQLException e) {
                Logger.getLogger("org.makumba.db.update.execution").log(Level.SEVERE, this.getDBName() + "  " + o.getClass(), e);
                throw e;
            }
        }
    }

    public void setUpdateArgument(String fieldName, PreparedStatement ps, int n, Dictionary<String, Object> d) throws SQLException {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 3: 
            case 10: {
                throw new RuntimeException("shouldn't be called");
            }
            case 11: {
                this.nxt(fieldName, d);
            }
        }
        this.setUpdateArgument(fieldName, ps, n, d.get(fieldName));
    }

    public void setNullArgument(String fieldName, PreparedStatement ps, int n) throws SQLException {
        ps.setNull(n, this.getSQLType(fieldName));
    }

    public void setArgument(String fieldName, PreparedStatement ps, int n, Object o) throws SQLException {
        if (this.getFieldDefinition(fieldName).getIntegerType() == 18) {
            this.set_binary_Argument(fieldName, ps, n, o);
        } else if (this.getFieldDefinition(fieldName).getIntegerType() == 8 || this.getFieldDefinition(fieldName).getIntegerType() == 6 || this.getFieldDefinition(fieldName).getIntegerType() == 7) {
            this.set_text_Argument(fieldName, ps, n, o);
        } else {
            ps.setObject(n, this.toSQLObject(fieldName, o));
        }
    }

    public void set_binary_Argument(String fieldName, PreparedStatement ps, int n, Object o) throws SQLException {
        Text t = Text.getText(o);
        ps.setBinaryStream(n, t.toBinaryStream(), t.length());
    }

    public void set_text_Argument(String fieldName, PreparedStatement ps, int n, Object o) throws SQLException {
        Text t = Text.getText(o);
        ps.setString(n, t.getString());
    }

    protected int getSQLType(String fieldName) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.get_ptrDB_SQLType(fieldName);
            }
            case 4: 
            case 5: {
                return this.get_int_SQLType(fieldName);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.get_char_SQLType(fieldName);
            }
            case 18: {
                return this.get_binary_SQLType(fieldName);
            }
            case 19: {
                return this.get_boolean_SQLType(fieldName);
            }
            case 9: {
                return this.get_dateTime_SQLType(fieldName);
            }
            case 15: {
                return this.get_real_SQLType(fieldName);
            }
            case 10: 
            case 11: {
                return this.get_timeStamp_SQLType(fieldName);
            }
        }
        throw new RuntimeException("" + fieldName + " should be redefined");
    }

    public int get_ptrDB_SQLType(String fieldName) {
        return 4;
    }

    protected int get_int_SQLType(String fieldName) {
        return 4;
    }

    protected int get_char_SQLType(String fieldName) {
        return 12;
    }

    protected int get_binary_SQLType(String fieldName) {
        return -4;
    }

    protected int get_boolean_SQLType(String fieldName) {
        return -7;
    }

    public int get_dateTime_SQLType(String fieldName) {
        return 93;
    }

    protected int get_real_SQLType(String fieldName) {
        return 8;
    }

    public int get_timeStamp_SQLType(String fieldName) {
        return 93;
    }

    public Object toSQLObject(String fieldName, Object o) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.toSQL_ptrDB_Object(fieldName, o);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.toSQL_dateTime_Object(fieldName, o);
            }
        }
        return o;
    }

    public Object base_toSQLObject(String fieldName, Object o) {
        return o;
    }

    public Object toSQL_ptrDB_Object(String fieldName, Object o) {
        return new Integer((int)((Pointer)o).longValue());
    }

    public Object toSQL_dateTime_Object(String fieldName, Object o) {
        return new Timestamp(((Date)o).getTime());
    }

    public String getFieldDBName(String fieldName) {
        return this.getDatabase().getNameResolver().resolveFieldName(this.dd, fieldName);
    }

    public String inCreate(String fieldName, Database d) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 6: 
            case 7: {
                return this.in_char_Create(fieldName, d);
            }
            case 19: {
                return this.in_boolean_Create(fieldName, d);
            }
            case 3: {
                return this.in_primaryKeyCreate(fieldName, d);
            }
        }
        return this.base_inCreate(fieldName, d);
    }

    public String base_inCreate(String fieldName, Database d) {
        return this.getFieldDBName(fieldName) + " " + this.getFieldDBType(fieldName, d);
    }

    public String in_char_Create(String fieldName, Database d) {
        String s = Database.getEngineProperty(d.getEngine() + ".charBinary");
        s = s != null && s.equals("true") ? " BINARY" : "";
        return this.getFieldDBName(fieldName) + " " + this.getFieldDBType(fieldName, d) + "(" + this.getFieldDefinition(fieldName).getWidth() + ")" + s;
    }

    public String in_boolean_Create(String fieldName, Database d) {
        return this.getFieldDBName(fieldName) + " " + this.getFieldDBType(fieldName, d) + "(1)";
    }

    public String inPreparedUpdate(String fieldName) {
        return this.getFieldDBName(fieldName) + "=?";
    }

    protected String getFieldDBType(String fieldName) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.get_ptrDB_FieldDBType(fieldName);
            }
            case 4: 
            case 5: {
                return this.get_int_FieldDBType(fieldName);
            }
            case 6: 
            case 7: {
                return this.get_char_FieldDBType(fieldName);
            }
            case 8: {
                return this.get_text_FieldDBType(fieldName);
            }
            case 18: {
                return this.get_binary_FieldDBType(fieldName);
            }
            case 19: {
                return this.get_boolean_FieldDBType(fieldName);
            }
            case 9: {
                return this.get_dateTime_FieldDBType(fieldName);
            }
            case 10: 
            case 11: {
                return this.get_timeStamp_FieldDBType(fieldName);
            }
            case 15: {
                return this.get_real_FieldDBType(fieldName);
            }
        }
        throw new RuntimeException("" + fieldName + " should be redefined");
    }

    protected String get_ptrDB_FieldDBType(String fieldName) {
        return "INTEGER";
    }

    protected String get_int_FieldDBType(String fieldName) {
        return "INTEGER";
    }

    protected String get_char_FieldDBType(String fieldName) {
        return "VARCHAR";
    }

    protected String get_text_FieldDBType(String fieldName) {
        return "LONGTEXT";
    }

    protected String get_binary_FieldDBType(String fieldName) {
        return "LONG VARBINARY";
    }

    protected String get_boolean_FieldDBType(String fieldName) {
        return "BIT";
    }

    protected String get_dateTime_FieldDBType(String fieldName) {
        return "DATETIME";
    }

    protected String get_real_FieldDBType(String fieldName) {
        return "DOUBLE PRECISION";
    }

    protected String get_timeStamp_FieldDBType(String fieldName) {
        return "TIMESTAMP";
    }

    protected String getFieldDBType(String fieldName, Database d) {
        String s = Database.getEngineProperty(d.getEngine() + "." + this.getFieldDefinition(fieldName).getDataType());
        if (s == null) {
            return this.getFieldDBType(fieldName);
        }
        return s;
    }

    public String getFieldDBIndexName(String fieldName) {
        return this.getFieldDBName(fieldName);
    }

    public String inPreparedInsert(String fieldName) {
        return "?";
    }

    public void setInsertArgument(String fieldName, PreparedStatement ps, int n, Dictionary<String, Object> d) throws SQLException {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 10: 
            case 11: {
                if (d.get(fieldName) == null) {
                    this.nxt(fieldName, d);
                }
                this.set_timeStamp_InsertArgument(fieldName, ps, n, d);
                break;
            }
            case 3: {
                Pointer p = (Pointer)d.get(fieldName);
                if (p != null) {
                    this.base_setInsertArgument(fieldName, ps, n, d);
                    if (p.getDbsv() == this.dbsv && p.longValue() > this.primaryKeyCurrentIndex) {
                        this.primaryKeyCurrentIndex = p.longValue();
                    }
                    return;
                }
                ps.setInt(n, (int)this.nxt_ptrIndex(fieldName, d).longValue());
                break;
            }
            default: {
                this.base_setInsertArgument(fieldName, ps, n, d);
            }
        }
    }

    public void base_setInsertArgument(String fieldName, PreparedStatement ps, int n, Dictionary<String, Object> d) throws SQLException {
        Object o = d.get(fieldName);
        if (o == null || o.equals(this.getFieldDefinition(fieldName).getNull())) {
            this.setNullArgument(fieldName, ps, n);
        } else {
            this.setArgument(fieldName, ps, n, o);
        }
    }

    public void set_timeStamp_InsertArgument(String fieldName, PreparedStatement ps, int n, Dictionary<String, Object> d) throws SQLException {
        Object o = d.get(fieldName);
        if (o instanceof Date && !(o instanceof Timestamp)) {
            d.put(fieldName, new Timestamp(((Date)o).getTime()));
        }
        this.base_setInsertArgument(fieldName, ps, n, d);
    }

    public void setCopyArgument(String fieldName, PreparedStatement ps, int n, Dictionary<String, Object> d) throws SQLException {
        try {
            Object o = d.get(fieldName);
            if (o == null || o.equals(this.getFieldDefinition(fieldName).getNull())) {
                this.setNullArgument(fieldName, ps, n);
            } else {
                this.setArgument(fieldName, ps, n, o);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(fieldName + " " + e.getMessage());
        }
    }

    public String inCondition(String fieldName, Dictionary<String, Object> d, String cond) {
        return this.getDBName() + cond + this.writeConstant(fieldName, d.get(fieldName));
    }

    public String writeConstant(String fieldName, Object o) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 6: 
            case 7: {
                return this.write_char_Constant(fieldName, o);
            }
            case 8: {
                return this.write_text_Constant(fieldName, o);
            }
            case 18: {
                return this.write_binary_Constant(fieldName, o);
            }
            case 19: {
                return this.write_boolean_Constant(fieldName, o);
            }
            case 9: {
                return this.write_dateTime_Constant(fieldName, o);
            }
            case 10: 
            case 11: {
                return this.write_timeStamp_Constant(fieldName, o);
            }
        }
        if (o == this.getFieldDefinition(fieldName).getNull()) {
            return "null";
        }
        return this.toSQLObject(fieldName, o).toString();
    }

    public String base_writeConstant(String fieldName, Object o) {
        if (o == this.getFieldDefinition(fieldName).getNull()) {
            return "null";
        }
        return this.toSQLObject(fieldName, o).toString();
    }

    public String write_char_Constant(String fieldName, Object o) {
        return Database.SQLEscape(o.toString());
    }

    public String write_text_Constant(String fieldName, Object o) {
        return Database.SQLEscape(o.toString());
    }

    public String write_binary_Constant(String fieldName, Object o) {
        return Database.SQLEscape(o.toString());
    }

    public String write_boolean_Constant(String fieldName, Object o) {
        return (Boolean)o != false ? "1" : "0";
    }

    public String write_dateTime_Constant(String fieldName, Object o) {
        return "'" + new Timestamp(((Date)o).getTime()) + "'";
    }

    public String write_timeStamp_Constant(String fieldName, Object o) {
        return "'" + this.base_writeConstant(fieldName, o) + "'";
    }

    protected String getEngineProperty(String fieldName, String s) {
        Database d = this.getSQLDatabase();
        return Database.getEngineProperty(d.getEngine() + "." + s);
    }

    public void onStartup(String fieldName, Properties config, SQLDBConnection dbc) throws SQLException {
        if (this.alter && this.shouldIndex(fieldName)) {
            this.manageIndexes(fieldName, dbc);
        }
        if (this.shouldIndex(fieldName)) {
            this.extraIndexes.remove(this.getFieldDBIndexName(fieldName).toLowerCase());
        }
        this.checkDuplicate.put(fieldName, "SELECT 1 FROM " + this.getDBName() + " WHERE " + this.getFieldDBName(fieldName) + "=?");
        this.checkNullDuplicate.put(fieldName, "SELECT 1 FROM " + this.getDBName() + " WHERE " + this.getFieldDBName(fieldName) + " is null");
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 3: {
                if (this.getSQLDatabase().isAutoIncrement()) break;
                this.dbsv = this.getSQLDatabase().getDbsv();
                Statement st = dbc.createStatement();
                this.resetPrimaryKey();
                ResultSet rs = st.executeQuery("SELECT MAX(" + this.getFieldDBName(fieldName) + "), COUNT(" + this.getFieldDBName(fieldName) + ") FROM " + this.tbname + " WHERE " + this.getFieldDBName(fieldName) + ">=" + this.primaryKeyCurrentIndex + " AND " + this.getFieldDBName(fieldName) + "<=" + this.getSQLDatabase().getMaxPointerValue());
                rs.next();
                if (rs.getLong(2) > 0L) {
                    this.primaryKeyCurrentIndex = rs.getLong(1);
                }
                rs.close();
                st.close();
            }
        }
    }

    public boolean shouldIndex(String fieldName) {
        if (this.getFieldDefinition(fieldName).getIntegerType() == 8 || this.getFieldDefinition(fieldName).getIntegerType() == 18) {
            return this.should_text_Index(fieldName);
        }
        return true;
    }

    public boolean should_text_Index(String fieldName) {
        return false;
    }

    public boolean isIndexOk(String fieldName) {
        Boolean b = this.indexes.get(this.getFieldDBIndexName(fieldName).toLowerCase());
        if (b != null) {
            return this.getFieldDefinition(fieldName).isUnique() == (b == false);
        }
        return false;
    }

    public boolean hasForeignKey(String fieldName) {
        return this.foreignKeys.get(this.getFieldDBIndexName(fieldName).toLowerCase()) != null;
    }

    public boolean isIndexOk(String[] fieldNames) {
        Boolean b = this.indexes.get(StringUtils.concatAsString(fieldNames).toLowerCase());
        if (b != null) {
            return this.getDataDefinition().hasMultiUniqueKey(fieldNames);
        }
        return false;
    }

    public void manageIndexes(String fieldName, SQLDBConnection dbc) throws SQLException {
        String brief = this.getDataDefinition().getName() + "#" + fieldName + " (" + this.getFieldDefinition(fieldName).getDescription() + ")";
        if (this.getDatabase().usesHibernateIndexes()) {
            this.dropIndex(fieldName, dbc, "RESIDUAL MAKUMBA INDEX DROPPED on " + brief);
            return;
        }
        if (!this.isIndexOk(fieldName)) {
            Statement st;
            this.dropIndex(fieldName, dbc, "INDEX DROPPED on " + brief);
            boolean createNormalEvenIfUnique = false;
            if (this.getFieldDefinition(fieldName).isUnique()) {
                try {
                    st = dbc.createStatement();
                    st.executeUpdate(this.indexCreateUniqueSyntax(fieldName));
                    Logger.getLogger("org.makumba.db.init.tablechecking").info("UNIQUE INDEX ADDED on " + brief);
                    st.close();
                    this.indexCreated(dbc);
                }
                catch (SQLException e) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").warning("Problem adding UNIQUE INDEX on " + brief + ": " + e.getMessage() + " [ErrorCode: " + e.getErrorCode() + ", SQLstate:" + e.getSQLState() + "]");
                    createNormalEvenIfUnique = true;
                }
            }
            if (createNormalEvenIfUnique || !this.getFieldDefinition(fieldName).isUnique()) {
                try {
                    st = dbc.createStatement();
                    st.executeUpdate(this.indexCreateSyntax(fieldName));
                    Logger.getLogger("org.makumba.db.init.tablechecking").info("INDEX ADDED on " + brief);
                    st.close();
                }
                catch (SQLException e) {
                    Logger.getLogger("org.makumba.db.init.tablechecking").warning("Problem adding INDEX on " + brief + ": " + e.getMessage() + " [ErrorCode: " + e.getErrorCode() + ", SQLstate:" + e.getSQLState() + "]");
                }
            }
        }
        if (Database.supportsForeignKeys()) {
            this.manageForeignKeys(fieldName, dbc, brief);
        }
    }

    public void manageForeignKeys(String fieldName, SQLDBConnection dbc, String brief) throws DBError {
        String type = this.getFieldDefinition(fieldName).getType();
        if ((type.equals("ptr") || type.equals("ptrOne") || type.equals("ptrRel")) && !this.hasForeignKey(fieldName)) {
            try {
                Statement st = dbc.createStatement();
                String fkTableName = this.getFieldDefinition(fieldName).getPointedType().getName();
                String fkFieldName = this.getFieldDefinition(fieldName).getPointedType().getIndexPointerFieldName();
                if (type.equals("ptrOne")) {
                    fkTableName = this.getFieldDefinition(fieldName).getSubtable().getName();
                    fkFieldName = this.getFieldDefinition(fieldName).getSubtable().getIndexPointerFieldName();
                }
                st.executeUpdate(this.foreignKeyCreateSyntax(fieldName, fkTableName, fkFieldName));
                Logger.getLogger("org.makumba.db.init.tablechecking").info("FOREIGN KEY ADDED on " + brief);
                st.close();
                this.indexCreated(dbc);
            }
            catch (SQLException e) {
                Logger.getLogger("org.makumba.db.init.tablechecking").warning("Problem adding FOREIGN KEY on " + brief + ": " + e.getMessage() + " [ErrorCode: " + e.getErrorCode() + ", SQLstate:" + e.getSQLState() + "]");
                throw new DBError("Error adding foreign key for " + brief + ": " + e.getMessage());
            }
        }
    }

    private void dropIndex(String fieldName, SQLDBConnection dbc, String message) {
        String syntax = this.indexDropSyntax(fieldName);
        try {
            Statement st = dbc.createStatement();
            st.executeUpdate(syntax);
            Logger.getLogger("org.makumba.db.init.tablechecking").info(message);
            st.close();
        }
        catch (SQLException e) {
            this.treatIndexException(e, syntax, dbc);
        }
    }

    public String indexCreateSyntax(String fieldName) {
        return "CREATE INDEX " + this.getFieldDBIndexName(fieldName) + " ON " + this.getDBName() + " (" + this.getFieldDBName(fieldName) + ")";
    }

    public String indexCreateUniqueSyntax(String fieldName) {
        return "CREATE UNIQUE INDEX " + this.getFieldDBIndexName(fieldName) + " ON " + this.getDBName() + " (" + this.getFieldDBName(fieldName) + ")";
    }

    public String foreignKeyCreateSyntax(String fieldName, String fkTableName, String fkFieldName) {
        return "ALTER TABLE " + this.getDBName() + " ADD FOREIGN KEY " + this.shortIndexName(((TableManager)this.getDatabase().getTable(fkTableName)).getDBName(), fieldName) + " (" + this.getFieldDBName(fieldName) + ") REFERENCES " + ((TableManager)this.getDatabase().getTable(fkTableName)).getDBName() + " (" + ((TableManager)this.getDatabase().getTable(fkTableName)).getFieldDBName(fkFieldName) + ")";
    }

    private String shortIndexName(String tableName, String fieldName) {
        String standardIndex = tableName + "__" + fieldName;
        if (standardIndex.length() + "__ibfk_XX".length() > 64) {
            String shortIndex = "";
            StringTokenizer st = new StringTokenizer(tableName, "_");
            while (st.hasMoreTokens()) {
                shortIndex = shortIndex + st.nextToken().substring(0, 1);
                if (!st.hasMoreTokens()) continue;
                shortIndex = shortIndex + "_";
            }
            shortIndex = shortIndex + "__" + fieldName;
            return shortIndex;
        }
        return standardIndex;
    }

    public String indexCreateUniqueSyntax(String[] fieldNames) {
        Object[] dbs = new String[fieldNames.length];
        for (int i = 0; i < dbs.length; ++i) {
            dbs[i] = this.getFieldDBName(fieldNames[i]);
        }
        String dbFieldNames = StringUtils.toString(dbs, false);
        return "CREATE UNIQUE INDEX " + StringUtils.concatAsString(fieldNames) + " ON " + this.getDBName() + " (" + dbFieldNames + ")";
    }

    public String indexDropSyntax(String fieldName) {
        return "DROP INDEX " + this.getFieldDBIndexName(fieldName) + " ON " + this.getDBName();
    }

    public void setValue(String fieldName, Dictionary<String, Object> d, ResultSet rs, int i) throws SQLException {
        Object o = this.getValue("", rs, i);
        if (o != null) {
            d.put(fieldName, o);
        } else {
            d.remove(fieldName);
        }
    }

    public void setValue(String fieldName, Object[] data, ResultSet rs, int i) throws SQLException {
        data[i] = this.getValue("", rs, i);
    }

    protected void checkCopy(String fieldName, String s) {
        if (!this.admin) {
            throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot insert an " + s + " field unless the type " + this.getDataDefinition().getName() + " has administration approval in the database connection file");
        }
    }

    public boolean checkDuplicate(String fieldName, DBConnection dbc, Dictionary<String, Object> data) {
        if (!this.getFieldDefinition(fieldName).isUnique()) {
            return false;
        }
        Object val = data.get(fieldName);
        SQLDBConnection sqlDbc = (SQLDBConnection)dbc;
        PreparedStatement ps = val == null ? sqlDbc.getPreparedStatement(this.checkNullDuplicate.get(fieldName)) : sqlDbc.getPreparedStatement(this.checkDuplicate.get(fieldName));
        try {
            if (val != null) {
                this.setUpdateArgument(fieldName, ps, 1, val);
            }
            boolean bl = ps.executeQuery().next();
            return bl;
        }
        catch (SQLException se) {
            Database.logException(se, sqlDbc);
            throw new DBError(se, this.checkDuplicate.get(fieldName));
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }

    public boolean checkDuplicate(String[] fields, Object[] values, DBConnection dbc) {
        SQLDBConnection sqlDbc = (SQLDBConnection)dbc;
        String query = "SELECT 1 FROM " + this.getDBName() + " WHERE ";
        for (int j = 0; j < fields.length; ++j) {
            query = query + this.getFieldDBName(fields[j]) + "=?";
            if (j + 1 >= fields.length) continue;
            query = query + " AND ";
        }
        PreparedStatement ps = sqlDbc.getPreparedStatement(query);
        try {
            int i;
            for (i = 0; i < values.length; ++i) {
                if (values[i] != null) {
                    this.setUpdateArgument(fields[i], ps, i + 1, values[i]);
                    continue;
                }
                this.setNullArgument(fields[i], ps, i + 1);
            }
            i = ps.executeQuery().next() ? 1 : 0;
            return i != 0;
        }
        catch (SQLException se) {
            Database.logException(se, sqlDbc);
            throw new DBError(se, StringUtils.toString(fields));
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }

    public boolean findMultiFieldMultiTableDuplicates(Pointer pointer, DataDefinition.MultipleUniqueKeyDefinition definition, Object[] values, SQLDBConnection dbc) {
        Object[] fields = definition.getFields();
        String from = this.getDBName();
        String where = "";
        String projection = this.dd.getName().replace('.', '_');
        from = from + " " + projection;
        Vector<String> alreadyAdded = new Vector<String>();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].indexOf(".") == -1) continue;
            String subField = fields[i].substring(0, fields[i].indexOf("."));
            String fieldName = fields[i].substring(fields[i].indexOf(".") + 1);
            DataDefinition pointedType = this.dd.getFieldDefinition(subField).getPointedType();
            TableManager otherTable = (TableManager)this.getDatabase().getTable(pointedType);
            String otherProjection = pointedType.getName().replace('.', '_');
            if (!alreadyAdded.contains(subField)) {
                from = from + ", " + otherTable.getDBName() + " " + otherProjection;
                where = where + projection + "." + this.getFieldDBName(subField) + "=" + otherProjection + "." + otherTable.getFieldDBName(pointedType.getIndexPointerFieldName()) + " AND ";
                alreadyAdded.add(subField);
            }
            where = where + otherProjection + "." + otherTable.getFieldDBName(fieldName) + "=?";
            if (i + 1 >= fields.length) continue;
            where = where + " AND ";
        }
        if (pointer != null) {
            where = where + " AND " + projection + "." + this.getFieldDBName(this.dd.getIndexPointerFieldName()) + "<>" + pointer.getUid();
        }
        String query = "SELECT 1 FROM " + from + " WHERE " + where;
        PreparedStatement ps = dbc.getPreparedStatement(query);
        try {
            int i;
            for (i = 0; i < fields.length; ++i) {
                int n = i + 1;
                if (((String)fields[i]).indexOf(".") != -1) {
                    String subField = ((String)fields[i]).substring(0, ((String)fields[i]).indexOf("."));
                    String fieldName = ((String)fields[i]).substring(((String)fields[i]).indexOf(".") + 1);
                    DataDefinition pointedType = this.dd.getFieldDefinition(subField).getPointedType();
                    TableManager otherTable = (TableManager)this.getDatabase().getTable(pointedType);
                    if (values[i] != null) {
                        otherTable.setUpdateArgument(fieldName, ps, n, values[i]);
                        continue;
                    }
                    otherTable.setNullArgument(fieldName, ps, n);
                    continue;
                }
                if (values[i] != null) {
                    this.setUpdateArgument((String)fields[i], ps, n, values[i]);
                    continue;
                }
                this.setNullArgument((String)fields[i], ps, n);
            }
            i = ps.executeQuery().next() ? 1 : 0;
            return i != 0;
        }
        catch (SQLException se) {
            Database.logException(se, dbc);
            throw new DBError(se, StringUtils.toString(fields));
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }

    protected boolean unmodified(String fieldName, int type, int size, Vector<Hashtable<String, Object>> columns, int index) throws SQLException {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 6: 
            case 7: {
                return this.unmodified_char(fieldName, type, size, columns, index);
            }
            case 3: {
                return this.unmodified_primaryKey(fieldName, type, size, columns, index);
            }
        }
        return this.base_unmodified(fieldName, type, size, columns, index);
    }

    protected boolean base_unmodified(String fieldName, int type, int size, Vector<Hashtable<String, Object>> columns, int index) throws SQLException {
        return type == this.getSQLType(fieldName);
    }

    private boolean unmodified_primaryKey(String fieldName, int type, int size, Vector<Hashtable<String, Object>> columns, int index) throws SQLException {
        if (!this.base_unmodified(fieldName, type, size, columns, index)) {
            return false;
        }
        if (!this.getSQLDatabase().isAutoIncrement() && !this.getDatabase().usesHibernateIndexes()) {
            return true;
        }
        boolean unmod = this.unmodifiedAutoIncrement(columns.elementAt(index - 1));
        this.autoIncrementAlter = !unmod;
        return unmod;
    }

    private boolean unmodifiedAutoIncrement(Hashtable<String, Object> column) {
        return "NO".equals(column.get("IS_NULLABLE"));
    }

    private String in_primaryKeyCreate(String fieldName, Database d) {
        if (this.getSQLDatabase().isAutoIncrement() || this.getDatabase().usesHibernateIndexes()) {
            return this.base_inCreate(fieldName, d) + " " + this.getCreateAutoIncrementSyntax();
        }
        return this.base_inCreate(fieldName, d);
    }

    protected boolean unmodified_char(String fieldName, int type, int size, Vector<Hashtable<String, Object>> columns, int index) throws SQLException {
        return (this.base_unmodified(fieldName, type, size, columns, index) || type == 1) && this.check_char_Width(fieldName, size);
    }

    protected boolean unmodified_wrapper(String fieldName, int type, int size, Vector<Hashtable<String, Object>> v, int index) throws SQLException {
        return this.base_unmodified(fieldName, type, size, v, index);
    }

    protected boolean check_char_Width(String fieldName, ResultSetMetaData rsm, int index) throws SQLException {
        return rsm.getColumnDisplaySize(index) >= this.getFieldDefinition(fieldName).getWidth();
    }

    protected boolean check_char_Width(String fieldName, int width) throws SQLException {
        return width >= this.getFieldDefinition(fieldName).getWidth();
    }

    protected void resetPrimaryKey() {
        this.primaryKeyCurrentIndex = this.getSQLDatabase().getMinPointerValue();
    }

    void nxt(String fieldName, Dictionary<String, Object> d) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 10: {
                d.put(fieldName, d.get(this.dd.getLastModificationDateFieldName()));
                break;
            }
            case 11: {
                d.put(fieldName, new Timestamp(new Date().getTime()));
            }
        }
    }

    public SQLPointer nxt_ptrIndex(String fieldName, Dictionary<String, Object> d) {
        SQLPointer i = new SQLPointer(this.dd.getName(), this.nextId_ptrIndex());
        d.put(fieldName, i);
        return i;
    }

    protected synchronized long nextId_ptrIndex() {
        return ++this.primaryKeyCurrentIndex;
    }

    @Override
    public void checkInsert(Dictionary<String, Object> fieldsToCheck, Dictionary<String, Object> fieldsToIgnore, Dictionary<String, Object> allFields) {
        this.dd.checkFieldNames(fieldsToCheck);
        for (String string : this.dd.getFieldNames()) {
            boolean isPtrIndex;
            Object o;
            String name = string;
            if (fieldsToIgnore.get(name) != null || (o = fieldsToCheck.get(name)) == null) continue;
            boolean isDateCreate = this.getFieldDefinition(name).getIntegerType() == 10;
            boolean isDataModify = this.getFieldDefinition(name).getIntegerType() == 11;
            boolean bl = isPtrIndex = this.getFieldDefinition(name).getIntegerType() == 3;
            if (isDateCreate || isDataModify || isPtrIndex) {
                this.checkCopyRights(name);
            } else {
                this.getFieldDefinition(name).checkInsert(fieldsToCheck);
            }
            fieldsToCheck.put(name, this.getFieldDefinition(name).checkValue(o));
        }
        this.checkMultiFieldMultiTableUniqueness(null, allFields);
    }

    @Override
    public void checkUpdate(Pointer pointer, Dictionary<String, Object> allFields) {
        this.checkMultiFieldMultiTableUniqueness(pointer, allFields);
    }

    private void checkCopyRights(String fieldName) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 10: {
                this.checkCopy(fieldName, "creation date");
                break;
            }
            case 11: {
                this.checkCopy(fieldName, "modification date");
                break;
            }
            case 3: {
                this.checkCopy(fieldName, "index");
            }
        }
    }

    public Object check_timeStamp_ValueImpl(String fieldName, Object value) {
        Object o = this.getFieldDefinition(fieldName).checkValue(value);
        if (o instanceof Date && !(o instanceof Timestamp)) {
            o = new Timestamp(((Date)o).getTime());
        }
        return o;
    }

    private void checkMultiFieldMultiTableUniqueness(Pointer pointer, Dictionary<String, Object> fullData) throws CompositeValidationException {
        DBConnectionWrapper dbcw = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
        SQLDBConnection dbc = (SQLDBConnection)dbcw.getWrapped();
        try {
            DataDefinition.MultipleUniqueKeyDefinition[] multiFieldUniqueKeys = this.getDataDefinition().getMultiFieldUniqueKeys();
            CompositeValidationException notUnique = new CompositeValidationException();
            for (DataDefinition.MultipleUniqueKeyDefinition key : multiFieldUniqueKeys) {
                String[] fields = key.getFields();
                Object[] values = new Object[fields.length];
                if (!key.isKeyOverSubfield()) continue;
                for (int j = 0; j < fields.length; ++j) {
                    values[j] = fullData.get(fields[j]);
                }
                if (!this.findMultiFieldMultiTableDuplicates(pointer, key, values, dbc)) continue;
                notUnique.addException(new NotUniqueException(key.getFields()[0], key.getErrorMessage(values)));
            }
            notUnique.throwCheck();
        }
        catch (Exception e) {
            if (e instanceof CompositeValidationException) {
                throw (CompositeValidationException)e;
            }
            throw new RuntimeWrappedException(e);
        }
        finally {
            dbcw.close();
        }
    }

    protected void indexCreated(SQLDBConnection dbc) {
    }

    protected String createDbSpecific(String command) {
        return command;
    }

    protected String getTableMissingStateName(SQLDBConnection dbc) {
        return "tableMissing";
    }

    protected String getQueryAutoIncrementSyntax() {
        return null;
    }

    protected String getCreateAutoIncrementSyntax() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CatalogChecker
    implements CheckingStrategy {
        Vector<Hashtable<String, Object>> columns;
        Hashtable<String, Object> column;
        int i = 0;

        CatalogChecker(Hashtable<String, Vector<Hashtable<String, Object>>> catalog) throws SQLException {
            this.columns = catalog.get(TableManager.this.tbname);
            if (this.columns == null) {
                this.columns = catalog.get(TableManager.this.tbname.toLowerCase());
                if (this.columns == null) {
                    this.columns = catalog.get(TableManager.this.tbname.toUpperCase());
                    if (this.columns != null) {
                        TableManager.this.tbname = TableManager.this.tbname.toUpperCase();
                    }
                } else {
                    TableManager.this.tbname = TableManager.this.tbname.toLowerCase();
                }
            }
        }

        @Override
        public boolean shouldCreate() {
            return this.columns == null;
        }

        @Override
        public boolean hasMoreColumns() throws SQLException {
            if (this.i < this.columns.size()) {
                this.column = this.columns.elementAt(this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        @Override
        public String columnName() throws SQLException {
            return (String)this.column.get("COLUMN_NAME");
        }

        @Override
        public int columnType() throws SQLException {
            return (Integer)this.column.get("DATA_TYPE");
        }

        public int columnSize() throws SQLException {
            return (Integer)this.column.get("COLUMN_SIZE");
        }

        @Override
        public String columnTypeName() throws SQLException {
            return (String)this.column.get("TYPE_NAME");
        }

        @Override
        public boolean checkColumn(String fieldName) throws SQLException {
            return TableManager.this.unmodified(fieldName, this.columnType(), this.columnSize(), this.columns, this.i);
        }
    }

    protected static interface CheckingStrategy {
        public boolean hasMoreColumns() throws SQLException;

        public String columnName() throws SQLException;

        public int columnType() throws SQLException;

        public String columnTypeName() throws SQLException;

        public boolean checkColumn(String var1) throws SQLException;

        public boolean shouldCreate() throws SQLException;
    }
}

