/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Query;
import org.makumba.devel.DataServlet;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.SourceViewControllerHandler;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.makumba.RecordParser;

public class DataTypeListerServlet
extends DataServlet {
    protected static final long serialVersionUID = 1L;

    public DataTypeListerServlet() {
        this.toolLocation = Configuration.getDataListerLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
        PrintWriter writer = response.getWriter();
        DevelUtils.writePageBegin(writer);
        DevelUtils.writeStylesAndScripts(writer, this.contextPath);
        DevelUtils.writeTitleAndHeaderEnd(writer, "Data Lister");
        DataDefinition dd = null;
        int limit = 100;
        try {
            limit = Integer.parseInt(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            limit = 100;
        }
        try {
            dd = DataDefinitionProvider.getInstance().getDataDefinition(this.virtualPath);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (dd == null) {
            this.doDirectoryListing(request, response, writer);
        } else {
            TransactionProvider tp = TransactionProvider.getInstance();
            Transaction t = tp.getConnectionTo(tp.getDefaultDataSourceName());
            try {
                String e;
                FieldDefinition fdAll;
                int i;
                String otherField;
                String dataBaseName = t.getName();
                this.writePageContentHeader(this.type, writer, dataBaseName, 10);
                Vector<String> fields = dd.getFieldNames();
                String titleField = request.getParameter("titleField");
                if (titleField == null || titleField.trim().equals("")) {
                    titleField = dd.getTitleFieldName();
                }
                if ((otherField = request.getParameter("otherField")) == null || otherField.trim().equals("")) {
                    otherField = dd.getTitleFieldName();
                }
                writer.println("<table border=\"0\" cellpadding=\"5\">");
                writer.println("  <tr class=\"even\" valign=\"bottom\">");
                writer.println("    <th align=\"center\"><b>#</b></th>");
                writer.println("    <form method=\"get\">");
                writer.println("    <input type=\"hidden\" name=\"type\" value=\"" + this.type + "\">");
                writer.println("    <th>");
                writer.println("      <select size=\"1\" name=\"titleField\">");
                for (i = 3; i < fields.size(); ++i) {
                    fdAll = dd.getFieldDefinition(i);
                    e = fields.elementAt(i);
                    writer.print("          <option value=\"" + e + "\" ");
                    if (e.equals(titleField)) {
                        writer.print("selected");
                    }
                    writer.println(">" + fdAll.getName() + " (" + fdAll.getType() + ")</option>");
                }
                writer.println("        </select>");
                writer.println("    </th>");
                writer.println("    <th>");
                writer.println("      <select size=\"1\" name=\"otherField\">");
                for (i = 3; i < fields.size(); ++i) {
                    fdAll = dd.getFieldDefinition(i);
                    e = fields.elementAt(i);
                    writer.print("          <option value=\"" + e + "\" ");
                    if (e.equals(otherField)) {
                        writer.print("selected");
                    }
                    writer.println(">" + fdAll.getName() + " (" + fdAll.getType() + ")</option>");
                }
                writer.println("      </select>");
                writer.println("    </th>");
                writer.println("    <th>Limit</th>");
                writer.println("    <td>");
                writer.println("      <input name=\"limit\" type=\"text\" size=\"5\" value=\"" + limit + "\">");
                writer.println("      <input TYPE=\"submit\" value=\"View\">");
                writer.println("    </td>");
                writer.println("    </form>");
                writer.println("  </tr>");
                String what = "";
                for (int i2 = 3; i2 < fields.size(); ++i2) {
                    if (i2 > 3) {
                        what = what + ", ";
                    }
                    what = what + "obj." + fields.elementAt(i2) + " AS " + fields.elementAt(i2);
                }
                String query = "SELECT obj as ptr, obj." + titleField + " as title, obj." + otherField + " as other FROM " + this.type + " obj";
                Vector<Dictionary<String, Object>> results = t.executeQuery(query, null, 0, limit);
                for (int i3 = 0; i3 < results.size(); ++i3) {
                    writer.println("<tr class=\"" + (i3 % 2 == 0 ? "even" : "odd") + "\">");
                    writer.println("<td>" + (i3 + 1) + "</td>");
                    writer.println("<td>");
                    writer.println("<a href=\"" + this.contextPath + Configuration.getDataViewerLocation() + "/" + this.type + "?ptr=" + ((Pointer)results.elementAt(i3).get("ptr")).toExternalForm() + "\">");
                    Dictionary<String, Object> dictionary = results.elementAt(i3);
                    Object value = dictionary.get("title");
                    if (value == null || value.equals("")) {
                        value = "<i>[none]</i>";
                    } else if (value instanceof Pointer) {
                        Pointer pointer = (Pointer)value;
                        value = DevelUtils.writePointerValueLink(this.contextPath, pointer);
                    }
                    writer.println(value);
                    writer.println("</a>");
                    writer.println("</td>");
                    writer.println("<td>");
                    Object otherValue = dictionary.get("other");
                    if (otherValue == null || otherValue.equals("")) {
                        otherValue = "<i>[none]</i>";
                    } else if (otherValue instanceof Pointer) {
                        Pointer pointer = (Pointer)otherValue;
                        otherValue = DevelUtils.writePointerValueLink(this.contextPath, pointer);
                    }
                    writer.println(otherValue);
                    writer.println("</td>");
                    writer.println("</tr>");
                }
                writer.println("</table>");
                Query oqlQuery = ((DBConnection)t).getQuery(query);
                if (oqlQuery instanceof org.makumba.db.makumba.sql.Query) {
                    writer.println("<hr>");
                    org.makumba.db.makumba.sql.Query sqlQuery = (org.makumba.db.makumba.sql.Query)((DBConnection)t).getQuery(query);
                    writer.println("SQL query: " + sqlQuery.getCommand() + ";<br>");
                }
            }
            finally {
                t.close();
            }
        }
        DevelUtils.writePageEnd(writer);
    }

    private void doDirectoryListing(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) throws IOException, FileNotFoundException {
        String servletPath = request.getContextPath() + Configuration.getDataListerLocation();
        String requestURI = request.getRequestURI();
        String pathInfo = requestURI.substring(requestURI.indexOf(servletPath) + servletPath.length());
        if (DevelUtils.redirected(request, response, pathInfo)) {
            return;
        }
        URL u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "mdd");
        if (u == null) {
            u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "idd");
        }
        if (u == null) {
            throw new FileNotFoundException(this.virtualPath);
        }
        String realPath = u.getFile();
        File dir = new File(realPath);
        String relativeDirectory = dir.getName();
        if (dir.getAbsolutePath().indexOf("dataDefinitions/") != -1) {
            relativeDirectory = dir.getAbsolutePath().substring(dir.getAbsolutePath().indexOf("dataDefinitions"));
        }
        this.writePageContentHeader(this.type, writer, TransactionProvider.getInstance().getDefaultDataSourceName(), 10);
        writer.print("<pre style=\"margin-top:0\">");
        if (!relativeDirectory.equals("dataDefinitions")) {
            writer.println("<b><a href=\"../\">../</a></b> (up one level)");
        }
        SourceViewControllerHandler.processDirectory(writer, dir, "dd");
        Object[] list = dir.list();
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            Object s = list[i];
            if (((String)s).indexOf(".") == -1 || !((String)s).endsWith("dd")) continue;
            String ddname = pathInfo + (String)s;
            ddname = ddname.substring(1, ddname.lastIndexOf(".")).replace('/', '.');
            String addr = this.contextPath + Configuration.getDataListerLocation() + "/" + ddname;
            writer.println("<a href=\"" + addr + "\">" + (String)s + "</a>");
        }
    }
}

