/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.makumba.AttributeNotFoundException;
import org.makumba.ConfigurationError;
import org.makumba.DBError;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.ForeignKeyError;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.LogicInvocationError;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.NoSuchLabelException;
import org.makumba.OQLParseError;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.UnauthorizedException;
import org.makumba.ValidationDefinitionParseError;
import org.makumba.analyser.AnalysableElement;
import org.makumba.analyser.ELData;
import org.makumba.analyser.ElementData;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.devel.errorViewer;
import org.makumba.list.tags.MakumbaJspException;
import org.makumba.providers.Configuration;

public class ErrorFormatter {
    static Object[][] errors = new Object[][]{{OQLParseError.class, "query"}, {DataDefinitionNotFoundError.class, "data definition not found"}, {DataDefinitionParseError.class, "data definition parse"}, {ValidationDefinitionParseError.class, "validation definition parse"}, {DBError.class, "database"}, {ConfigurationError.class, "configuration"}, {ProgrammerError.class, "programmer"}, {MakumbaJspException.class, "page"}, {AttributeNotFoundException.class, "attribute not set"}, {UnauthorizedException.class, "authorization"}, {InvalidValueException.class, "invalid value"}, {InvalidFieldTypeException.class, "invalid field type"}, {NoSuchFieldException.class, "no such field"}, {NoSuchLabelException.class, "no such label"}, {LogicException.class, "business logic"}};
    static final Class<?>[] knownJSPruntimeErrors = new Class[]{ArrayIndexOutOfBoundsException.class, NumberFormatException.class, ClassCastException.class};
    protected ServletContext servletContext;
    private String title = "";
    protected boolean printeHeaderFooter;
    public static String[] jspReservedWords = new String[]{"application", "config", "out", "page", "request", "response", "pageContext"};
    public static ArrayList<String> jspReservedWordList = new ArrayList<String>(Arrays.asList(jspReservedWords));

    public String getTitle() {
        return this.title;
    }

    public ErrorFormatter() {
    }

    public ErrorFormatter(HttpServletRequest req, ServletContext servletContext, PrintWriter wr, boolean printHeaderFooter) throws IOException, ServletException {
        this.printeHeaderFooter = printHeaderFooter;
        this.servletContext = servletContext;
        Throwable t = (Throwable)req.getAttribute("javax.servlet.jsp.jspException");
        Throwable t1 = null;
        Throwable original = t;
        if (t.getClass().getSuperclass().isAssignableFrom(ServletException.class) && ((ServletException)t).getRootCause() != null && ((ServletException)t).getRootCause().getClass().isAssignableFrom(ServletException.class) && t.getMessage().startsWith("Exception in JSP:")) {
            t = ((ServletException)((ServletException)t).getRootCause()).getRootCause();
        }
        while (true) {
            if (t instanceof LogicException) {
                t1 = ((LogicException)t).getReason();
            } else if (t instanceof MakumbaError && !(t instanceof OQLParseError)) {
                t1 = ((MakumbaError)t).getCause();
            } else if (t instanceof LogicInvocationError) {
                t1 = ((LogicInvocationError)t).getReason();
            } else if (t instanceof RuntimeWrappedException) {
                t1 = ((RuntimeWrappedException)t).getCause();
            } else if (t instanceof ServletException && ((ServletException)t).getRootCause() instanceof NullPointerException) {
                ServletException e = (ServletException)t;
                t1 = e.getRootCause();
                t1.setStackTrace(e.getRootCause().getStackTrace());
            } else {
                if (!(t instanceof ServletException)) break;
                t1 = ((ServletException)t).getRootCause();
            }
            if (t1 == null) break;
            t = t1;
        }
        this.logError(t, req);
        if (t.getClass().getName().startsWith(TomcatJsp.getJspCompilerPackage())) {
            boolean jspSpecificError = this.treatJspException(original, t, wr, req, this.servletContext, printHeaderFooter, this.title);
            if (!jspSpecificError) {
                if (this.isRuntimeJspErrors((ServletException)t)) {
                    this.treatJspRuntimeException(original, (ServletException)t, wr, req, this.servletContext, printHeaderFooter);
                    return;
                }
                Throwable rootCause = ((ServletException)t).getRootCause();
                if (rootCause != null && (t = rootCause) != null && original.getMessage() != null && !original.getMessage().equals(t.getMessage())) {
                    try {
                        String message = t.getMessage() + "\n\n" + original.getMessage();
                        t1 = (Throwable)t.getClass().getConstructor(String.class).newInstance(message);
                        t1.setStackTrace(t.getStackTrace());
                        t = t1;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                this.title = "JSP Compilation error";
                for (Object[] element : errors) {
                    if (!((Class)element[0]).isInstance(t) && (t1 == null || !((Class)element[0]).isInstance(t = t1))) continue;
                    this.title = "Makumba " + element[1] + " error";
                }
                this.knownError(this.title, t, original, req, wr);
            }
            return;
        }
        if (original.getClass().getName().startsWith(TomcatJsp.getJspCompilerPackage())) {
            if (t != null && original.getMessage() != null && !original.getMessage().equals(t.getMessage())) {
                try {
                    String message = t.getMessage() + "\n\n" + original.getMessage();
                    t1 = (Throwable)t.getClass().getConstructor(String.class).newInstance(message);
                    t1.setStackTrace(t.getStackTrace());
                }
                catch (Throwable e) {
                    t1 = new Throwable(t.getMessage() + "\n\n" + original.getMessage());
                    t1.setStackTrace(t.getStackTrace());
                }
                t = t1;
            }
            if (this.isRuntimeJspErrors((ServletException)original)) {
                this.treatJspRuntimeException(original, t, wr, req, this.servletContext, printHeaderFooter);
                return;
            }
        } else if (this.isRuntimeJspErrors(t)) {
            this.treatJspRuntimeException(original, t, wr, req, this.servletContext, printHeaderFooter);
            return;
        }
        for (Object[] element : errors) {
            if (!((Class)element[0]).isInstance(t) && (t1 == null || !((Class)element[0]).isInstance(t = t1))) continue;
            this.title = "Makumba " + element[1] + " error";
            this.knownError(this.title, t, original, req, wr);
            return;
        }
        this.unknownError(original, t, wr, req);
    }

    private boolean isRuntimeJspErrors(Throwable e) {
        block3: {
            block2: {
                if (!(e instanceof ServletException)) break block2;
                ServletException t1 = (ServletException)e;
                if (t1.getRootCause() == null) break block3;
                for (Class<?> element : knownJSPruntimeErrors) {
                    if (!t1.getRootCause().getClass().isAssignableFrom(element)) continue;
                    return true;
                }
                break block3;
            }
            for (Class<?> element : knownJSPruntimeErrors) {
                if (!e.getClass().isAssignableFrom(element)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(Throwable t, HttpServletRequest req) {
        if (Configuration.getErrorLog()) {
            try {
                DbConnectionProvider dbc = (DbConnectionProvider)req.getAttribute("org.makumba.providerAttribute");
                Transaction tr = dbc.getTransactionProvider().getConnectionTo(dbc.getTransactionProvider().getDefaultDataSourceName());
                try {
                    Hashtable<String, Object> d = new Hashtable<String, Object>();
                    if (t != null && t.getMessage() != null) {
                        ((Dictionary)d).put("exception", t.getMessage());
                    }
                    ((Dictionary)d).put("executionDate", new Date());
                    ((Dictionary)d).put("url", req.getRequestURL().toString());
                    if (req.getAttribute("makumba.parameters") != null) {
                        ((Dictionary)d).put("makumbaParameters", req.getAttribute("makumba.parameters").toString());
                    }
                    if (req.getAttribute("makumba.attributes") != null) {
                        ((Dictionary)d).put("makumbaAttributes", req.getAttribute("makumba.attributes").toString());
                    }
                    if (req.getAttribute("makumba.controller") != null) {
                        ((Dictionary)d).put("makumbaController", req.getAttribute("makumba.controller").toString());
                    }
                    tr.insert("org.makumba.controller.ErrorLog", d);
                }
                finally {
                    tr.close();
                }
            }
            catch (Throwable t1) {
                Logger.getLogger("org.makumba.errorFormatter").log(Level.SEVERE, "Could not log exception to the db, exception to log was", t);
                Logger.getLogger("org.makumba.errorFormatter").log(Level.SEVERE, "Could not log exception to the db, database logging exception was", t1);
            }
        }
    }

    void knownError(String title, Throwable t, Throwable original, HttpServletRequest req, PrintWriter wr) {
        String trcOrig = this.trace(t);
        String trc = this.shortTrace(trcOrig);
        String body = t.getMessage();
        String hiddenBody = null;
        if ((t instanceof LogicException && ((LogicException)t).isControllerOriginated() || t instanceof ForeignKeyError) && this.findNonMakumbaRootCause(t) != -1) {
            int i = this.findNonMakumbaRootCause(t);
            body = "Exception occured at " + t.getStackTrace()[i].getClassName() + "." + t.getStackTrace()[i].getMethodName() + ":" + t.getStackTrace()[i].getLineNumber() + "\n\n" + body;
        } else {
            body = this.formatElementData(req) + body;
        }
        if (original instanceof LogicInvocationError || trcOrig.indexOf("at org.makumba.abstr.Logic") != -1) {
            body = body + "\n\n" + trc;
        } else {
            hiddenBody = trc;
        }
        try {
            errorViewer sw = new errorViewer(req, this.servletContext, title, body, hiddenBody, this.printeHeaderFooter);
            sw.parseText(wr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeWrappedException(e);
        }
    }

    private int findNonMakumbaRootCause(Throwable t) {
        boolean foundRootCause = false;
        int i = 0;
        while (!foundRootCause && i < t.getStackTrace().length) {
            if (t.getStackTrace()[i].getClassName().indexOf("org.makumba") == -1) {
                foundRootCause = true;
                continue;
            }
            ++i;
        }
        if (foundRootCause) {
            return i;
        }
        return -1;
    }

    String formatElementData(HttpServletRequest req) {
        String filePath;
        String explanation = new String();
        ElementData data = null;
        data = AnalysableElement.getAnalyzedElementData();
        if (data != null) {
            if (data instanceof TagData) {
                explanation = "During analysis of the following tag (and possibly tags around or inside it):";
            } else if (data instanceof ELData) {
                explanation = "During analysis of the following EL expression (and possibly tags around it):";
            }
        } else {
            data = AnalysableElement.getRunningElementData();
            if (data != null) {
                explanation = "During running of:";
            } else {
                data = AnalysableElement.getCurrentBodyTagData();
                if (data != null) {
                    explanation = "While executing inside this body tag, but most probably *not* due to the tag:";
                }
            }
        }
        if (data == null) {
            String filePath2 = req.getRequestURL().toString();
            try {
                String serverName = req.getLocalName() + ":" + req.getLocalPort() + req.getContextPath();
                if (filePath2.indexOf(serverName) != -1) {
                    filePath2 = filePath2.substring(filePath2.indexOf(serverName) + serverName.length());
                }
            }
            catch (Exception e) {
                filePath2 = req.getRequestURL().toString();
            }
            explanation = "While executing page " + filePath2 + "\n\n";
            return explanation;
        }
        StringBuffer sb = new StringBuffer();
        try {
            JspParseData.tagDataLine(data, sb);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String tagLine = sb.toString();
        try {
            filePath = "/" + data.getSourceSyntaxPoints().getFile().getAbsolutePath().substring(req.getSession().getServletContext().getRealPath("/").length());
        }
        catch (Exception e) {
            filePath = data.getSourceSyntaxPoints().getFile().getAbsolutePath();
        }
        return explanation + filePath + ":" + data.getStartLine() + ":" + data.getStartColumn() + ":" + data.getEndLine() + ":" + data.getEndColumn() + "\n" + tagLine + "\n\n";
    }

    String trace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    String shortTrace(String s) {
        int i = s.indexOf("at org.makumba.controller.Logic");
        if (i != -1) {
            if ((i = (s = s.substring(0, i)).indexOf("at sun.reflect")) != -1) {
                s = s.substring(0, i);
            }
        } else {
            i = s.indexOf("at javax.servlet.http.HttpServlet.service(HttpServlet.java");
            if (i != -1) {
                s = s.substring(0, i);
            } else {
                i = s.indexOf("at org.makumba.controller.http.ControllerFilter.doFilter(ControllerFilter.java");
                if (i != -1) {
                    s = s.substring(0, i);
                } else {
                    Logger.getLogger("org.makumba.devel").severe("servlet or filter call not found in stacktrace");
                }
            }
        }
        return s;
    }

    void unknownError(Throwable original, Throwable t, PrintWriter wr, HttpServletRequest req) throws IOException, ServletException {
        Throwable traced = t;
        this.title = "";
        String body = "";
        if (original instanceof LogicInvocationError) {
            this.title = "Error in business logic code";
        } else if (traced instanceof NullPointerException) {
            this.title = "Null pointer exception";
            body = "Please report to the developers.\n\n";
        } else if (this.trace(traced).indexOf("org.makumba") != -1) {
            this.title = "Internal Makumba error";
            body = "Please report to the developers.\n";
            if (t instanceof ServletException && (traced = ((ServletException)t).getRootCause()) == null) {
                traced = t;
            }
        } else {
            this.title = "Error in JSP Java scriplet or servlet container";
        }
        if (traced instanceof SQLException) {
            this.title = "SQL " + this.title;
            body = "The problem is related to SQL:\n    SQLstate: " + ((SQLException)traced).getSQLState() + "\n" + "  ErrorCode: " + ((SQLException)traced).getErrorCode() + "\n" + "     Message: " + traced.getMessage() + "\n\n" + "Refer to your SQL server's documentation for error explanation.\n" + "Please check the configuration of your webapp and SQL server.\n" + body;
        }
        body = this.formatElementData(req) + body + this.shortTrace(this.trace(traced));
        try {
            errorViewer sw = new errorViewer(req, this.servletContext, this.title, body, this.trace(traced), this.printeHeaderFooter);
            sw.parseText(wr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeWrappedException(e);
        }
    }

    public String getErrorMessage(HttpServletRequest req) {
        Throwable t = (Throwable)req.getAttribute("javax.servlet.jsp.jspException");
        Throwable t1 = null;
        Throwable original = t;
        while (true) {
            if (t instanceof LogicException) {
                t1 = ((LogicException)t).getReason();
            } else if (t instanceof MakumbaError && !(t instanceof OQLParseError)) {
                t1 = ((MakumbaError)t).getCause();
            } else if (t instanceof LogicInvocationError) {
                t1 = ((LogicInvocationError)t).getReason();
            } else if (t instanceof RuntimeWrappedException) {
                t1 = ((RuntimeWrappedException)t).getCause();
            } else {
                if (!(t instanceof ServletException) || !(((ServletException)t).getRootCause() instanceof NullPointerException)) break;
                ServletException e = (ServletException)t;
                t1 = e.getRootCause();
                t1.setStackTrace(e.getRootCause().getStackTrace());
            }
            if (t1 == null) break;
            t = t1;
        }
        this.logError(t, req);
        if (t.getClass().getName().startsWith(TomcatJsp.getJspCompilerPackage())) {
            return "JSP compilation error:\n" + this.formatElementData(req) + t.getMessage();
        }
        for (Object[] element : errors) {
            if (!((Class)element[0]).isInstance(t) && (t1 == null || !((Class)element[0]).isInstance(t = t1))) continue;
            return "Makumba " + element[1] + " error:\n" + this.formatElementData(req) + t.getMessage();
        }
        return this.unknownErrorMessage(original, t, req);
    }

    String unknownErrorMessage(Throwable original, Throwable t, HttpServletRequest req) {
        System.out.println("unknown message:");
        Throwable traced = t;
        this.title = "";
        String body = "";
        if (original instanceof LogicInvocationError) {
            this.title = "Error in business logic code";
        } else if (this.trace(traced).indexOf("org.makumba") != -1) {
            this.title = "Internal Makumba error";
            body = "Please report to the developers.\n\n";
            if (t instanceof ServletException && (traced = ((ServletException)t).getRootCause()) == null) {
                traced = t;
            }
        } else {
            this.title = "Error in JSP Java scriplet or servlet container";
        }
        if (traced instanceof SQLException) {
            this.title = "SQL " + this.title;
            body = "The problem is related to SQL:\n   SQLstate: " + ((SQLException)traced).getSQLState() + "\n" + "  ErrorCode: " + ((SQLException)traced).getErrorCode() + "\n" + "    Message: " + traced.getMessage() + "\n\n" + "Refer to your SQL server's documentation for error explanation.\n" + "Please check the configuration of your webapp and SQL server.\n" + body;
        }
        return this.title + ":\n" + this.formatElementData(req) + body + this.shortTrace(this.trace(traced), 10);
    }

    String shortTrace(String s, int lineNumbers) {
        String[] parts = s.split("\n", lineNumbers + 1);
        String result = "";
        for (int i = 0; i < parts.length && i < lineNumbers; ++i) {
            result = result + parts[i] + "\n";
        }
        String[] allParts = s.split("\n");
        if (allParts.length > lineNumbers + 1) {
            result = result + "-- Rest of stacktrace cut --\n";
        }
        return result;
    }

    boolean treatJspRuntimeException(Throwable original, Throwable t, PrintWriter wr, HttpServletRequest req, ServletContext servletContext, boolean printHeaderFooter) {
        Throwable rootCause = null;
        rootCause = t instanceof ServletException ? ((ServletException)t).getRootCause() : t;
        String title = rootCause.getClass().getSimpleName();
        String message = rootCause.getMessage();
        String body = "A " + rootCause.getClass().getName() + " occured (most likely because of a programming error in the JSP):\n\n" + message;
        if (t != null && original.getStackTrace() != null && !Arrays.equals(original.getStackTrace(), t.getStackTrace())) {
            body = body + "\n\n" + this.trace(rootCause);
        }
        String hiddenBody = this.trace(rootCause);
        try {
            errorViewer sw = new errorViewer(req, servletContext, title, body, hiddenBody, printHeaderFooter);
            sw.parseText(wr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeWrappedException(e);
        }
        return true;
    }

    boolean treatJspException(Throwable original, Throwable t, PrintWriter wr, HttpServletRequest req, ServletContext servletContext, boolean printHeaderFooter, String title) {
        if (t.getMessage() != null && t.getMessage().indexOf("Duplicate local variable") != -1) {
            String message = t.getMessage();
            String[] split = message.split("\n");
            String variableName = null;
            String errorLine = null;
            for (String element : split) {
                if (element.startsWith("An error occurred at line:")) {
                    errorLine = element;
                    continue;
                }
                if (!element.startsWith("Duplicate local variable")) continue;
                variableName = element.substring("Duplicate local variable".length()).trim();
            }
            if (variableName != null && jspReservedWordList.contains(variableName)) {
                String body = errorLine + "\n\n";
                body = body + "'" + variableName + "' is a reserverd keyword in the JSP standard!\n";
                body = body + "Do not use it as name for your Java variables, or as <mak:value expr=\"...\" var=\"" + variableName + "\" /> resp. <mak:value expr=\"...\" printVar=\"" + variableName + "\" />";
                String hiddenBody = t.getMessage();
                title = "Programmer Error - usage of reserved Tomcat keyword";
                try {
                    errorViewer sw = new errorViewer(req, servletContext, title, body, hiddenBody, printHeaderFooter);
                    sw.parseText(wr);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeWrappedException(e);
                }
                return true;
            }
        }
        return false;
    }
}

