/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.ServletObjects;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.GeneratedCodeViewer;
import org.makumba.devel.LineViewer;
import org.makumba.devel.javaViewer;
import org.makumba.devel.jspViewer;
import org.makumba.devel.logicViewer;
import org.makumba.devel.mddViewer;
import org.makumba.providers.Configuration;

public class SourceViewControllerHandler
extends ControllerHandler {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_REPOSITORY_URL = "repositoryURL";
    public static final String PARAM_REPOSITORY_LINK_TEXT = "repositoryLinkText";

    public boolean beforeFilter(ServletRequest request, ServletResponse response, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String requestURI = req.getRequestURI();
        String path = requestURI.replace(req.getContextPath(), "");
        LineViewer sw = null;
        if (path.startsWith(Configuration.getMddViewerLocation())) {
            sw = new mddViewer(req);
        } else if (path.startsWith(Configuration.getJavaViewerLocation())) {
            sw = new javaViewer(req);
        } else if (path.startsWith(Configuration.getLogicDiscoveryViewerLocation())) {
            sw = new logicViewer(req);
        } else if (path.startsWith(Configuration.getCodeGeneratorLocation())) {
            sw = new GeneratedCodeViewer(req);
        } else if (path.endsWith(".jspx") || path.endsWith(".jsps") || path.endsWith(".jspxp")) {
            sw = new jspViewer(req);
        } else {
            return true;
        }
        PrintWriter w = res.getWriter();
        String servletPath = req.getServletPath();
        File dir = sw.getDirectory();
        if (dir == null) {
            res.setContentType("text/html");
            try {
                sw.parseText(w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (DevelUtils.redirected(req, res, servletPath)) {
                return false;
            }
            if (sw instanceof GeneratedCodeViewer && requestURI.endsWith("/")) {
                String location = requestURI.substring((req.getContextPath() + Configuration.getCodeGeneratorLocation()).length() + 1);
                res.sendRedirect(req.getContextPath() + Configuration.getMddViewerLocation() + location);
                return false;
            }
            String relativeDirectory = dir.getName();
            if (dir.getAbsolutePath().indexOf("classes/") != -1) {
                relativeDirectory = dir.getAbsolutePath().substring(dir.getAbsolutePath().indexOf("classes"));
            } else if (dir.getAbsolutePath().indexOf("dataDefinitions/") != -1) {
                relativeDirectory = dir.getAbsolutePath().substring(dir.getAbsolutePath().indexOf("dataDefinitions"));
            }
            res.setContentType("text/html");
            SourceViewControllerHandler.printDirlistingHeader(w, dir.getCanonicalPath(), relativeDirectory, req.getContextPath(), sw instanceof javaViewer ? "javaViewer" : "mddViewer");
            if (!relativeDirectory.equals("classes") && !relativeDirectory.equals("classes/dataDefinitions")) {
                w.println("<b><a href=\"../\">../</a></b> (up one level)");
            }
            if (sw instanceof javaViewer) {
                SourceViewControllerHandler.processDirectory(w, dir, ".java");
                Object[] list = dir.list((FilenameFilter)new SuffixFileFilter(".java"));
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    Object s = list[i];
                    w.println("<b><a href=\"" + (String)s + "\">" + (String)s + "</a></b>");
                }
            } else if (sw instanceof mddViewer) {
                SourceViewControllerHandler.processDirectory(w, dir, "dd");
                Object[] list = dir.list((FilenameFilter)new SuffixFileFilter(new String[]{".idd", ".mdd"}));
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    String s = DevelUtils.getVirtualPath(req, Configuration.getMddViewerLocation()) + (String)list[i];
                    s = s.substring(1, s.lastIndexOf(".")).replace('/', '.');
                    String addr = req.getContextPath() + Configuration.getMddViewerLocation() + "/" + s;
                    w.println("<a href=\"" + addr + "\">" + (String)list[i] + "</a>");
                }
            } else {
                Logger.getLogger("org.makumba.devel").warning("Don't know how to handle viewer: " + sw + "(" + sw.getClass() + ")");
            }
            w.println("</pre>");
            DevelUtils.printDeveloperSupportFooter(w);
            w.println("</body></html>");
        }
        return false;
    }

    public static void printDirlistingHeader(PrintWriter w, String dir, String relativeDirectory, String contextPath, String key) throws IOException {
        w.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        w.println("<html><head><title>" + relativeDirectory + "</title>");
        w.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" >");
        DevelUtils.writeStylesAndScripts(w, contextPath);
        w.println("</head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr><td rowspan=\"2\">");
        w.print("<font size=\"+2\"><a href=\".\"><font color=\"darkblue\">" + relativeDirectory + "</font></a></font>");
        w.print("<font size=\"-1\"><br>" + dir + "</font>");
        w.print("</td><td align=\"right\">");
        DevelUtils.writeDevelUtilLinks(w, key, contextPath);
        w.print("</td>");
        w.print("</tr></table>\n<pre style=\"margin-top:0\">");
    }

    public static void processDirectory(PrintWriter w, File dir, String extension) {
        Object[] list = dir.listFiles(new DirectoriesExcludingRepositoriesFilter());
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            if (extension != null && !SourceViewControllerHandler.containsFilesWithExtension((File)list[i], extension)) continue;
            w.println("<b><a href=\"" + ((File)list[i]).getName() + "/\">" + ((File)list[i]).getName() + "/</a></b>");
        }
    }

    static boolean containsFilesWithExtension(File dir, String ... extension) {
        int i;
        File[] files = dir.listFiles((FileFilter)new SuffixFileFilter(extension));
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            return true;
        }
        files = dir.listFiles(new DirectoriesExcludingRepositoriesFilter());
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory() || !SourceViewControllerHandler.containsFilesWithExtension(files[i], extension)) continue;
            return true;
        }
        return false;
    }

    public static final class DirectoriesExcludingRepositoriesFilter
    implements FileFilter {
        public boolean accept(File f) {
            return f.isDirectory() && !f.getName().equals("CVS") && !f.getName().equals(".svn");
        }
    }
}

