/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.devel.LineViewer;
import org.makumba.providers.datadefinition.makumba.RecordParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class errorViewer
extends LineViewer {
    private static final String patternLineNumber1 = "\\(.+:(\\d+)\\).*";
    private static final String patternLineNumber2 = ":(\\d+).*";
    private static final String patternLineNumber3 = "\\((\\d+),\\d+\\).*";
    private static final String[] patternLineNumberStrings = new String[]{"\\(.+:(\\d+)\\).*", ":(\\d+).*", "\\((\\d+),\\d+\\).*"};
    Pattern[] patternLineNumbers = new Pattern[]{Pattern.compile(patternLineNumberStrings[0]), Pattern.compile(patternLineNumberStrings[1]), Pattern.compile(patternLineNumberStrings[2])};
    private static final String regex = "\\bhttp://[^\\s]+";
    private static final Pattern pattern = Pattern.compile("\\bhttp://[^\\s]+");
    private String hiddenBody;

    public errorViewer(HttpServletRequest request, ServletContext servletContext, String title, String body, String hiddenBody, boolean printHeaderFooter) throws IOException {
        super(false, request, servletContext);
        this.realPath = servletContext.getRealPath(request.getServletPath());
        this.printHeaderFooter = printHeaderFooter;
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(servletContext);
        this.title = title;
        this.hiddenBody = hiddenBody;
        this.reader = new StringReader(body);
    }

    @Override
    public String parseLine(String s) {
        StringBuffer source = new StringBuffer(s);
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = this.getLineTokenizer(s);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            int indexOf = source.indexOf(token);
            int indexAfter = indexOf + token.length();
            result.append(source.substring(0, indexOf));
            if (token.indexOf(".") != -1) {
                String substring;
                Class<?> javaClass;
                Integer lineNumber = null;
                if (this.searchMDD && RecordParser.findDataDefinition(token, "mdd") != null || RecordParser.findDataDefinition(token, "idd") != null) {
                    result.append(this.formatMDDLink(token));
                } else if (this.searchJavaClasses && (javaClass = this.findClassSimple(token)) != null) {
                    substring = source.substring(indexAfter).trim();
                    lineNumber = this.findLineNumber(substring);
                    result.append(this.formatClassLink(javaClass.getName(), token, lineNumber));
                } else {
                    String jspClass;
                    String jspPage;
                    javaClass = this.findClass(token);
                    if (javaClass != null) {
                        result.append(this.formatClassLink(javaClass, null, token));
                    } else if (this.searchJSPPages && (jspPage = this.findPage(token)) != null) {
                        substring = source.substring(indexAfter).trim();
                        lineNumber = this.findLineNumber(substring);
                        result.append(this.formatJSPLink(jspPage, token, lineNumber));
                    } else if (this.searchCompiledJSPClasses && (jspClass = this.findCompiledJSP(token)) != null) {
                        substring = source.substring(indexAfter).trim();
                        lineNumber = this.findLineNumber(substring);
                        result.append(this.formatClassLink(jspClass, token, lineNumber));
                    } else {
                        result.append(token);
                    }
                }
            } else {
                result.append(token);
            }
            source.delete(0, indexOf + token.length());
        }
        return errorViewer.markupLinks(result.append(source).toString());
    }

    private static String markupLinks(String string) {
        Matcher matcher = pattern.matcher(string);
        StringBuilder sb = new StringBuilder();
        int currentIndex = 0;
        while (matcher.find()) {
            sb.append(string.substring(currentIndex, matcher.start()));
            sb.append("<a href=\"").append(matcher.group()).append("\">").append(matcher.group()).append("</a>");
            currentIndex = matcher.end();
        }
        sb.append(string.substring(currentIndex));
        return sb.toString();
    }

    private Integer findLineNumber(String s) {
        for (Pattern patternLineNumber : this.patternLineNumbers) {
            Matcher m = patternLineNumber.matcher(s);
            if (!m.matches()) continue;
            return Integer.parseInt(m.group(1));
        }
        return null;
    }

    @Override
    public Class<?> findClassSimple(String token) {
        int index = token.lastIndexOf(46);
        String className = token.substring(0, index);
        return super.findClassSimple(className);
    }

    @Override
    public void footer(PrintWriter pw) throws IOException {
        if (this.hiddenBody != null) {
            pw.println("<!--\n" + this.hiddenBody + "\n-->");
        }
        super.footer(pw);
    }

    public static void main(String[] args) {
        String[] strings;
        for (String string : strings = new String[]{"http://parade.best.eu.org/rudi-k/website/company/private/cvSearch.jsp", "http://www.google.com is super, http://www.google.com too, but best is http://www.google.com!", " http://en.wikipedia.org/wiki/PC_Tools_(Central_Point_Software) ", "Visit my website at http://www.example.com, it's awesome! ", "Please go to http://stackoverflow.com"}) {
            System.out.println(string);
            System.out.println(errorViewer.markupLinks(string));
            System.out.println();
        }
    }
}

