/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRelations {
    private String path;
    private Map<String, Vector<RelationOrigin>> jspRelations;
    private Map<String, Vector<RelationOrigin>> mddRelations;
    private Map<String, Vector<RelationOrigin>> javaRelations;

    public FileRelations(String relativeFilePath) {
        this.path = relativeFilePath;
        this.jspRelations = new HashMap<String, Vector<RelationOrigin>>();
        this.javaRelations = new HashMap<String, Vector<RelationOrigin>>();
        this.mddRelations = new HashMap<String, Vector<RelationOrigin>>();
    }

    public Map<String, Vector<RelationOrigin>> getJspRelations() {
        return this.jspRelations;
    }

    public Map<String, Vector<RelationOrigin>> getMddRelations() {
        return this.mddRelations;
    }

    public Map<String, Vector<RelationOrigin>> getJavaRelations() {
        return this.javaRelations;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        Vector<RelationOrigin> origin;
        String result = "Relations for file " + this.path + "\n";
        result = result + "  == JSP relations\n";
        for (String jsp : this.jspRelations.keySet()) {
            result = result + jsp + "\n";
            origin = this.jspRelations.get(jsp);
            for (RelationOrigin relationOrigin : origin) {
                result = result + relationOrigin.toString();
            }
            result = result + "\n";
        }
        result = result + "  == Java relations\n";
        for (String java : this.javaRelations.keySet()) {
            result = result + java + "\n";
            origin = this.javaRelations.get(java);
            for (RelationOrigin relationOrigin : origin) {
                result = result + relationOrigin.toString();
            }
            result = result + "\n";
        }
        result = result + "  == MDD relations\n";
        for (String mdd : this.mddRelations.keySet()) {
            result = result + mdd + "\n";
            origin = this.mddRelations.get(mdd);
            for (RelationOrigin relationOrigin : origin) {
                result = result + relationOrigin.toString();
            }
            result = result + "\n";
        }
        result = result + "\n";
        return result;
    }

    public boolean isEmpty() {
        return this.getMddRelations().size() == 0 && this.getJspRelations().size() == 0 && this.getMddRelations().size() == 0;
    }

    public class RelationOrigin {
        private int startCol;
        private int endCol;
        private int startLine;
        private int endLine;
        private String tagName;
        private String expr;
        private String field;
        private String reason;

        public int getStartCol() {
            return this.startCol;
        }

        public int getEndCol() {
            return this.endCol;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getExpr() {
            return this.expr;
        }

        public String getField() {
            return this.field;
        }

        public String getOtherReason() {
            return this.reason;
        }

        public RelationOrigin(int startCol, int endCol, int startLine, int endLine, String tagName, String expr, String field, String reason) {
            this.startCol = startCol;
            this.endCol = endCol;
            this.startLine = startLine;
            this.endLine = endLine;
            this.tagName = tagName;
            this.expr = expr;
            this.field = field;
            this.reason = reason;
        }

        public String toString() {
            String result = "Relation origin:\n";
            result = result + "  startCol: " + this.startCol + "\n";
            result = result + "  endCol: " + this.endCol + "\n";
            result = result + "  startLine: " + this.startLine + "\n";
            result = result + "  endLine: " + this.endLine + "\n";
            result = result + "  tagName: " + this.tagName + "\n";
            result = result + "  expr: " + this.expr + "\n";
            result = result + "  field: " + this.field + "\n";
            result = result + "  reason: " + this.reason + "\n";
            return result;
        }
    }
}

