/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.Dictionary;
import org.makumba.HtmlUtils;
import org.makumba.ProgrammerError;
import org.makumba.commons.SingletonReleaser;
import org.makumba.commons.StringUtils;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.forms.html.FieldEditor;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class charEditor
extends FieldEditor {
    static String[] _params = new String[]{"default", "empty", "type", "size", "maxlength", "autoComplete", "clearDefault"};
    static String[][] _paramValues = new String[][]{null, null, {"text", "password"}, null, null, {"true", "false"}, {"true", "false"}};

    protected charEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    @Override
    public String[] getAcceptedParams() {
        return _params;
    }

    @Override
    public String[][] getAcceptedValue() {
        return _paramValues;
    }

    public int getWidth(RecordFormatter rf, int fieldIndex) {
        return rf.dd.getFieldDefinition(fieldIndex).getWidth();
    }

    public String getParams(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        String ret = this.getIntParamString(rf, fieldIndex, formatParams, "size");
        int n = this.getIntParam(rf, fieldIndex, formatParams, "maxlength");
        if (n > this.getWidth(rf, fieldIndex)) {
            throw new InvalidValueException(rf.expr[fieldIndex], "invalid too big for maxlength " + n);
        }
        if (n == -1) {
            n = this.getWidth(rf, fieldIndex);
        }
        ret = ret + "maxlength=\"" + n + "\" ";
        return ret;
    }

    @Override
    public String formatNull(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        return this.formatNotNull(rf, fieldIndex, null, formatParams);
    }

    @Override
    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        boolean autoComplete = formatParams.get("autoComplete") != null && formatParams.get("autoComplete").equals("true");
        boolean clearDefault = formatParams.get("clearDefault") != null && formatParams.get("clearDefault").equals("true");
        String test = this.getParams(rf, fieldIndex, formatParams);
        String res = "";
        String id = "";
        res = res + "<input name=\"" + charEditor.getInputName(rf, fieldIndex, formatParams) + "\" type=\"" + this.getInputType(rf, fieldIndex, formatParams) + "\" value=\"" + this.formatValue(rf, fieldIndex, o, formatParams) + "\" " + test + charEditor.getExtraFormatting(rf, fieldIndex, formatParams) + (autoComplete ? "autocomplete=\"off\"" : "") + (clearDefault ? "onBlur=\"if(this.value=='') this.value='" + HtmlUtils.escapeQuotes(HtmlUtils.string2html(this.getDefaultValueFormat(rf, fieldIndex, formatParams))) + "';\" onFocus=\"if(this.value=='" + HtmlUtils.escapeQuotes(HtmlUtils.string2html(this.getDefaultValueFormat(rf, fieldIndex, formatParams))) + "') this.value='';\"" : "") + ">";
        if (autoComplete && !this.getInputType(rf, fieldIndex, formatParams).equals("password")) {
            id = StringUtils.getParam("id", charEditor.getExtraFormatting(rf, fieldIndex, formatParams));
            res = res + "<div id=\"autocomplete_choices_" + id + "\" class=\"autocomplete\"></div>";
            res = res + "<script type=\"text/javascript\">MakumbaAutoComplete.AutoComplete(\"" + id + "\", \"" + Configuration.getMakumbaAutoCompleteLocation() + "\", \"" + rf.dd.getFieldDefinition(fieldIndex).getOriginalFieldDefinition().getDataDefinition().getName() + "\", \"" + rf.dd.getFieldDefinition(fieldIndex).getOriginalFieldDefinition().getName() + "\", \"char\", \"" + (String)formatParams.get("org.makumba.forms.queryLanguage") + "\");</script>";
        } else if (autoComplete && this.getInputType(rf, fieldIndex, formatParams).equals("password")) {
            throw new ProgrammerError("Can't use auto-complete on an input field of type 'password'!");
        }
        return res;
    }

    @Override
    public String formatValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        return HtmlUtils.string2html(this.resetValueFormat(rf, fieldIndex, o == null ? null : o.toString(), formatParams));
    }

    public String getInputType(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        String s = (String)formatParams.get("type");
        if (s == null) {
            s = "text";
        }
        return s;
    }

    private static final class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        static FieldEditor singleton = new charEditor();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

