/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Transaction;
import org.makumba.db.makumba.MakumbaTransactionProvider;
import org.makumba.importer.HtmlTagEnumerator;
import org.makumba.importer.ObjectImporter;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableImporter {
    ObjectImporter imp;
    boolean inRow = false;
    boolean inCell = false;
    String text;
    Vector<String> data;
    String[] fieldOrder;
    String type;
    Transaction db;

    void endOfCell() {
        if (this.inCell) {
            this.data.addElement(this.text);
        }
        this.text = null;
    }

    void endOfRow() {
        this.endOfCell();
        if (this.data != null && !this.data.isEmpty()) {
            if (this.data.size() != this.fieldOrder.length) {
                Logger.getLogger("org.makumba.import").severe(this.type + ": invalid HTML table row length: " + this.data.size() + "\r\nin: " + this.data);
            } else {
                try {
                    this.db.insert(this.type, this.importVector());
                }
                catch (InvalidValueException e) {
                    Logger.getLogger("org.makumba.import").warning("record not inserted --> " + e.getMessage());
                }
            }
        }
    }

    public HtmlTableImporter(Transaction db, DataDefinition type, Reader r, String tableStartTag, String[] fieldOrder) throws IOException {
        this.imp = new ObjectImporter(type, true);
        this.fieldOrder = fieldOrder;
        this.type = type.getName();
        this.db = db;
        String[] tables = new String[]{type.getName()};
        HtmlTableImporter._delete(db.getName(), db.getName(), tables);
        HtmlTagEnumerator e = new HtmlTagEnumerator(r);
        while (e.next() && !e.getTag().equals(tableStartTag)) {
        }
        while (e.next()) {
            String s;
            if (e.getTagType().toLowerCase().equals("tr")) {
                this.endOfRow();
                this.inRow = true;
                this.inCell = false;
                this.data = new Vector();
            } else if (this.inRow && e.getTagType().toLowerCase().equals("td")) {
                this.endOfCell();
                this.inCell = true;
            } else if (this.inCell && (s = e.getNonHtml()) != null && s.length() > 0) {
                this.text = s;
            }
            if (!e.getTagType().toLowerCase().equals("/table")) continue;
            this.endOfRow();
            Logger.getLogger("org.makumba.import").severe("end of table encountered");
            return;
        }
        Logger.getLogger("org.makumba.import").severe("end of table missing");
    }

    Dictionary<String, Object> importVector() {
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        Vector<Object> v1 = new Vector<Object>();
        for (int i = 0; i < this.fieldOrder.length; ++i) {
            if (this.data.elementAt(i) == null) continue;
            Object o = this.imp.getValue(this.fieldOrder[i], this.data.elementAt(i), this.db, null);
            if (o != null) {
                ((Dictionary)d).put(this.fieldOrder[i], o);
            }
            v1.addElement(o);
        }
        Logger.getLogger("org.makumba.import").finest(v1.toString());
        return d;
    }

    public static void _delete(String whereDB, String provenienceDB, String[] typeNames, boolean ignoreDbsv) {
        ((MakumbaTransactionProvider)MakumbaTransactionProvider.getInstance())._delete(whereDB, provenienceDB, typeNames, ignoreDbsv);
    }

    public static void _delete(String whereDB, String provenienceDB, String[] typeNames) {
        HtmlTableImporter._delete(whereDB, provenienceDB, typeNames, false);
    }

    public static void main(String[] argv) throws IOException {
        String[] args = new String[argv.length - 4];
        System.arraycopy(argv, 4, args, 0, args.length);
        new HtmlTableImporter(TransactionProvider.getInstance().getConnectionTo(argv[0]), DataDefinitionProvider.getInstance().getDataDefinition(argv[1]), new BufferedReader(new InputStreamReader(new FileInputStream(argv[2]))), argv[3], args);
    }
}

