/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.Transaction;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.TransactionProvider;

public class MakumbaDownloadServlet
extends HttpServlet {
    private static final String QUERY_WHERE = " f WHERE f=$1";
    private static final String QUERY_SELECT = "SELECT f.content as content, f.contentType as contentType, f.contentLength as contentLength, f.name as name FROM ";
    private static final long serialVersionUID = 1L;
    private static final String[] INLINE_CONTENT_TYPES = new String[]{"text/plain", "text/html", "image/jpeg", "image/jpg", "image/pjpeg", "image/gif", "image/png"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            Transaction t = null;
            try {
                t = TransactionProvider.getInstance().getConnectionTo(TransactionProvider.getInstance().getDefaultDataSourceName());
                String ptr = req.getParameter("value");
                String type = req.getParameter("type");
                if (StringUtils.isBlank((String)ptr) || StringUtils.isBlank((String)type)) {
                    PrintWriter w = response.getWriter();
                    w.println("Both 'value' and 'type' parameters need to be not-empty!");
                    return;
                }
                Vector<Dictionary<String, Object>> v = t.executeQuery(QUERY_SELECT + type + QUERY_WHERE, new Pointer(type, ptr));
                if (v.size() == 1) {
                    Text content = (Text)v.firstElement().get("content");
                    String contentType = (String)v.firstElement().get("contentType");
                    Integer contentLength = (Integer)v.firstElement().get("contentLength");
                    String name = (String)v.firstElement().get("name");
                    if (MakumbaDownloadServlet.isInlineContentType(contentType)) {
                        response.setHeader("Content-Disposition", "inline;");
                    } else {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
                    }
                    response.setContentType(contentType);
                    response.setContentLength(contentLength.intValue());
                    content.writeTo((OutputStream)response.getOutputStream());
                    break block9;
                }
                throw new RuntimeWrappedException(new LogicException("Error retrieving file of type '" + type + "', id '" + ptr + "', found " + v.size() + " matching results."));
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
    }

    public static boolean isInlineContentType(String contentType) {
        for (int i = 0; i < INLINE_CONTENT_TYPES.length; ++i) {
            if (!contentType.equalsIgnoreCase(INLINE_CONTENT_TYPES[i])) continue;
            return true;
        }
        return false;
    }
}

