/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfiguredDataSource {
    private Configuration.DataSourceType type;
    private String name;
    private String host;
    private String path;
    private String hostAddress;
    private Map<String, String> properties = new Hashtable<String, String>();

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Configuration.DataSourceType getType() {
        return this.type;
    }

    public void setType(Configuration.DataSourceType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ConfiguredDataSource(String host, String name, String path, Configuration.DataSourceType type) {
        this.host = host;
        try {
            this.hostAddress = InetAddress.getByName(host).toString();
        }
        catch (UnknownHostException e) {
            this.hostAddress = null;
        }
        this.name = name;
        this.path = path;
        this.type = type;
    }

    public String toString() {
        return "dataSource:" + this.name + (this.host == null ? "" : " host:" + this.hostAddress) + (this.path == null ? "" : " path:" + this.path);
    }
}

