/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.commons.ClassResource;
import org.makumba.commons.SingletonHolder;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataDefinitionProvider
implements SingletonHolder {
    private static String[] dataDefinitionProviders = new String[]{"mdd", "org.makumba.providers.datadefinition.mdd.MDDProvider", "recordinfo", "org.makumba.providers.datadefinition.makumba.MakumbaDataDefinitionFactory"};
    static final Map<String, DataDefinitionProvider> providerInstances = new HashMap<String, DataDefinitionProvider>();

    public static DataDefinitionProvider getInstance() {
        return providerInstances.get(Configuration.getDataDefinitionProvider());
    }

    @Override
    public void release() {
        providerInstances.clear();
    }

    public abstract DataDefinition getDataDefinition(String var1);

    public abstract DataDefinition getVirtualDataDefinition(String var1);

    public abstract FieldDefinition makeFieldDefinition(String var1, String var2);

    public abstract FieldDefinition makeFieldOfType(String var1, String var2);

    public abstract FieldDefinition makeFieldOfType(String var1, String var2, String var3);

    public abstract FieldDefinition makeFieldWithName(String var1, FieldDefinition var2);

    public abstract FieldDefinition makeFieldWithName(String var1, FieldDefinition var2, String var3);

    public Vector<String> getDataDefinitionsInLocation(String location) {
        return this.mddsInDirectory(location);
    }

    public Vector<String> getDataDefinitionsInDefaultLocations() {
        return this.getDataDefinitionsInDefaultLocations(null);
    }

    public Vector<String> getDataDefinitionsInDefaultLocations(String ... ignoreList) {
        Vector<String> mdds = this.mddsInDirectory("dataDefinitions");
        Vector<String> mddsInClasses = this.mddsInDirectory("");
        for (String string : mddsInClasses) {
            if (string.startsWith("dataDefinitions.")) continue;
            mdds.add(string);
        }
        if (ignoreList != null) {
            Vector<String> mddCopy = new Vector<String>(mdds);
            for (String s : ignoreList) {
                for (String mdd : mddCopy) {
                    if (!mdd.startsWith(s)) continue;
                    mdds.remove(mdd);
                }
            }
        }
        return mdds;
    }

    private Vector<String> mddsInDirectory(String dirInClasspath) {
        Vector<String> mdds = new Vector<String>();
        try {
            URL u = ClassResource.get(dirInClasspath);
            if (u != null) {
                File dir = new File(u.toURI());
                this.fillMdds(dir.toString().length() + 1, dir, mdds);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return mdds;
    }

    private void fillMdds(int baselength, File dir, Vector<String> mdds) {
        if (dir.isDirectory()) {
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                String s = list[i];
                if (s.endsWith(".mdd")) {
                    s = dir.toString() + File.separatorChar + s;
                    s = s.substring(baselength, s.length() - 4);
                    s = s.replace(File.separatorChar, '.');
                    mdds.add(s);
                    continue;
                }
                File f = new File(dir, s);
                if (!f.isDirectory()) continue;
                this.fillMdds(baselength, f, mdds);
            }
        }
    }

    public static final FieldDefinition getFieldDefinition(DataDefinition dd, String fieldName, String lineWithDefinition) throws DataDefinitionParseError {
        DataDefinition checkedDataDef = dd;
        int indexOf = -1;
        while ((indexOf = fieldName.indexOf(".")) != -1) {
            String subFieldName = fieldName.substring(0, indexOf);
            fieldName = fieldName.substring(indexOf + 1);
            checkedDataDef = checkedDataDef.getFieldDefinition(subFieldName).getPointedType();
        }
        FieldDefinition fd = checkedDataDef.getFieldDefinition(fieldName);
        if (fd == null) {
            throw new DataDefinitionParseError(checkedDataDef.getName(), "Field '" + fieldName + "' not defined in type " + dd.getName() + "!", lineWithDefinition);
        }
        return fd;
    }

    static {
        for (int i = 0; i < dataDefinitionProviders.length; i += 2) {
            try {
                Method getInstance = Class.forName(dataDefinitionProviders[i + 1]).getDeclaredMethod("getInstance", new Class[0]);
                DataDefinitionProvider tp = (DataDefinitionProvider)getInstance.invoke(null, new Object[0]);
                providerInstances.put(dataDefinitionProviders[i], tp);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

