/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.lang.StringUtils;
import org.makumba.ConfigurationError;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaINIConfiguration
extends HierarchicalINIConfiguration {
    private static final long serialVersionUID = 1L;
    private MakumbaINIConfiguration defaultConfiguration;
    private URL u;

    public MakumbaINIConfiguration(URL u, MakumbaINIConfiguration defaultConfiguration) throws ConfigurationException {
        this(u);
        this.defaultConfiguration = defaultConfiguration;
    }

    public MakumbaINIConfiguration(URL u) throws ConfigurationException {
        super(u);
        this.u = u;
        this.setAutoSave(false);
        this.setReloadingStrategy((ReloadingStrategy)new InvariantReloadingStrategy());
        this.setListDelimiter('+');
        ((DefaultExpressionEngine)this.getExpressionEngine()).setPropertyDelimiter("+");
        this.load();
    }

    public boolean getBooleanProperty(String section, String property) {
        String k = this.getSection(section).getString(property);
        if (k == null && (k = this.defaultConfiguration.getSection(section).getString(property)) == null) {
            return false;
        }
        return Boolean.parseBoolean(k);
    }

    public Map<String, String> getPropertiesAsMap(String section) {
        HashMap<String, String> m = new HashMap<String, String>();
        SubnodeConfiguration s = this.getSection(section);
        if (s == null) {
            throw new ConfigurationError("Section " + section + " does not exist in Makumba.conf");
        }
        Iterator i = s.getKeys();
        while (i.hasNext()) {
            String k;
            String originalK = k = (String)i.next();
            if (k.indexOf("..") > 0) {
                k = StringUtils.replace((String)k, (String)"..", (String)".");
            }
            m.put(k, this.getSection(section).getString(originalK));
        }
        return m;
    }

    public Map<String, String> getPropertiesAsMap(String section, MakumbaINIConfiguration defaultConfig) {
        Map<String, String> defaults = defaultConfig.getPropertiesAsMap(section);
        if (this.getSections().contains(section)) {
            Map<String, String> application = this.getPropertiesAsMap(section);
            Set<String> keySet = application.keySet();
            for (String string : keySet) {
                if (application.get(string) == null) continue;
                defaults.put(string, application.get(string));
            }
        } else {
            Configuration.logger.info("No application specific config found for '" + section + "', using only internal defaults.");
        }
        return defaults;
    }

    public Map<String, Map<String, String>> getPropertiesStartingWith(String sectionPrefix) {
        LinkedHashMap<String, Map<String, String>> res = new LinkedHashMap<String, Map<String, String>>();
        Set sectionNames = this.getSections();
        for (String section : sectionNames) {
            if (!section.startsWith(sectionPrefix)) continue;
            res.put(section.substring(sectionPrefix.length()), this.getPropertiesAsMap(section));
        }
        return res;
    }

    public String getProperty(String section, String property) {
        String s = this.getSection(section).getString(property);
        if (s == null && (s = this.defaultConfiguration.getSection(section).getString(property)) == null) {
            return "PROPERTY_NOT_SET";
        }
        return s;
    }

    public String getSource() {
        return this.u.getPath();
    }
}

