/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.makumba.Transaction;
import org.makumba.commons.SingletonHolder;
import org.makumba.commons.SingletonReleaser;
import org.makumba.providers.CRUDOperationProvider;
import org.makumba.providers.Configuration;

public abstract class TransactionProvider
implements SingletonHolder {
    private static String[] transactionProviders = new String[]{"makumba", "org.makumba.db.makumba.MakumbaTransactionProvider", "hibernate", "org.makumba.db.hibernate.HibernateTransactionProvider"};
    static final Map<String, TransactionProvider> providerInstances = new HashMap<String, TransactionProvider>();
    public static final String CONNECTION_PREFIX = "connection.";
    public static final String CONNECTION_URL = "url";
    public static final String CONNECTION_USERNAME = "username";
    public static final String CONNECTION_PASSWORD = "password";

    public static TransactionProvider getInstance() {
        return providerInstances.get(Configuration.getDefaultDatabaseLayer());
    }

    public Transaction getConnectionTo(String name) {
        switch (Configuration.getDataSourceType(name)) {
            case makumba: {
                return providerInstances.get(Configuration.DataSourceType.makumba.toString()).getTransaction(name);
            }
            case hibernate: {
                return providerInstances.get(Configuration.DataSourceType.makumba.toString()).getTransaction(name);
            }
        }
        return null;
    }

    protected Transaction getConnectionTo(String name, TransactionProvider instance) {
        Configuration.DataSourceType type = Configuration.getDataSourceType(name);
        instance.setLastConnectionType(type);
        switch (type) {
            case makumba: {
                return providerInstances.get(Configuration.DataSourceType.makumba.toString()).getTransaction(name);
            }
            case hibernate: {
                return providerInstances.get(Configuration.DataSourceType.hibernate.toString()).getTransaction(name);
            }
        }
        return null;
    }

    protected String getQueryLanguage(TransactionProvider instance) {
        switch (instance.getLastConnectionType()) {
            case makumba: {
                return providerInstances.get(Configuration.DataSourceType.makumba.toString()).getQueryLanguageInternal();
            }
            case hibernate: {
                return providerInstances.get(Configuration.DataSourceType.hibernate.toString()).getQueryLanguageInternal();
            }
        }
        return null;
    }

    protected CRUDOperationProvider getCRUD(TransactionProvider instance) {
        switch (instance.getLastConnectionType()) {
            case makumba: {
                return providerInstances.get(Configuration.DataSourceType.makumba.toString()).getCRUDInternal();
            }
            case hibernate: {
                return providerInstances.get(Configuration.DataSourceType.hibernate.toString()).getCRUDInternal();
            }
        }
        return null;
    }

    public String getDefaultDataSourceName() {
        return Configuration.getDefaultDataSourceName();
    }

    protected abstract Transaction getTransaction(String var1);

    protected abstract CRUDOperationProvider getCRUDInternal();

    protected abstract String getQueryLanguageInternal();

    protected abstract Configuration.DataSourceType getLastConnectionType();

    protected abstract void setLastConnectionType(Configuration.DataSourceType var1);

    public abstract CRUDOperationProvider getCRUD();

    public abstract String getQueryLanguage();

    public abstract void closeDataSource(String var1);

    public TransactionProvider() {
        SingletonReleaser.register(this);
    }

    public void release() {
        providerInstances.clear();
    }

    static {
        for (int i = 0; i < transactionProviders.length; i += 2) {
            try {
                Method getInstance = Class.forName(transactionProviders[i + 1]).getDeclaredMethod("getInstance", new Class[0]);
                TransactionProvider tp = (TransactionProvider)getInstance.invoke(null, new Object[0]);
                providerInstances.put(transactionProviders[i], tp);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

