/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.ValidationRule;
import org.makumba.commons.RegExpUtils;
import org.makumba.providers.datadefinition.makumba.FieldInfo;
import org.makumba.providers.datadefinition.makumba.validation.ComparisonValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.NumberRangeValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.RegExpValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.StringLengthValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicValidationRule
implements ValidationRule,
Serializable {
    private static final long serialVersionUID = 1L;
    static ArrayList<String> operators = new ArrayList();
    protected static final String rangeValue = "(\\d+|\\?)";
    protected static final String rangeDef = "\\[(\\d+|\\?)\\.\\.(\\d+|\\?)\\]";
    protected static final String fieldDef = "[a-zA-Z]\\w*(?:\\.\\w+)?[ \\t]+";
    protected static final String lowerFunction = "lower";
    protected static final String upperFunction = "upper";
    protected static final String fieldFunction;
    protected FieldDefinition fd;
    protected String fieldName;
    protected int[] allowedTypes;
    protected String ruleSyntax;
    protected String errorMessage;
    protected String ruleName;
    public static int[] NUMBER_TYPES;
    public static int[] STRING_TYPES;

    public BasicValidationRule(FieldDefinition fd, String fieldName, String errorMessage, String ruleName, int[] allowedTypes) {
        this.allowedTypes = allowedTypes;
        this.errorMessage = errorMessage;
        this.ruleName = ruleName;
        this.fd = fd;
        this.fieldName = fieldName;
    }

    protected BasicValidationRule() {
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public FieldDefinition getFieldDefinition() {
        return this.fd;
    }

    protected String getAllowedTypes() {
        String s = "";
        for (int i = 0; i < this.allowedTypes.length; ++i) {
            s = s + "'" + FieldInfo.getStringType(this.allowedTypes[i]) + "'";
            if (i + 2 < this.allowedTypes.length) {
                s = s + ", ";
                continue;
            }
            if (i + 1 >= this.allowedTypes.length) continue;
            s = s + " and ";
        }
        return s;
    }

    protected Object applyFunction(Object o1, String functionName) {
        if (functionName.equals(lowerFunction)) {
            return ((String)o1).toLowerCase();
        }
        return o1;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public static String extractFunctionArgument(String statement) {
        int beginIndex = statement.indexOf("(");
        int endIndex = statement.lastIndexOf(")");
        if (beginIndex == -1 || endIndex == -1 || beginIndex >= endIndex) {
            return statement;
        }
        return statement.substring(beginIndex + 1, endIndex);
    }

    public static boolean isFunctionCall(String statement) {
        int beginIndex = statement.indexOf("(");
        int endIndex = statement.lastIndexOf(")");
        return beginIndex != -1 && endIndex != -1 && beginIndex < endIndex;
    }

    public static boolean isValidFunctionCall(String s) {
        List<String> validFunctions = Arrays.asList(lowerFunction);
        return BasicValidationRule.isFunctionCall(s) && validFunctions.contains(BasicValidationRule.extractFunctionNameFromStatement(s));
    }

    public static String extractFunctionNameFromStatement(String statement) {
        if (!BasicValidationRule.isFunctionCall(statement)) {
            return null;
        }
        return statement.substring(0, statement.indexOf("("));
    }

    public static void main(String[] args) {
        System.out.println(fieldFunction);
        Pattern p = Pattern.compile(fieldFunction);
        System.out.println(p.pattern());
        String[] rules = new String[]{"someField", "lower(someField)", "lower(  someField    )", "lower (  someField    )"};
        for (int i = 0; i < rules.length; ++i) {
            Matcher matcher = p.matcher(rules[i]);
            System.out.println(rules[i] + ":" + matcher.matches());
        }
    }

    @Override
    public int compareTo(ValidationRule o) {
        if (this instanceof ComparisonValidationRule) {
            return 1;
        }
        if (o instanceof ComparisonValidationRule) {
            return -1;
        }
        return 0;
    }

    public static ArrayList<String> getValidationRuleOperators() {
        return operators;
    }

    @Override
    public Collection<String> getValidationRuleArguments() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public DataDefinition getDataDefinition() {
        throw new RuntimeException("not implemented");
    }

    static {
        operators.add(RegExpValidationRule.getOperator());
        operators.add(NumberRangeValidationRule.getOperator());
        operators.add(StringLengthValidationRule.getOperator());
        operators.addAll(ComparisonValidationRule.getOperators());
        fieldFunction = RegExpUtils.or(new String[]{"[a-zA-Z]\\w*(?:\\.\\w+)?", "(?:lower|upper)[ \\t]*\\([ \\t]*[a-zA-Z]\\w*(?:\\.\\w+)?[ \\t]*\\)"});
        NUMBER_TYPES = new int[]{4, 15};
        STRING_TYPES = new int[]{6, 8};
    }
}

