/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.ValidationRule;
import org.makumba.commons.StringUtils;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.datadefinition.mdd.DataDefinitionImpl;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FieldType;
import org.makumba.providers.datadefinition.mdd.MDDProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinitionImpl
implements FieldDefinition,
Serializable {
    private static final long serialVersionUID = 1595860664381445238L;
    protected DataDefinitionImpl mdd;
    protected String name;
    protected FieldType type;
    protected String description;
    private Object defaultValue;
    protected boolean fixed;
    protected boolean notNull;
    protected boolean notEmpty;
    protected boolean unique;
    protected String notNullError;
    protected String NaNError;
    protected String uniqueError;
    protected String notEmptyError;
    protected String notIntError;
    protected String notRealError;
    protected String notBooleanError;
    protected LinkedHashMap<Integer, String> intEnumValues;
    protected LinkedHashMap<Integer, String> intEnumValuesDeprecated;
    protected Vector<String> charEnumValues;
    protected Vector<String> charEnumValuesDeprecated;
    protected int charLength;
    protected String pointedType;
    protected transient DataDefinition pointed;
    protected DataDefinitionImpl subfield;
    private Hashtable<String, ValidationRule> validationRules;
    private String originalFieldDefinitionParent;
    private String originalFieldDefinitionName;
    private int longestChar;

    public FieldDefinitionImpl(String name, String type, String description) {
        this(name, type);
        this.description = description;
    }

    public FieldDefinitionImpl(String name, DataDefinitionImpl dd) {
        this.intEnumValues = new LinkedHashMap();
        this.intEnumValuesDeprecated = new LinkedHashMap();
        this.charEnumValues = new Vector();
        this.charEnumValuesDeprecated = new Vector();
        this.validationRules = new Hashtable();
        this.longestChar = -1;
        this.name = name;
        this.mdd = dd;
    }

    public FieldDefinitionImpl(String name, String type) {
        block7: {
            this.intEnumValues = new LinkedHashMap();
            this.intEnumValuesDeprecated = new LinkedHashMap();
            this.charEnumValues = new Vector();
            this.charEnumValuesDeprecated = new Vector();
            this.validationRules = new Hashtable();
            this.longestChar = -1;
            this.name = name;
            this.fixed = false;
            this.notNull = false;
            this.notEmpty = false;
            this.unique = false;
            try {
                this.type = FieldType.valueOf(type.toUpperCase());
                if (this.type == FieldType.CHAR) {
                    this.charLength = 255;
                }
            }
            catch (IllegalArgumentException e) {
                if (!type.startsWith("char")) break block7;
                try {
                    int n = type.indexOf("[");
                    int m = type.indexOf("]");
                    if (!type.endsWith("]") || type.substring(3, n).trim().length() > 1) {
                        throw new InvalidValueException("invalid char type " + type);
                    }
                    this.charLength = new Integer(Integer.parseInt(type.substring(n + 1, m)));
                    this.type = FieldType.CHAR;
                }
                catch (StringIndexOutOfBoundsException e1) {
                    throw new InvalidValueException("bad type " + type);
                }
                catch (NumberFormatException f) {
                    throw new InvalidValueException("bad char[] size " + type);
                }
            }
        }
    }

    public FieldDefinitionImpl(String name, String type, DataDefinitionImpl mdd) {
        this(name, type);
        this.mdd = mdd;
    }

    public FieldDefinitionImpl(String name, FieldDefinition fi) {
        this.intEnumValues = new LinkedHashMap();
        this.intEnumValuesDeprecated = new LinkedHashMap();
        this.charEnumValues = new Vector();
        this.charEnumValuesDeprecated = new Vector();
        this.validationRules = new Hashtable();
        this.longestChar = -1;
        FieldDefinitionImpl f = (FieldDefinitionImpl)fi;
        this.name = name;
        this.mdd = f.mdd;
        this.type = f.type;
        this.fixed = f.fixed;
        this.notEmpty = f.notEmpty;
        this.notNull = f.notNull;
        this.unique = f.unique;
        this.uniqueError = f.uniqueError;
        this.notNullError = f.notNullError;
        this.notEmptyError = f.notEmptyError;
        this.NaNError = f.NaNError;
        this.notIntError = f.notIntError;
        this.notRealError = f.notRealError;
        this.notBooleanError = f.notBooleanError;
        this.defaultValue = fi.getDefaultValue();
        this.description = fi.getDescription();
        this.charLength = f.charLength;
        this.defaultValue = f.defaultValue;
        this.description = f.description;
        this.pointedType = f.pointedType;
        this.pointed = f.pointed;
        this.subfield = f.subfield;
        this.intEnumValues = f.intEnumValues;
        this.intEnumValuesDeprecated = f.intEnumValuesDeprecated;
        this.charEnumValues = f.charEnumValues;
        this.charEnumValuesDeprecated = f.charEnumValuesDeprecated;
        if (this.type == FieldType.PTRINDEX) {
            this.type = FieldType.PTR;
            this.pointed = fi.getDataDefinition();
        }
        this.validationRules = ((FieldDefinitionImpl)fi).validationRules;
        if (fi.getDataDefinition() != null && !fi.getDataDefinition().isTemporary()) {
            this.originalFieldDefinitionParent = fi.getDataDefinition().getName();
            this.originalFieldDefinitionName = fi.getName();
        }
    }

    public FieldDefinitionImpl(String name, FieldDefinition field, String description) {
        this(name, field);
        this.description = description;
    }

    public FieldDefinitionImpl(DataDefinitionImpl mdd, FieldNode f) {
        this.intEnumValues = new LinkedHashMap();
        this.intEnumValuesDeprecated = new LinkedHashMap();
        this.charEnumValues = new Vector();
        this.charEnumValuesDeprecated = new Vector();
        this.validationRules = new Hashtable();
        this.longestChar = -1;
        this.mdd = mdd;
        this.name = f.name;
        this.fixed = f.fixed;
        this.notEmpty = f.notEmpty;
        this.notNull = f.notNull;
        this.unique = f.unique;
        this.uniqueError = f.uniqueError;
        this.notNullError = f.notNullError;
        this.notEmptyError = f.notEmptyError;
        this.NaNError = f.NaNError;
        this.notIntError = f.notIntError;
        this.notRealError = f.notRealError;
        this.notBooleanError = f.notBooleanError;
        this.charLength = f.charLength;
        this.defaultValue = f.defaultValue;
        this.description = f.description;
        this.type = f.makumbaType;
        this.intEnumValues = f.intEnumValues;
        this.intEnumValuesDeprecated = f.intEnumValuesDeprecated;
        this.charEnumValues = f.charEnumValues;
        this.charEnumValuesDeprecated = f.charEnumValuesDeprecated;
        this.pointedType = f.pointedType;
        this.validationRules = f.validationRules;
        if (this.getDataDefinition() != null && !this.getDataDefinition().isTemporary()) {
            this.originalFieldDefinitionParent = this.getDataDefinition().getName();
            this.originalFieldDefinitionName = this.getName();
        }
        if (f.subfield != null) {
            this.subfield = new DataDefinitionImpl(f.getName(), f.subfield, mdd);
            this.subfield.build();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = FieldType.valueOf(type);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        if (this.description == null || this.description.trim().equals("")) {
            return this.name;
        }
        return this.description;
    }

    @Override
    public boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public DataDefinitionImpl getDataDefinition() {
        return this.mdd;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public boolean isBinaryType() {
        return this.type == FieldType.BINARY;
    }

    @Override
    public boolean isBooleanType() {
        return this.type == FieldType.BOOLEAN;
    }

    @Override
    public boolean isComplexSet() {
        return this.type == FieldType.SETCOMPLEX;
    }

    @Override
    public boolean isDateType() {
        return this.type == FieldType.DATE || this.type == FieldType.DATECREATE || this.type == FieldType.DATEMODIFY;
    }

    @Override
    public boolean isEnumType() {
        return this.type == FieldType.INTENUM || this.type == FieldType.CHARENUM;
    }

    @Override
    public boolean isExternalSet() {
        return this.type == FieldType.SET;
    }

    @Override
    public boolean isFileType() {
        return this.subfield != null && this.subfield.isFileSubfield;
    }

    @Override
    public boolean isIndexPointerField() {
        return this.type == FieldType.PTRINDEX;
    }

    @Override
    public boolean isIntegerType() {
        return this.type == FieldType.INT;
    }

    @Override
    public boolean isInternalSet() {
        return this.type == FieldType.SETCOMPLEX || this.type == FieldType.SETINTENUM || this.type == FieldType.SETCHARENUM;
    }

    @Override
    public boolean isNumberType() {
        return this.isIntegerType() || this.isRealType();
    }

    @Override
    public boolean isPointer() {
        return this.type == FieldType.PTR;
    }

    @Override
    public boolean isRealType() {
        return this.type == FieldType.REAL;
    }

    @Override
    public boolean isSetEnumType() {
        return this.type == FieldType.SETCHARENUM || this.type == FieldType.SETINTENUM;
    }

    @Override
    public boolean isSetType() {
        return this.isInternalSet() || this.isExternalSet();
    }

    @Override
    public boolean isStringType() {
        return this.type == FieldType.CHAR || this.type == FieldType.TEXT;
    }

    @Override
    public void addValidationRule(Collection<ValidationRule> rules) {
        if (rules != null) {
            for (ValidationRule validationRule : rules) {
                this.addValidationRule(validationRule);
            }
        }
    }

    @Override
    public void addValidationRule(ValidationRule rule) {
        this.validationRules.put(rule.getRuleName(), rule);
    }

    @Override
    public Collection<ValidationRule> getValidationRules() {
        ArrayList<ValidationRule> arrayList = new ArrayList<ValidationRule>(this.validationRules.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public void checkInsert(Dictionary<String, Object> d) {
        Object o = d.get(this.getName());
        if (this.isNotNull() && (o == null || o.equals(this.getNull()))) {
            throw new CompositeValidationException(new InvalidValueException(this, this.notNullError != null ? this.notNullError : "A non-null value is required for this field"));
        }
        if (this.isNotEmpty() && StringUtils.isEmpty(o)) {
            throw new CompositeValidationException(new InvalidValueException(this, this.notEmptyError != null ? this.notEmptyError : "A non-empty value is required for this field"));
        }
        if (o != null) {
            d.put(this.getName(), this.checkValue(o));
        }
    }

    @Override
    public void checkUpdate(Dictionary<String, Object> d) {
        Object o = d.get(this.getName());
        if (this.isNotEmpty() && StringUtils.isEmpty(o)) {
            throw new CompositeValidationException(new InvalidValueException(this, "A non-empty value is required for this field"));
        }
        if (o == null) {
            return;
        }
        if (this.isFixed()) {
            throw new CompositeValidationException(new InvalidValueException(this, "You cannot update a fixed field"));
        }
        d.put(this.getName(), this.checkValue(o));
    }

    @Override
    public Object checkValue(Object value) {
        if (!value.equals(this.getNull())) {
            switch (this.type) {
                case CHAR: {
                    this.normalCheck(value);
                    String s = (String)value;
                    if (s.length() > this.getWidth()) {
                        throw new InvalidValueException(this, "String too long for char[] field. Maximum width: " + this.getWidth() + " given width " + s.length() + ".\n\tGiven value <" + s + ">");
                    }
                    return value;
                }
                case CHARENUM: {
                    return this.checkCharEnum(value);
                }
                case DATE: 
                case DATECREATE: 
                case DATEMODIFY: {
                    return this.normalCheck(value);
                }
                case INT: {
                    if (!(value instanceof Integer) && !(value instanceof Long)) {
                        throw new InvalidValueException((FieldDefinition)this, this.getJavaType(), value);
                    }
                    if (value instanceof Integer) {
                        return value;
                    }
                    return ((Long)value).intValue();
                }
                case INTENUM: {
                    return this.checkIntEnum(value);
                }
                case PTR: 
                case PTRINDEX: 
                case PTRONE: 
                case PTRREL: {
                    if (this.isFileType() && !(value instanceof Pointer)) {
                        return this.checkBinary(value);
                    }
                    return this.checkPointer(value);
                }
                case REAL: {
                    if (value instanceof Integer) {
                        return value;
                    }
                    return this.normalCheck(value);
                }
                case SET: {
                    try {
                        Object o = this.checkPointer(value);
                        Vector<Object> v = new Vector<Object>();
                        if (o != null && o instanceof Pointer) {
                            v.addElement(o);
                        }
                        return v;
                    }
                    catch (InvalidValueException ive) {
                        this.normalCheck(value);
                        Vector v = (Vector)value;
                        FieldDefinition ptr = this.getForeignTable().getFieldDefinition(this.getForeignTable().getIndexPointerFieldName());
                        for (int i = 0; i < v.size(); ++i) {
                            if (v.elementAt(i) == null || v.elementAt(i).equals(Pointer.Null)) {
                                throw new InvalidValueException(this, "set members cannot be null");
                            }
                            try {
                                v.setElementAt(ptr.checkValue(v.elementAt(i)), i);
                                continue;
                            }
                            catch (InvalidValueException e) {
                                throw new InvalidValueException(this, "the set member <" + v.elementAt(i) + "> is not assignable to pointers of type " + this.getForeignTable().getName());
                            }
                        }
                        return v;
                    }
                }
                case SETINTENUM: {
                    Vector vect = new Vector();
                    if (value != null && value instanceof Integer) {
                        this.checkIntEnum(value);
                        vect.addElement(value);
                        return vect;
                    }
                    if (value != null && value instanceof String) {
                        this.checkIntEnum(value);
                        vect.addElement(value);
                        return vect;
                    }
                    this.normalCheck(value);
                    vect = (Vector)value;
                    for (int i = 0; i < vect.size(); ++i) {
                        if (vect.elementAt(i) == null || vect.elementAt(i).equals(Pointer.NullInteger)) {
                            throw new InvalidValueException(this, "set members cannot be null");
                        }
                        vect.setElementAt(this.checkIntEnum(vect.elementAt(i)), i);
                    }
                    return vect;
                }
                case SETCHARENUM: {
                    this.normalCheck(value);
                    Vector v = (Vector)value;
                    for (int i = 0; i < v.size(); ++i) {
                        if (v.elementAt(i) == null || v.elementAt(i).equals(Pointer.NullString)) {
                            throw new InvalidValueException(this, "set members cannot be null");
                        }
                        v.setElementAt(this.checkCharEnum(v.elementAt(i)), i);
                    }
                    return v;
                }
                case SETCOMPLEX: {
                    throw new InvalidValueException(this, "subsets cannot be assigned directly");
                }
                case TEXT: {
                    return this.checkBinary(value);
                }
                case BINARY: 
                case BOOLEAN: {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    return this.normalCheck(value);
                }
            }
            throw new RuntimeException("Unknown case handling for field type '" + this + "', integer type " + this.getIntegerType());
        }
        return value;
    }

    private Object checkBinary(Object value) {
        try {
            return Text.getText(value);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(this, e.getMessage());
        }
    }

    private Object checkIntEnum(Object value) {
        if (value instanceof Integer && !this.intEnumValues.containsKey(value)) {
            throw new InvalidValueException(this, "int value set to int enumerator (" + value + ") is not a member of " + Arrays.toString(this.intEnumValues.keySet().toArray()));
        }
        if (!(value instanceof Integer) && !(value instanceof String)) {
            throw new InvalidValueException(this, "int enumerators only accept values of type Integer or String. Value supplied (" + value + ") is of type " + value.getClass().getName());
        }
        if (value instanceof String && !this.intEnumValues.containsValue(value)) {
            throw new InvalidValueException(this, "string value set to int enumerator (" + value + ") is neither a member of " + Arrays.toString(this.intEnumValues.values().toArray()) + " nor a member of " + Arrays.toString(this.intEnumValues.keySet().toArray()));
        }
        if (value instanceof String && this.intEnumValues.containsValue(value)) {
            for (Integer i : this.intEnumValues.keySet()) {
                if (!this.intEnumValues.get(i).equals(value)) continue;
                return i;
            }
        }
        return value;
    }

    private Object checkCharEnum(Object value) {
        if (value instanceof String && !this.charEnumValues.contains(value)) {
            throw new InvalidValueException(this, "char value set to char enumerator (" + value + ") is not a member of " + Arrays.toString(this.charEnumValues.toArray()));
        }
        if (!(value instanceof String)) {
            throw new InvalidValueException(this, "char enumerators only accept values of type String. Value supplied (" + value + ") is of type " + value.getClass().getName());
        }
        return value;
    }

    private Object checkPointer(Object value) {
        if (value instanceof Pointer) {
            if (!((Pointer)value).getType().equals(this.getPointedType().getName())) {
                throw new InvalidValueException((FieldDefinition)this, this.getPointedType().getName(), (Pointer)value);
            }
            return value;
        }
        if (value instanceof String) {
            return new Pointer(this.getPointedType().getName(), (String)value);
        }
        throw new InvalidValueException(this, "Only java.lang.String and org.makumba.Pointer (or a java.util.Vector containing elements of those types) are assignable to makumba pointers, given value <" + value + "> is of type " + value.getClass().getName());
    }

    protected Object normalCheck(Object value) {
        if (!this.getJavaType().isInstance(value)) {
            throw new InvalidValueException((FieldDefinition)this, this.getJavaType(), value);
        }
        return value;
    }

    @Override
    public boolean isAssignableFrom(FieldDefinition fi) {
        switch (this.type) {
            case INT: {
                return this.is_int_AssignableFrom(fi);
            }
            case INTENUM: {
                return this.is_intEnum_AssignableFrom(fi);
            }
            case PTR: 
            case PTRREL: {
                return this.is_ptrRel_AssignableFrom(fi);
            }
            case REAL: {
                return this.is_real_AssignableFrom(fi);
            }
            case SET: {
                return this.is_set_AssignableFrom(fi);
            }
        }
        return this.base_isAssignableFrom(fi);
    }

    public boolean base_isAssignableFrom(FieldDefinition fi) {
        return fi.getType().equals("nil") || this.getType().equals(fi.getType());
    }

    public boolean is_int_AssignableFrom(FieldDefinition fi) {
        return this.base_isAssignableFrom(fi) || fi.getType().equals("intEnum");
    }

    public boolean is_intEnum_AssignableFrom(FieldDefinition fi) {
        return this.is_int_AssignableFrom(fi) || fi.getType().equals("int") || fi.getType().equals("char");
    }

    public boolean is_ptrRel_AssignableFrom(FieldDefinition fi) {
        return "nil".equals(fi.getType()) || this.getType().equals(fi.getType()) && ((FieldDefinitionImpl)fi).pointedType.equals(this.getForeignTable().getName());
    }

    public boolean is_real_AssignableFrom(FieldDefinition fi) {
        return this.base_isAssignableFrom(fi) || fi.getType().equals("intEnum") || fi.getType().equals("int");
    }

    public boolean is_set_AssignableFrom(FieldDefinition fi) {
        return "nil".equals(fi.getType()) || this.getType().equals(fi.getType()) && this.getForeignTable().getName().equals(fi.getForeignTable().getName());
    }

    @Override
    public String getDataType() {
        return this.type.getDataType();
    }

    @Override
    public Class<?> getJavaType() {
        return this.type.getJavaType();
    }

    @Override
    public int getIntegerType() {
        return this.type.getIntegerType();
    }

    @Override
    public Object getNull() {
        if (this.type == FieldType.PTRONE && this.isFileType()) {
            return Pointer.NullText;
        }
        return this.type.getNullType();
    }

    @Override
    public Object getEmptyValue() {
        return this.type.getEmptyValue();
    }

    @Override
    public String getType() {
        return this.type.getTypeName();
    }

    @Override
    public boolean isDefaultField() {
        return this.type == FieldType.PTRINDEX || this.type == FieldType.DATECREATE || this.type == FieldType.DATEMODIFY;
    }

    @Override
    public Date getDefaultDate() {
        switch (this.type) {
            case DATE: 
            case DATECREATE: 
            case DATEMODIFY: {
                return (Date)this.getDefaultValue();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getDefaultInt() {
        switch (this.type) {
            case INT: {
                return (Integer)this.getDefaultValue();
            }
            case INTENUM: 
            case SETINTENUM: {
                return 0;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public String getDefaultString() {
        switch (this.type) {
            case CHAR: 
            case CHARENUM: 
            case TEXT: 
            case BINARY: {
                return (String)this.getDefaultValue();
            }
            case SETCHARENUM: {
                return null;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return this.getEmptyValue();
        }
        return this.defaultValue;
    }

    @Override
    public Vector<String> getDeprecatedValues() {
        switch (this.type) {
            case INTENUM: {
                Vector<String> depr = new Vector<String>();
                for (Integer i : this.intEnumValuesDeprecated.keySet()) {
                    depr.add(i.toString());
                }
                return depr;
            }
            case CHARENUM: {
                return this.charEnumValuesDeprecated;
            }
        }
        return null;
    }

    @Override
    public int getEnumeratorSize() {
        switch (this.type) {
            case CHARENUM: {
                return this.charEnumValues.size();
            }
            case INTENUM: {
                return this.intEnumValues.size();
            }
            case SETCHARENUM: {
                return this.charEnumValues.size();
            }
            case SETINTENUM: {
                return this.intEnumValues.size();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getIntAt(int i) {
        if (i > this.intEnumValues.size()) {
            throw new RuntimeException("intEnum size is " + this.intEnumValues.size() + ", index is " + i);
        }
        return (Integer)this.intEnumValues.keySet().toArray()[i];
    }

    @Override
    public String getNameAt(int i) {
        switch (this.type) {
            case INTENUM: 
            case SETINTENUM: {
                if (i > this.intEnumValues.size()) {
                    throw new RuntimeException("enumerator size is " + this.intEnumValues.size() + ", index is " + i);
                }
                return (String)this.intEnumValues.values().toArray()[i];
            }
            case CHARENUM: 
            case SETCHARENUM: {
                if (i > this.charEnumValues.size()) {
                    throw new RuntimeException("enumerator size is " + this.charEnumValues.size() + ", index is " + i);
                }
                return this.charEnumValues.elementAt(i);
            }
        }
        throw new RuntimeException("getNameAt works only for intEnum, setintEnum, charEnum and setcharEnum");
    }

    @Override
    public String getNameFor(int i) {
        if (this.type != FieldType.INTENUM) {
            throw new RuntimeException("getNameFor works only for intEnum");
        }
        return this.intEnumValues.get(i);
    }

    @Override
    public Collection<String> getNames() {
        switch (this.type) {
            case INTENUM: 
            case SETINTENUM: {
                return this.intEnumValues.values();
            }
            case CHARENUM: 
            case SETCHARENUM: {
                return this.charEnumValues;
            }
        }
        throw new RuntimeException("getNames() only work for intEnum and charEnum");
    }

    @Override
    public Collection getValues() {
        switch (this.type) {
            case INTENUM: 
            case SETINTENUM: {
                return this.intEnumValues.keySet();
            }
            case CHARENUM: 
            case SETCHARENUM: {
                return this.charEnumValues;
            }
        }
        throw new RuntimeException("getNames() only work for intEnum and charEnum");
    }

    @Override
    public DataDefinition getForeignTable() {
        switch (this.type) {
            case PTR: 
            case PTRREL: 
            case SET: {
                if (this.pointed == null) {
                    this.pointed = MDDProvider.getMDD(this.pointedType);
                }
                return this.pointed;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public FieldDefinition getOriginalFieldDefinition() {
        DataDefinition dataDefinition = null;
        if (this.originalFieldDefinitionParent == null) {
            return null;
        }
        try {
            dataDefinition = DataDefinitionProvider.getInstance().getDataDefinition(this.originalFieldDefinitionParent);
        }
        catch (DataDefinitionNotFoundError dnfe) {
            dataDefinition = null;
        }
        return dataDefinition != null ? dataDefinition.getFieldDefinition(this.originalFieldDefinitionName) : null;
    }

    @Override
    public DataDefinition getPointedType() {
        switch (this.type) {
            case PTRINDEX: {
                return this.getDataDefinition();
            }
            case PTRONE: 
            case SETINTENUM: 
            case SETCHARENUM: 
            case SETCOMPLEX: 
            case FILE: {
                return this.getSubtable();
            }
            case PTR: 
            case PTRREL: 
            case SET: {
                return this.getForeignTable();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public DataDefinition getSubtable() {
        switch (this.type) {
            case PTRONE: 
            case SET: 
            case SETINTENUM: 
            case SETCHARENUM: 
            case SETCOMPLEX: 
            case FILE: {
                return this.subfield;
            }
        }
        throw new RuntimeException("Trying to get a sub-table for a '" + this.getType() + "' for field '" + this.name + "'.");
    }

    @Override
    public String getTitleField() {
        switch (this.type) {
            case PTR: 
            case SET: {
                if (this.pointed != null && ((DataDefinitionImpl)this.pointed).titleField != null) {
                    return ((DataDefinitionImpl)this.pointed).titleField;
                }
                return this.getForeignTable().getTitleFieldName();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getWidth() {
        switch (this.type) {
            case CHAR: {
                return this.charLength;
            }
            case CHARENUM: {
                if (this.longestChar == -1) {
                    for (String s : this.charEnumValues) {
                        if (s.length() <= this.longestChar) continue;
                        this.longestChar = s.length();
                    }
                }
                return this.longestChar;
            }
            case SETCHARENUM: {
                if (this.longestChar == -1) {
                    for (String s : this.charEnumValues) {
                        if (s.length() <= this.longestChar) continue;
                        this.longestChar = s.length();
                    }
                }
                return this.longestChar;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public boolean shouldEditBySingleInput() {
        return this.getIntegerType() != 2 && this.getIntegerType() != 13;
    }

    public String toString() {
        return this.getType();
    }

    public String toString1() {
        StringBuffer sb = new StringBuffer();
        sb.append("== Field name: " + this.name + "\n");
        sb.append("== Field type: " + this.type.getTypeName() + "\n");
        sb.append("== Modifiers: " + (this.fixed ? "fixed " : "") + (this.unique ? "unique " : "") + (this.notNull ? "not null " : "") + (this.notEmpty ? "not empty " : "") + "\n");
        if (this.description != null) {
            sb.append("== Description: " + this.description + "\n");
        }
        switch (this.type) {
            case CHAR: {
                sb.append("== char length: " + this.charLength + "\n");
                break;
            }
            case INTENUM: 
            case SETINTENUM: {
                sb.append("== int enum values:" + Arrays.toString(this.intEnumValues.keySet().toArray()) + "\n");
                sb.append("== int enum names:" + Arrays.toString(this.intEnumValues.values().toArray()) + "\n");
                break;
            }
            case CHARENUM: 
            case SETCHARENUM: {
                sb.append("== char enum values:" + Arrays.toString(this.charEnumValues.toArray()) + "\n");
                break;
            }
            case PTR: 
            case PTRINDEX: 
            case SET: {
                sb.append("== pointed type: " + this.pointedType + "\n");
                break;
            }
            case PTRONE: 
            case SETCOMPLEX: {
                sb.append("== Subfield detail\n\n");
                sb.append(this.subfield.toString() + "\n");
            }
        }
        return sb.toString();
    }

    public String getStructure() {
        StringBuffer sb = new StringBuffer();
        sb.append("--- structure of " + this.getName() + "\n");
        sb.append("getName() " + this.getName() + "\n");
        sb.append("getDataDefinition() " + this.getDataDefinition().getName() + "\n");
        sb.append("isIndexPointerField() " + this.isIndexPointerField() + "\n");
        sb.append("getEmptyValue() " + this.getEmptyValue() + "\n");
        sb.append("getNull()" + this.getNull() + "\n");
        try {
            sb.append("hasDescription() " + this.hasDescription() + "\n");
        }
        catch (RuntimeException e) {
            sb.append("has invalid description");
        }
        sb.append("getDescription() " + this.getDescription() + "\n");
        sb.append("getType() " + this.getType() + "\n");
        sb.append("getIntegerType() " + this.getIntegerType() + "\n");
        sb.append("getDataType() " + this.getDataType() + "\n");
        sb.append("getJavaType() " + this.getJavaType() + "\n");
        sb.append("isFixed() " + this.isFixed() + "\n");
        sb.append("isNotNull() " + this.isNotNull() + "\n");
        sb.append("isNotEmpty() " + this.isNotEmpty() + "\n");
        sb.append("isUnique() " + this.isUnique() + "\n");
        sb.append("getDefaultValue() " + this.getDefaultValue() + "\n");
        sb.append("getDefaultString()\n");
        try {
            sb.append(this.getDefaultString() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a string\n");
        }
        sb.append("getDefaultInt()\n");
        try {
            sb.append(this.getDefaultInt() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not an int: " + re.getMessage() + "\n");
        }
        sb.append("getDefaultDate()\n");
        try {
            sb.append(this.getDefaultDate() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a date\n");
        }
        sb.append("getValues()\n");
        try {
            sb.append(this.getValues() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not an enum\n");
        }
        sb.append("getNames()\n");
        try {
            sb.append(this.getNames() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not an enum: " + re.getMessage() + "\n");
        }
        sb.append("getEnumeratorSize()\n");
        try {
            sb.append(this.getEnumeratorSize() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not an enum\n");
        }
        sb.append("getWidth()\n");
        try {
            sb.append(this.getWidth() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a char\n");
        }
        sb.append("getForeignTable()\n");
        try {
            sb.append(((DataDefinitionImpl)this.getForeignTable()).getName() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a ptr\n");
        }
        sb.append("getSubtable()\n");
        try {
            sb.append(((DataDefinitionImpl)this.getSubtable()).getStructure() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a ptr: " + re.getMessage() + "\n");
        }
        sb.append("getPointedType()\n");
        try {
            sb.append(((DataDefinitionImpl)this.getPointedType()).getName() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a ptr\n");
        }
        sb.append("getTitleField()\n");
        try {
            sb.append(this.getTitleField() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not a ptr\n");
        }
        sb.append("getDeprecatedValues()\n");
        try {
            sb.append(this.getDeprecatedValues() + "\n");
        }
        catch (RuntimeException re) {
            sb.append("was not an enum\n");
        }
        sb.append("isDefaultField()" + this.isDefaultField() + "\n");
        sb.append("shouldEditBySingleInput() " + this.shouldEditBySingleInput() + "\n");
        sb.append("isDateType() " + this.isDateType() + "\n");
        sb.append("isNumberType() " + this.isNumberType() + "\n");
        sb.append("isIntegerType() " + this.isIntegerType() + "\n");
        sb.append("isRealType() " + this.isRealType() + "\n");
        sb.append("isBinaryType() " + this.isBinaryType() + "\n");
        sb.append("isFileType() " + this.isFileType() + "\n");
        sb.append("isSetType() " + this.isSetType() + "\n");
        sb.append("isSetEnumType() " + this.isSetEnumType() + "\n");
        sb.append("isEnumType() " + this.isEnumType() + "\n");
        sb.append("isInternalSet() " + this.isInternalSet() + "\n");
        sb.append("isExternalSet() " + this.isExternalSet() + "\n");
        sb.append("isComplexSet() " + this.isComplexSet() + "\n");
        sb.append("isPointer() " + this.isPointer() + "\n");
        sb.append("isStringType() " + this.isStringType() + "\n");
        sb.append("---  end structure of " + this.getName());
        return sb.toString();
    }

    @Override
    public String getNotANumberErrorMessage() {
        return this.NaNError;
    }

    @Override
    public String getNotNullErrorMessage() {
        return this.notNullError;
    }

    @Override
    public String getNotUniqueErrorMessage() {
        return this.uniqueError;
    }

    @Override
    public String getNotEmptyErrorMessage() {
        return this.notEmptyError;
    }

    @Override
    public String getNotIntErrorMessage() {
        return this.notIntError;
    }

    @Override
    public String getNotRealErrorMessage() {
        return this.notRealError;
    }

    @Override
    public String getNotBooleanErrorMessage() {
        return this.notBooleanError;
    }
}

