/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Transaction;
import org.makumba.ValidationRule;
import org.makumba.providers.datadefinition.mdd.ComparisonExpressionNode;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.MDDAST;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.MDDProvider;
import org.makumba.providers.datadefinition.mdd.ValidationType;
import org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleNode
extends MDDAST
implements ValidationRule,
Comparable<ValidationRule> {
    private static final long serialVersionUID = -6754730605192680602L;
    protected String name;
    protected ValidationType type;
    protected String message;
    protected transient FieldNode field;
    protected MDDNode mdd;
    protected String lowerBound;
    protected String upperBound;
    protected ArrayList<String> arguments = new ArrayList();
    protected String expression;
    protected ComparisonExpressionNode comparisonExpression;

    public ValidationRuleNode(MDDNode mdd, AST originAST) {
        this.initialize(originAST);
        this.setType(47);
        this.mdd = mdd;
    }

    public ValidationRuleNode(MDDNode mdd, AST originAST, FieldNode field) {
        this(mdd, originAST);
        this.field = field;
        this.arguments.add(field.name);
    }

    public ValidationRuleNode(MDDNode mdd, AST originAST, ValidationType type, FieldNode parentField) {
        this(mdd, originAST);
        this.type = type;
        this.name = type.getDescription();
        this.field = parentField;
    }

    public void checkApplicability() {
        if (!this.type.checkApplicability(this.field.makumbaType)) {
            throw new RuntimeException("A " + this.getValidationType().getDescription() + " can only be assigned to fields of type " + this.getValidationType().getApplicableTypes() + " whereas the type of field " + this.field.name + " is " + this.field.makumbaType.getTypeName());
        }
    }

    @Override
    public String getRuleName() {
        return this.name;
    }

    public ValidationType getValidationType() {
        return this.type;
    }

    @Override
    public String getErrorMessage() {
        return this.message;
    }

    @Override
    public FieldDefinition getFieldDefinition() {
        return null;
    }

    @Override
    public boolean validate(Object value, Transaction t) throws InvalidValueException {
        return false;
    }

    @Override
    public int compareTo(ValidationRule o) {
        if (this instanceof ComparisonValidationRule) {
            return 1;
        }
        if (o instanceof ComparisonValidationRule) {
            return -1;
        }
        return 0;
    }

    protected void throwException() throws InvalidValueException {
        throw new InvalidValueException(this.arguments.get(0), this.getErrorMessage());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("== Validation rule: " + this.getRuleName() + "\n");
        return sb.toString();
    }

    @Override
    public Collection<String> getValidationRuleArguments() {
        return this.arguments;
    }

    public FieldDefinition getValidationRuleArgumentType(String fieldName) {
        return MDDProvider.getMDD(this.mdd.getName()).getFieldOrPointedFieldDefinition(fieldName);
    }

    @Override
    public DataDefinition getDataDefinition() {
        return MDDProvider.getMDD(this.mdd.name);
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public String getExpression() {
        return this.expression;
    }

    public ComparisonExpressionNode getComparisonExpression() {
        return this.comparisonExpression;
    }
}

