/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd.validation;

import antlr.collections.AST;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.InvalidValueException;
import org.makumba.Transaction;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;
import org.makumba.providers.datadefinition.mdd.ValidationType;

public class RegExpValidationRule
extends ValidationRuleNode {
    private static final long serialVersionUID = 8505083575565314064L;
    private Pattern regExpPattern;

    public RegExpValidationRule(MDDNode mdd, AST originAST, FieldNode field, ValidationType type) {
        super(mdd, originAST, field);
        this.type = type;
    }

    public String getRuleName() {
        return "matches(" + this.field.getName() + ") {" + this.expression + "} : " + this.message + " (line " + this.getLine() + ")";
    }

    public boolean validate(Object value, Transaction t) throws InvalidValueException {
        Matcher matcher;
        if (!(value instanceof String)) {
            return false;
        }
        if (this.regExpPattern == null) {
            this.regExpPattern = Pattern.compile(this.expression);
        }
        if (!(matcher = this.regExpPattern.matcher((String)value)).matches()) {
            this.throwException();
            return false;
        }
        return true;
    }
}

