/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query;

import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.NoSuchFieldException;
import org.makumba.NoSuchLabelException;
import org.makumba.ProgrammerError;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.query.QuerySectionProcessor;

public class FunctionInliner {
    private static DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    public static String NAME = "[a-zA-Z]\\w*";
    public static final String PATTERN_FUNCTION_CALL_BEGIN = "((" + NAME + ")(" + "[\\s]*" + "\\." + "[\\s]*" + NAME + ")+)" + "[\\s]*" + "\\(";
    public static final String PATTERN_ACTOR = "actor[\\s]*\\([\\s]*(" + NAME + "(\\." + NAME + ")*)" + "[\\s]*" + "\\)" + "[\\s]*";
    public static final Pattern functionBegin = Pattern.compile(PATTERN_FUNCTION_CALL_BEGIN);
    public static final Pattern actor = Pattern.compile(PATTERN_ACTOR);
    private String functionText;
    private ArrayList<String> parameterExpr = new ArrayList();
    private DataDefinition.QueryFragmentFunction functionDefinition;
    private String inlinedFunction;
    private String functionObject;

    private FunctionInliner(String query, Matcher m, QueryAnalysisProvider qp, QuerySectionProcessor qsp) {
        String from = qsp.getInitialFrom();
        this.findFunctionBody(query, m);
        this.findFunctionObject(m, from, qp);
        if (this.functionDefinition.getParameters().getFieldNames().size() != this.parameterExpr.size()) {
            throw new ProgrammerError("parameter number " + this.parameterExpr + " does not match function " + this.functionDefinition);
        }
        QuerySectionProcessor func = new QuerySectionProcessor(this.functionDefinition.getQueryFragment(), 0);
        int n = 0;
        for (String parameter : this.parameterExpr) {
            String inlineParameter = FunctionInliner.inline(parameter, qp, qsp);
            this.checkParameter(n, inlineParameter, from, qp);
            func.replaceParameter(this.functionDefinition.getParameters().getFieldDefinition(n).getName(), inlineParameter);
            ++n;
        }
        qsp.addFromWhere(func, this.functionObject);
        this.inlinedFunction = func.getProjectionText();
    }

    private void checkParameter(int n, String inlineParameter, String from, QueryAnalysisProvider qp) {
        FieldDefinition actual;
        if (inlineParameter.trim().startsWith(qp.getParameterSyntax())) {
            return;
        }
        FieldDefinition fieldDefinition = this.functionDefinition.getParameters().getFieldDefinition(n);
        if (!fieldDefinition.isAssignableFrom(actual = qp.getQueryAnalysis("SELECT " + inlineParameter + " FROM " + from).getProjectionType().getFieldDefinition(0))) {
            throw new ProgrammerError("formal paramter " + fieldDefinition.getName() + " of type " + fieldDefinition.getDataType() + " is not matched by the actual value given " + this.parameterExpr.get(n) + " of type " + actual.getDataType() + " for function " + this.functionDefinition);
        }
    }

    private void findFunctionObject(Matcher m, String from, QueryAnalysisProvider qp) {
        DataDefinition dd = null;
        if (from != null && from.length() > 0) {
            dd = qp.getQueryAnalysis("SELECT 1 FROM " + from).getLabelType(m.group(2));
        }
        if (dd == null) {
            String possibleMdd = m.group(1);
            int n = possibleMdd.lastIndexOf(".");
            if (n != -1) {
                String possibleFunction = possibleMdd.substring(n + 1);
                possibleMdd = possibleMdd.substring(0, n);
                dd = DataDefinitionProvider.getInstance().getDataDefinition(possibleMdd.trim());
                if (dd == null) {
                    throw new DataDefinitionNotFoundError(possibleMdd);
                }
                this.functionDefinition = dd.getFunction(possibleFunction.trim());
                if (this.functionDefinition == null) {
                    throw new NoSuchFieldException(dd, possibleFunction);
                }
                this.functionObject = null;
                if (this.functionDefinition.getQueryFragment().indexOf("this") != -1) {
                    throw new ProgrammerError("Cannot use 'this' in function used statically" + m.group());
                }
                return;
            }
            throw new NoSuchLabelException("no such label '" + m.group(2) + "'.");
        }
        String referenceSequence = m.group(1);
        int dot = referenceSequence.indexOf(".");
        while (true) {
            int dot1;
            if ((dot1 = referenceSequence.indexOf(".", dot + 1)) == -1) {
                String fn = referenceSequence.substring(dot + 1);
                this.functionDefinition = dd.getFunction(fn);
                if (this.functionDefinition == null) {
                    throw new ProgrammerError(fn + " is not a function in " + dd.getName());
                }
                break;
            }
            FieldDefinition fd = dd.getFieldDefinition(referenceSequence.substring(dot + 1, dot1));
            if (fd == null) {
                throw new NoSuchFieldException(dd, referenceSequence.substring(dot + 1, dot1));
            }
            if (!fd.getType().startsWith("ptr")) {
                throw new InvalidFieldTypeException(fd, "pointer");
            }
            dd = fd.getPointedType();
            dot = dot1;
        }
        this.functionObject = referenceSequence.substring(0, dot);
    }

    private void findFunctionBody(String query, Matcher m) {
        int parLevel = 1;
        int index = m.end();
        int lastParam = m.end();
        while (parLevel > 0) {
            char c = query.charAt(index);
            if (c == ')') {
                if (parLevel == 1 && index != lastParam) {
                    this.parameterExpr.add(query.substring(lastParam, index));
                }
                --parLevel;
            } else if (c == '(') {
                ++parLevel;
            }
            if (parLevel == 1 && c == ',') {
                this.parameterExpr.add(query.substring(lastParam, index));
                lastParam = index + 1;
            }
            ++index;
        }
        this.functionText = query.substring(m.start(), index);
    }

    public String toString() {
        return " [" + this.functionText + ":" + this.functionDefinition + ":" + this.functionObject + "] ";
    }

    public static String inline(String expr, QueryAnalysisProvider qp) {
        return FunctionInliner.inline(expr, qp, null);
    }

    static String inline(String expr, QueryAnalysisProvider qp, QuerySectionProcessor qsp) {
        String initialQuery = expr;
        while (true) {
            QuerySectionProcessor qspText;
            Matcher m;
            if ((m = functionBegin.matcher(expr)).find()) {
                QuerySectionProcessor qspText2 = null;
                QuerySectionProcessor qs = qsp;
                if (qs == null) {
                    qs = qspText2 = new QuerySectionProcessor(expr, m.start());
                }
                FunctionInliner fi = new FunctionInliner(expr, m, qp, qs);
                if (qspText2 == null) {
                    qspText2 = new QuerySectionProcessor(expr, 0);
                }
                qspText2.replaceExpr(m.start(), fi.functionText.length(), fi.inlinedFunction);
                expr = qspText2.getText();
                continue;
            }
            m = actor.matcher(expr);
            if (!m.find()) break;
            String actorType = m.group(1);
            ddp.getDataDefinition(actorType);
            if (m.end() < expr.length() && expr.charAt(m.end()) == '.') {
                qspText = null;
                QuerySectionProcessor qs = qsp;
                if (qs == null) {
                    qs = qspText = new QuerySectionProcessor(expr, m.start());
                }
                String actorLabel = FunctionInliner.getActorLabel(actorType);
                qs.addFromWhere(actorType + " " + actorLabel, actorLabel + "=" + qp.getParameterSyntax() + actorLabel);
                if (qspText == null) {
                    qspText = new QuerySectionProcessor(expr, 0);
                }
                qspText.replaceExpr(m.start(), m.group().trim().length(), actorLabel);
                expr = qspText.getText();
                continue;
            }
            qspText = new QuerySectionProcessor(expr, 0);
            qspText.replaceExpr(m.start(), m.group().trim().length(), qp.getParameterSyntax() + FunctionInliner.getActorLabel(actorType));
            expr = qspText.getText();
        }
        if (!expr.equals(initialQuery)) {
            Logger.getLogger("org.makumba.db.query.inline").fine(initialQuery + " \n-> " + expr);
        }
        return expr;
    }

    private static String getActorLabel(String actorType) {
        return "actor_" + actorType.trim().replace('.', '_');
    }

    public static void main(String[] args) throws Exception {
        String[] queries;
        for (String querie : queries = new String[]{"SELECT p FROM test.Person p WHERE p.nameMin3CharsLong() AND actor(test.Person).name is not null", "SELECT p as p, p.indiv as indiv FROM test.Person p WHERE p.nameMin3CharsLong()", "SELECT p AS p, p.indiv AS indiv FROM test.Person p WHERE p.nameMin3CharsLong()", "SELECT p FROM test.Person p WHERE p.nameMin3CharsLong() AND p.nameMin2CharsLong() AND p.name<>NIL", "SELECT p FROM test.Person p WHERE p.name<>NIL OR p.nameMin3CharsLong() AND p.nameMin2CharsLong()", "SELECT p.nameMin3CharsLong() FROM test.Person p", "SELECT test.Person.someTest().firstSex, actor(test.Person).gender", "SELECT p.indiv.name AS col1,character_length(p.indiv.name) AS col2 FROM test.Person p WHERE p.someFunctionWithParams(2,5,7)"}) {
            FunctionInliner.inline(querie, QueryProvider.getQueryAnalzyer("oql"));
        }
    }
}

