/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.providers.datadefinition.mdd.MakumbaDumpASTVisitor;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.FunctionCall;
import org.makumba.providers.query.mql.HqlASTFactory;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlQueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlSqlWalker;
import org.makumba.providers.query.mql.MqlTreePrinter;
import org.makumba.providers.query.mql.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInliner {
    private static final String TEMPORARY_LABEL = "_x_temp_gen_";
    private static final String GENERATED_LABEL = "_x_gen_";
    private final boolean debug = true;
    private String query;
    private MqlTreePrinter printer;
    private HqlASTFactory fact = new HqlASTFactory();
    private MakumbaDumpASTVisitor v = new MakumbaDumpASTVisitor(false);
    private int labelCounter = 0;
    private Vector<String> generatedLabels = new Vector();
    private int parameterNumber = 0;

    public FunctionInliner(String query) {
        this.query = query;
        this.printer = new MqlTreePrinter();
    }

    public static AST inlineQueryTree(String query) {
        FunctionInliner inliner = new FunctionInliner(query);
        return inliner.inline(query);
    }

    private AST inline(String query) {
        System.out.println("===== inlining query " + query);
        HqlParser parser = null;
        try {
            parser = HqlParser.getInstance(query);
            parser.statement();
        }
        catch (Throwable t) {
            this.doThrow(t, parser != null ? parser.getAST() : null, query);
        }
        this.doThrow(parser.error, parser.getAST(), query);
        AST ast = parser.getAST();
        boolean inlined = false;
        try {
            inlined = this.inline(ast, true);
        }
        catch (Throwable t) {
            this.doThrow(t, ast, query);
        }
        if (!inlined) {
            return ast;
        }
        System.out.println("===== inlined ast");
        this.v.visit(ast);
        return ast;
    }

    protected void doThrow(Throwable t, AST debugTree, String query) {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace();
            throw (RuntimeException)t;
        }
        String errorLocation = "";
        String errorLocationNumber = "";
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            errorLocationNumber = " column " + re.getColumn() + " of ";
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < re.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            errorLocation = sb.toString();
        }
        throw new OQLParseError("\r\nin " + errorLocationNumber + " query (during inlining of functions):\r\n" + query + errorLocation + errorLocation + errorLocation, t);
    }

    private boolean inline(AST ast, boolean root) throws Throwable {
        boolean inlined = false;
        ArrayList<MethodCall> methodCalls = this.findMethodCalls(ast, ast, null, null, null, false, new ArrayList<MethodCall>());
        if (methodCalls.size() == 0) {
            return false;
        }
        System.out.println("** inlining tree of " + (root ? "query " : "function ") + this.printer.printTree(ast));
        this.v.visit(ast);
        AST analysisAST = this.fact.dupTree(ast);
        MqlQueryAnalysisProvider.transformOQLParameters(analysisAST, new ArrayList<String>());
        MqlQueryAnalysisProvider.transformOQL(analysisAST);
        MqlSqlWalker mqlAnalyzer = new MqlSqlWalker(this.query, null, true, true, true);
        try {
            mqlAnalyzer.statement(analysisAST);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("in AST");
            this.v.visit(analysisAST);
        }
        if (mqlAnalyzer.error != null) {
            mqlAnalyzer.error.printStackTrace();
            throw new Throwable(mqlAnalyzer.error);
        }
        if (mqlAnalyzer.orderedFunctionCalls.isEmpty()) {
            return false;
        }
        mqlAnalyzer.orderedFunctionCalls = this.getOrderedFunctionCalls(mqlAnalyzer);
        System.out.println("Function calls:");
        for (FunctionCall f : mqlAnalyzer.orderedFunctionCalls.values()) {
            System.out.println(f.getKey());
        }
        int index = 0;
        for (FunctionCall c : mqlAnalyzer.orderedFunctionCalls.values()) {
            if (c.isFunctionArgument() || c.isMQLFunction()) {
                ++index;
                continue;
            }
            inlined = true;
            System.out.println("*** Iterating over function call " + c);
            if (c.isActorFunction() && c.getPath().equals("actor")) {
                this.processActorFunction(c, ast, methodCalls.get(index));
            } else {
                AST queryFragmentTree = this.fact.dupTree(c.getFunction().getParsedQueryFragment());
                System.out.println("*** query fragment tree before replacing arguments");
                this.v.visit(queryFragmentTree);
                this.replaceArgsAndThis(queryFragmentTree, queryFragmentTree, c, null, null, mqlAnalyzer, false, null, null);
                System.out.println("*** query fragment after replacing arguments");
                this.v.visit(queryFragmentTree);
                this.inline(queryFragmentTree, false);
                System.out.println("*** query fragment after inlining its functions");
                this.v.visit(queryFragmentTree);
                this.replaceMethodCall(methodCalls.get(index), this.fact.dupTree(queryFragmentTree), methodCalls, c);
                System.out.println("*** query tree after method call inlining");
                this.v.visit(ast);
            }
            ++index;
        }
        Hashtable<String, String> usedLabels = new Hashtable<String, String>();
        this.collectUsedLabels(ast, usedLabels);
        AST parent = null;
        for (AST originalRange = this.findFrom(ast).getFirstChild(); originalRange != null; originalRange = originalRange.getNextSibling()) {
            boolean isTemporary;
            String path = ASTUtil.getPath(originalRange.getFirstChild().getNextSibling());
            boolean bl = isTemporary = originalRange.getType() == 32 && ASTUtil.getPath(originalRange.getFirstChild()).startsWith(TEMPORARY_LABEL) || originalRange.getType() == 84 && path.startsWith(TEMPORARY_LABEL);
            if (!usedLabels.containsKey(path) || isTemporary) {
                if (parent == null) continue;
                parent.setNextSibling(originalRange.getNextSibling());
                continue;
            }
            parent = originalRange;
        }
        System.out.println("*** query tree after removing unused labels");
        this.v.visit(ast);
        return inlined;
    }

    private LinkedHashMap<String, FunctionCall> getOrderedFunctionCalls(MqlSqlWalker mqlAnalyzer) {
        LinkedHashMap<String, FunctionCall> orderedFunctionCalls = new LinkedHashMap<String, FunctionCall>();
        ArrayList<FunctionCall> f = new ArrayList<FunctionCall>();
        for (String key : mqlAnalyzer.orderedFunctionCalls.keySet()) {
            FunctionCall c = mqlAnalyzer.orderedFunctionCalls.get(key);
            if (c.isFunctionArgument()) {
                f.add(c);
                mqlAnalyzer.orderedFunctionCalls.remove(c);
                continue;
            }
            orderedFunctionCalls.put(key, c);
            if (f.isEmpty()) continue;
            for (int i = f.size() - 1; i >= 0; --i) {
                orderedFunctionCalls.put(((FunctionCall)f.get(i)).getKey(), (FunctionCall)f.get(i));
            }
        }
        return orderedFunctionCalls;
    }

    private void replaceArgsAndThis(AST tree, AST root, FunctionCall c, FunctionCall parentCall, AST parent, MqlSqlWalker mqlAnalyzer, boolean firstChild, String lastAlias, AST currentFrom) throws Throwable {
        int providedArgs;
        int expectedArgs;
        if (tree == null) {
            return;
        }
        if (tree == root && (expectedArgs = c.getFunction().getParameters().getFieldNames().size()) != (providedArgs = c.getOrderedArguments().size())) {
            throw new OQLParseError("Function '" + c.getFunction().toString() + "' is expecting " + expectedArgs + " arguments, but " + providedArgs + " were provided");
        }
        if (lastAlias == null) {
            lastAlias = this.createFunctionContext((AST)tree, c);
        }
        switch (tree.getType()) {
            case 22: {
                currentFrom = tree;
                break;
            }
            case 120: {
                boolean isParameter;
                FieldDefinition argument = null;
                if (parent.getType() != 116) {
                    argument = c.getFunction().getParameters().getFieldDefinition(tree.getText());
                }
                if (tree.getText().equals("this")) {
                    if (c.getParentType().getParentField() != null) {
                        tree.setText(c.getPath());
                        break;
                    }
                    tree.setText(lastAlias);
                    break;
                }
                if (argument == null) break;
                int argumentIndex = c.getFunction().getParameters().getFieldNames().indexOf(tree.getText());
                MqlNode arg = c.getOrderedArguments().get(argumentIndex);
                boolean bl = isParameter = arg.getType() == 142 || arg.getType() == 117 || arg.getType() == 120 && arg.getText().startsWith("$");
                if (arg.getText().startsWith("methodCallPlaceholder_")) {
                    this.replaceFunctionArgument(root, c, parent, mqlAnalyzer, firstChild, currentFrom, argument, arg);
                    break;
                }
                Node n = null;
                if (isParameter) {
                    n = ASTUtil.makeNode(116, ":");
                    Node paramChild = ASTUtil.makeNode(120, arg.getOriginalText().startsWith("$") ? arg.getOriginalText().substring(1) : arg.getOriginalText());
                    n.setFirstChild((AST)paramChild);
                    n.setNextSibling(tree.getNextSibling());
                    n.setCol(tree.getColumn());
                    n.setLine(tree.getLine());
                } else if (!isParameter) {
                    MqlNode type = arg;
                    this.checkArgumentType(argument, type, false);
                    n = ASTUtil.makeNode(arg.getType(), arg.getText());
                    n.setFirstChild(arg.getFirstChild());
                    n.setNextSibling(tree.getNextSibling());
                    n.setCol(tree.getColumn());
                    n.setLine(tree.getLine());
                }
                tree = n;
                if (parent == null) break;
                if (firstChild) {
                    parent.setFirstChild((AST)n);
                    break;
                }
                parent.setNextSibling((AST)n);
            }
        }
        this.replaceArgsAndThis(tree.getFirstChild(), root, c, parentCall, (AST)tree, mqlAnalyzer, true, lastAlias, currentFrom);
        this.replaceArgsAndThis(tree.getNextSibling(), root, c, parentCall, (AST)tree, mqlAnalyzer, false, lastAlias, currentFrom);
    }

    private String createFunctionContext(AST tree, FunctionCall c) {
        String lastAlias = "";
        AST range = this.findFrom(tree).getFirstChild();
        AST l = range.getFirstChild();
        AST a = l.getNextSibling();
        if (a != null && a.getText().equals("makumbaGeneratedAlias")) {
            String firstAlias;
            String path = c.getPath();
            boolean isInSubfield = c.getParentType().getParentField() != null;
            boolean hasComplexPath = path.indexOf(".") > -1;
            String joinAlias = "";
            String string = firstAlias = hasComplexPath ? path.substring(0, path.indexOf(".")) : c.getPath();
            if (isInSubfield) {
                joinAlias = firstAlias;
                firstAlias = this.createLabel(true);
            }
            String parentType = isInSubfield ? c.getParentType().getParentField().getDataDefinition().getName() : c.getParentType().getName();
            Node newLabel = ASTUtil.makeNode(120, parentType);
            Node newAlias = ASTUtil.makeNode(69, firstAlias);
            newLabel.setNextSibling((AST)newAlias);
            range.setFirstChild((AST)newLabel);
            lastAlias = firstAlias;
            if (hasComplexPath) {
                lastAlias = this.expandRangeElement(c.getPath(), range, false, null);
                path = path.substring(0, path.indexOf("."));
            }
            if (isInSubfield) {
                lastAlias = this.expandRangeElement(lastAlias + "." + c.getParentType().getParentField().getName(), range, true, joinAlias);
            }
        } else {
            lastAlias = a.getText();
        }
        return lastAlias;
    }

    private void replaceFunctionArgument(AST root, FunctionCall c, AST parent, MqlSqlWalker mqlAnalyzer, boolean firstChild, AST currentFrom, FieldDefinition argument, MqlNode arg) throws Throwable {
        String key = arg.getText().substring("methodCallPlaceholder_".length());
        FunctionCall cArg = mqlAnalyzer.orderedFunctionCalls.get(key);
        System.out.println("Argument is function call on " + cArg);
        AST inlinedFunction = this.inlineArgument(cArg, mqlAnalyzer, c);
        AST inlinedFunctionType = this.fact.dupTree(inlinedFunction);
        AST select = this.findSelect(inlinedFunctionType);
        AST content = select.getFirstChild();
        AST last = null;
        String projectionLabel = "_mak_expr_";
        if (content.getType() != 7) {
            Node as = ASTUtil.makeNode(7, "as");
            as.setFirstChild(content);
            Node expr = ASTUtil.makeNode(120, projectionLabel);
            last = ASTUtil.getLastChild(select);
            last.setNextSibling((AST)expr);
            select.setFirstChild((AST)as);
        } else {
            last = ASTUtil.getLastChild(content);
            projectionLabel = last.getText();
        }
        MqlSqlWalker analyzer = new MqlSqlWalker(this.query, null, true, true, true);
        analyzer.statement(inlinedFunctionType);
        if (mqlAnalyzer.error != null) {
            throw new Throwable(mqlAnalyzer.error);
        }
        MqlNode t = analyzer.rootContext.projectionLabelSearch.get(projectionLabel);
        this.checkArgumentType(argument, t, true);
        AST where = this.findWhere(root);
        MethodCall mc = new MethodCall(firstChild, root, parent, currentFrom, where);
        this.replaceMethodCall(mc, inlinedFunction, null, null);
    }

    private void checkArgumentType(FieldDefinition argument, MqlNode type, boolean functionCall) throws OQLParseError {
        if (type.getType() == 116) {
            return;
        }
        if (!argument.isAssignableFrom(type.getMakType())) {
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < type.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            String errorLocation = sb.toString();
            String error = "Invalid argument type: expecting " + argument.getType();
            error = functionCall ? error + ", but argument is of type " + type.getMakType().getType() : error + ", argument '" + type.getText() + "' is of type " + type.getMakType().getType();
            throw new OQLParseError(error + "\r\nin query:\r\n" + this.query + errorLocation + errorLocation + errorLocation);
        }
    }

    private String expandRangeElement(String path, AST range, boolean isJoin, String label) {
        String lastLabel = "";
        StringTokenizer tk = new StringTokenizer(path, ".");
        while (tk.hasMoreElements()) {
            String a = tk.nextToken();
            String b = tk.nextToken();
            if (label == null) {
                label = this.createLabel(false);
            }
            Node r = null;
            r = isJoin ? ASTUtil.makeNode(32, "JOIN") : ASTUtil.makeNode(84, "RANGE");
            Node dot = ASTUtil.makeNode(15, ".");
            Node aNode = ASTUtil.makeNode(120, a);
            Node bNode = ASTUtil.makeNode(120, b);
            Node labelNode = ASTUtil.makeNode(69, label);
            r.setFirstChild((AST)dot);
            dot.setFirstChild((AST)aNode);
            aNode.setNextSibling((AST)bNode);
            dot.setNextSibling((AST)labelNode);
            range.setNextSibling((AST)r);
            lastLabel = label;
        }
        return lastLabel;
    }

    private AST inlineArgument(FunctionCall functionCall, MqlSqlWalker mqlAnalyzer, FunctionCall parentCall) throws Throwable {
        AST i = this.fact.dupTree(functionCall.getFunction().getParsedQueryFragment());
        this.replaceArgsAndThis(i, i, functionCall, parentCall, null, null, false, null, null);
        return i;
    }

    private void processActorFunction(FunctionCall c, AST queryFragmentTree, MethodCall methodCall) {
        if (methodCall.getParent().getType() == 15 && methodCall.isFirstChild()) {
            String type = this.getActorType(c);
            Node a = ASTUtil.makeNode(83, "query");
            a.setFirstChild((AST)ASTUtil.makeNode(86, "SELECT_FROM"));
            a.getFirstChild().setFirstChild((AST)ASTUtil.makeNode(22, "FROM"));
            a.getFirstChild().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(84, "RANGE"));
            a.getFirstChild().getFirstChild().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(120, type));
            String alias = this.createLabel(false);
            a.getFirstChild().getFirstChild().getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(69, alias));
            a.getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(45, "SELECT"));
            a.getFirstChild().getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(120, alias));
            a.getFirstChild().setNextSibling((AST)ASTUtil.makeNode(53, "WHERE"));
            a.getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(97, "="));
            a.getFirstChild().getNextSibling().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(120, alias));
            a.getFirstChild().getNextSibling().getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(116, ":"));
            a.getFirstChild().getNextSibling().getFirstChild().getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(120, "actor_" + type.replaceAll("\\.", "_") + "###" + this.parameterNumber()));
            this.replaceMethodCall(methodCall, (AST)a, null, null);
        } else if (c.getPath().equals("actor")) {
            System.out.println("FunctionInliner.processActorFunction(): we have the following actor function, path is '" + c.getPath() + "'");
            this.v.visit(methodCall.getRoot());
            String type = this.getActorType(c);
            System.out.println("FunctionInliner.processActorFunction(): actor type is " + type);
            Node actorParamNode = ASTUtil.makeNode(120, "$actor_" + type.replaceAll("\\.", "_"));
            methodCall.replace((AST)actorParamNode);
        }
    }

    private String getActorType(FunctionCall c) {
        AST a;
        String type = "";
        type = c.getOrderedArguments().size() == 0 ? c.getParentType().getName() : ((a = (AST)c.getOrderedArguments().firstElement()).getType() == 15 ? ASTUtil.getPath(a) : c.getOrderedArguments().firstElement().getText());
        return type;
    }

    private void replaceMethodCall(MethodCall methodCall, AST inlinedFunction, List<MethodCall> methodCalls, FunctionCall functionCall) {
        AST select = this.findSelectContent(inlinedFunction);
        if (select.getType() != 83) {
            AST additionalWhere;
            AST additionalFrom = this.findFrom(inlinedFunction);
            if (additionalFrom != null) {
                if (functionCall != null && functionCall.getPath() != null) {
                    int dot = functionCall.getPath().indexOf(".");
                    String label = functionCall.getPath().substring(0, dot > 0 ? dot : functionCall.getPath().length());
                    System.out.println("replacing method call, FROM segment found to merge with, found label " + label);
                    if (methodCall.getWhere() != null && !functionCall.isInWhere()) {
                        System.out.println("Checking if label " + label + " has a constraint in WHERE tree");
                        this.v.visit(methodCall.getWhere());
                        Boolean hasConstraint = this.hasIdentifier(methodCall.getWhere(), label, false);
                        if (hasConstraint.booleanValue()) {
                            this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, null, false);
                        }
                    } else {
                        this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, label, true);
                    }
                } else {
                    this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, null, true);
                }
            }
            if ((additionalWhere = this.findWhere(inlinedFunction)) != null) {
                additionalWhere.setNextSibling(null);
                if (methodCall.getWhere() != null) {
                    Node and = ASTUtil.makeNode(6, "and");
                    and.setFirstChild(methodCall.getWhere().getFirstChild());
                    and.getFirstChild().setNextSibling(additionalWhere.getFirstChild());
                    methodCall.getWhere().setFirstChild((AST)and);
                } else {
                    ASTUtil.getLastChild(methodCall.getRoot()).setNextSibling(additionalWhere);
                }
            }
        }
        if (methodCalls != null) {
            for (MethodCall m : methodCalls) {
                AST currentCall = methodCall.isFirstChild() ? methodCall.getParent().getFirstChild() : methodCall.getParent().getNextSibling();
                if (!m.getParent().equals(currentCall)) continue;
                m.parent = select;
            }
        }
        methodCall.replace(select);
    }

    private void join(AST from, AST additionalFrom, AST tree, String labelToReuse, boolean mergeSameRange) {
        Hashtable<String, AST> existingLabels = this.getLabels(from);
        Hashtable<String, AST> newLabels = this.getLabels(additionalFrom);
        Hashtable<String, String> newLabelPaths = new Hashtable<String, String>();
        Hashtable<String, String> labelsToReplace = new Hashtable<String, String>();
        for (String l : newLabels.keySet()) {
            if (existingLabels.containsKey(l) && !l.equals(labelToReuse)) {
                String r = this.createLabel(false);
                labelsToReplace.put(l, r);
                newLabels.get(l).getFirstChild().getNextSibling().setText(r);
            } else if (existingLabels.containsKey(l) && l.equals(labelToReuse)) {
                this.removeRange(additionalFrom, newLabels, l);
            } else if (newLabels.get(l) != null && newLabels.get(l).getFirstChild() != null && !l.startsWith(TEMPORARY_LABEL)) {
                String path = ASTUtil.getPath(newLabels.get(l).getFirstChild());
                newLabelPaths.put(l, path);
            }
            for (String c : labelsToReplace.keySet()) {
                AST type = newLabels.get(l).getFirstChild();
                String path = ASTUtil.getPath(type);
                if (!path.startsWith(c + ".")) continue;
                String t = path;
                t = t.substring(c.length());
                t = labelsToReplace.get(c) + t;
                newLabels.get(l).setFirstChild(ASTUtil.constructPath(this.fact, t));
                newLabels.get(l).getFirstChild().setNextSibling(type.getNextSibling());
            }
        }
        if (mergeSameRange) {
            for (String nl : newLabelPaths.keySet()) {
                for (String el : existingLabels.keySet()) {
                    String path = ASTUtil.getPath(existingLabels.get(el).getFirstChild());
                    if (!((String)newLabelPaths.get(nl)).equals(path)) continue;
                    this.removeRange(additionalFrom, newLabels, nl);
                    labelsToReplace.put(nl, el);
                }
            }
        }
        this.replaceLabels(tree, tree, false, labelsToReplace);
        AST endFrom = ASTUtil.getLastChild(from);
        if (additionalFrom.getFirstChild() != null) {
            endFrom.setNextSibling(additionalFrom.getFirstChild());
        }
    }

    private void removeRange(AST additionalFrom, Hashtable<String, AST> newLabels, String l) {
        AST additionalRange;
        AST parent = additionalRange = additionalFrom.getFirstChild();
        while (!additionalRange.getFirstChild().getNextSibling().getText().equals(newLabels.get(l).getFirstChild().getNextSibling().getText()) && additionalRange.getNextSibling() != null) {
            parent = additionalRange = additionalRange.getNextSibling();
        }
        if (additionalRange.getNextSibling() != null && additionalRange != parent) {
            parent.setNextSibling(additionalRange.getNextSibling());
        } else if (additionalRange.getNextSibling() != null && additionalRange == parent) {
            additionalFrom.setFirstChild(additionalRange.getNextSibling());
        } else {
            additionalFrom.setFirstChild(null);
        }
    }

    private void replaceLabels(AST ast, AST parent, boolean firstChild, Hashtable<String, String> labelsToReplace) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 22) {
            this.replaceLabels(ast.getNextSibling(), ast, false, labelsToReplace);
        }
        if (ast.getType() == 120) {
            for (String c : labelsToReplace.keySet()) {
                String path = ASTUtil.getPath(ast);
                if (!path.startsWith(c + ".") && !path.equals(c)) continue;
                String t = ast.getText();
                t = t.substring(c.length());
                t = labelsToReplace.get(c) + t;
                AST sibling = ast.getNextSibling();
                AST newAST = ASTUtil.constructPath(this.fact, t);
                newAST.setNextSibling(sibling);
                if (firstChild) {
                    parent.setFirstChild(newAST);
                    continue;
                }
                parent.setNextSibling(newAST);
            }
        }
        this.replaceLabels(ast.getFirstChild(), ast, true, labelsToReplace);
        this.replaceLabels(ast.getNextSibling(), ast, false, labelsToReplace);
    }

    private void collectUsedLabels(AST ast, Hashtable<String, String> usedLabels) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 22) {
            this.collectUsedLabels(ast.getNextSibling(), usedLabels);
        }
        if (ast.getType() == 120) {
            usedLabels.put(ast.getText(), "");
        }
        this.collectUsedLabels(ast.getFirstChild(), usedLabels);
        this.collectUsedLabels(ast.getNextSibling(), usedLabels);
    }

    private Hashtable<String, AST> getLabels(AST from) {
        Hashtable<String, AST> labels = new Hashtable<String, AST>();
        for (AST range = from.getFirstChild(); range != null; range = range.getNextSibling()) {
            String b = range.getFirstChild().getNextSibling().getText();
            labels.put(b, range);
        }
        return labels;
    }

    private Boolean hasIdentifier(AST tree, String identifier, Boolean found) {
        if (tree == null) {
            return found;
        }
        if (found.booleanValue()) {
            return found;
        }
        if (tree.getType() == 120 && tree.getText().equals(identifier)) {
            found = true;
            return true;
        }
        found = this.hasIdentifier(tree.getFirstChild(), identifier, found);
        if (found.booleanValue()) {
            return found;
        }
        return this.hasIdentifier(tree.getNextSibling(), identifier, found);
    }

    private AST findSelectContent(AST tree) {
        AST c = this.findSelect(tree);
        c = c.getFirstChild().getType() == 7 ? c.getFirstChild().getFirstChild() : c.getFirstChild();
        c.setNextSibling(null);
        return c;
    }

    private AST findSelect(AST tree) {
        AST select_from = ASTUtil.findTypeInChildren(tree, 86);
        return ASTUtil.findTypeInChildren(select_from, 45);
    }

    private AST findFrom(AST tree) {
        AST select_from = ASTUtil.findTypeInChildren(tree, 86);
        if (select_from == null && tree.getType() == 86) {
            select_from = tree;
        } else if (select_from == null) {
            return null;
        }
        AST from = select_from.getFirstChild();
        return from;
    }

    private AST findWhere(AST tree) {
        return ASTUtil.findTypeInChildren(tree, 53);
    }

    private ArrayList<MethodCall> findMethodCalls(AST tree, AST root, AST parent, AST currentFrom, AST currentWhere, boolean firstChild, ArrayList<MethodCall> result) {
        if (tree == null) {
            return null;
        }
        if (parent == null) {
            currentWhere = this.findWhere(tree);
            currentFrom = this.findFrom(tree);
        }
        if (tree.getType() == 22) {
            currentFrom = tree;
        }
        if (tree.getType() == 78) {
            result.add(new MethodCall(firstChild, root, parent, currentFrom, currentWhere));
        }
        parent = tree;
        this.findMethodCalls(tree.getFirstChild(), root, parent, currentFrom, currentWhere, true, result);
        this.findMethodCalls(tree.getNextSibling(), root, parent, currentFrom, currentWhere, false, result);
        return result;
    }

    private String createLabel(boolean temporary) {
        String l = temporary ? TEMPORARY_LABEL : GENERATED_LABEL + this.labelCounter++;
        this.generatedLabels.add(l);
        return l;
    }

    private int parameterNumber() {
        return this.parameterNumber++;
    }

    class MethodCall {
        private boolean firstChild;
        private AST root;
        private AST parent;
        private AST from;
        private AST where;

        public AST getRoot() {
            return this.root;
        }

        public AST getFrom() {
            return this.from;
        }

        public AST getWhere() {
            return this.where;
        }

        public AST getParent() {
            return this.parent;
        }

        public boolean isFirstChild() {
            return this.firstChild;
        }

        public MethodCall(boolean firstChild, AST root, AST parent, AST from, AST where) {
            this.firstChild = firstChild;
            this.parent = parent;
            this.from = from;
            this.where = where;
            this.root = root;
        }

        public void replace(AST node) {
            if (this.firstChild) {
                node.setNextSibling(this.parent.getFirstChild().getNextSibling());
                this.parent.setFirstChild(node);
            } else {
                node.setNextSibling(this.parent.getNextSibling().getNextSibling());
                this.parent.setNextSibling(node);
            }
        }

        public String toString() {
            return "MethodCall [firstChild=" + this.firstChild + ", root=" + this.root + ", from=" + this.from + ", where=" + this.where + ", parent=" + this.parent + "]";
        }
    }
}

