/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import java.util.List;
import org.makumba.providers.query.mql.MQLFunctionArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQLFunctionDefinition {
    private MQLFunctionArgument[] arguments;
    private String name;
    private String returnType;

    public static MQLFunctionDefinition dateToDateFunction(String name) {
        return new MQLFunctionDefinition(name, "date", "date");
    }

    public static MQLFunctionDefinition dateToIntFunction(String name) {
        return new MQLFunctionDefinition(name, "int", "date");
    }

    public static MQLFunctionDefinition dateToStringFunction(String name) {
        return new MQLFunctionDefinition(name, "char[255]", "date");
    }

    public static MQLFunctionDefinition getByName(List<MQLFunctionDefinition> functions, String name) {
        for (MQLFunctionDefinition function : functions) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        return null;
    }

    public static MQLFunctionDefinition intToDateFunction(String name) {
        return new MQLFunctionDefinition(name, "date", "int");
    }

    public static MQLFunctionDefinition intToStringFunction(String name) {
        return new MQLFunctionDefinition(name, "char[255]", "int");
    }

    private static MQLFunctionArgument[] makeStandardArguments(String[] args) {
        MQLFunctionArgument[] arguments = new MQLFunctionArgument[args.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = new MQLFunctionArgument(args[i]);
        }
        return arguments;
    }

    public static MQLFunctionDefinition stringToIntFunction(String name) {
        return new MQLFunctionDefinition(name, "int", "char[255]");
    }

    public static MQLFunctionDefinition stringToStringFunction(String name) {
        return new MQLFunctionDefinition(name, "char[255]", "char[255]");
    }

    public static MQLFunctionDefinition toDateFunction(String name) {
        return new MQLFunctionDefinition(name, "date", new String[0]);
    }

    public static MQLFunctionDefinition toDateFunction(String name, MQLFunctionArgument ... arguments) {
        return new MQLFunctionDefinition(name, "date", arguments);
    }

    public static MQLFunctionDefinition toDateFunction(String name, String ... arguments) {
        return new MQLFunctionDefinition(name, "date", arguments);
    }

    public static MQLFunctionDefinition toIntFunction(String name, MQLFunctionArgument ... arguments) {
        return new MQLFunctionDefinition(name, "int", arguments);
    }

    public static MQLFunctionDefinition toIntFunction(String name, String ... arguments) {
        return new MQLFunctionDefinition(name, "int", arguments);
    }

    public static MQLFunctionDefinition toStringFunction(String name, MQLFunctionArgument ... arguments) {
        return new MQLFunctionDefinition(name, "char[255]", arguments);
    }

    public static MQLFunctionDefinition toStringFunction(String name, String ... arguments) {
        return new MQLFunctionDefinition(name, "char[255]", arguments);
    }

    public static MQLFunctionDefinition toRealFunction(String name) {
        return new MQLFunctionDefinition(name, "real", new String[0]);
    }

    public static MQLFunctionDefinition intToRealFunction(String name) {
        return new MQLFunctionDefinition(name, "real", "int");
    }

    public MQLFunctionDefinition(String name, String returnType, MQLFunctionArgument ... arguments) {
        this.name = name;
        this.returnType = returnType;
        this.arguments = arguments;
    }

    public MQLFunctionDefinition(String name, String returnType, String ... arguments) {
        this(name, returnType, MQLFunctionDefinition.makeStandardArguments(arguments));
    }

    public MQLFunctionArgument[] getArguments() {
        return this.arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuilder params = new StringBuilder(this.name).append("(");
        for (int i = 0; this.arguments != null && i < this.arguments.length; ++i) {
            params.append(this.arguments[i].getTypeNice());
            if (i + 1 < this.arguments.length) {
                if (this.arguments[i + 1].isOptional()) {
                    params.append(" [");
                }
                params.append(", ");
            }
            if (this.arguments[i].isMultiple()) {
                params.append("+");
            }
            if (!this.arguments[i].isOptional()) continue;
            params.append("]");
        }
        return params.append(")").toString();
    }
}

