/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.SemanticException;
import antlr.collections.AST;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.FunctionCall;
import org.makumba.providers.query.mql.MqlIdentNode;
import org.makumba.providers.query.mql.MqlNode;

public class MqlDotNode
extends MqlNode {
    private static final long serialVersionUID = 1L;
    String label;
    String field;

    void processInExpression() throws SemanticException {
        String path = ASTUtil.getPathText((AST)this);
        DataDefinition type = null;
        try {
            type = DataDefinitionProvider.getInstance().getDataDefinition(path);
        }
        catch (DataDefinitionNotFoundError e) {
        }
        catch (DataDefinitionParseError pe) {
            // empty catch block
        }
        if (type != null) {
            int lastDot = path.lastIndexOf(".");
            String ptrIndex = lastDot > -1 ? path.substring(lastDot + 1) : path;
            this.setMakType(type.getFieldDefinition(ptrIndex));
        } else {
            this.field = this.getFirstChild().getNextSibling().getText();
            boolean isActor = false;
            if (this.getFirstChild() instanceof MqlDotNode) {
                MqlDotNode son = (MqlDotNode)this.getFirstChild();
                this.label = this.walker.currentContext.join(son.label, son.field, null, -1, (AST)this);
            } else if (this.getFirstChild() instanceof MqlIdentNode) {
                ((MqlIdentNode)this.getFirstChild()).resolve();
                this.label = ((MqlIdentNode)this.getFirstChild()).label;
            } else if (this.getFirstChild().getText().startsWith("methodCallPlaceholder_") && this.getFirstChild().getText().indexOf("actor") > -1) {
                AST left = this.getFirstChild();
                String actorType = FunctionCall.getActorType(left.getText());
                DataDefinition typeDD = DataDefinitionProvider.getInstance().getDataDefinition(actorType);
                FieldDefinition rightType = typeDD.getFieldDefinition(this.field);
                if (rightType == null) {
                    this.walker.error = new SemanticException("No such field '" + this.right.getText() + "' in type " + typeDD.getName());
                } else {
                    this.setMakType(rightType);
                }
                isActor = true;
            } else {
                throw new SemanticException("(expression).field not supported", "", this.getLine(), this.getColumn());
            }
            if (!isActor) {
                this.walker.currentContext.selectField(this.label, this.field, this);
            }
        }
    }

    void processInFrom() throws SemanticException {
        if (this.getFirstChild() instanceof MqlDotNode) {
            ((MqlDotNode)this.getFirstChild()).processInFrom();
        }
        this.setText(this.getFirstChild().getText() + "." + this.getFirstChild().getNextSibling().getText());
    }
}

