/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.CommonAST;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Pointer;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.MQLFunctionArgument;
import org.makumba.providers.query.mql.MQLFunctionDefinition;
import org.makumba.providers.query.mql.MqlQueryAnalysis;
import org.makumba.providers.query.mql.MqlSqlWalker;

public class MqlNode
extends CommonAST {
    private static final long serialVersionUID = 1L;
    private NameResolver.TextList textList;
    MqlSqlWalker walker;
    private MqlNode father;
    private FieldDefinition makType;
    private String originalText;
    protected ArrayList<String> checkAsIds;
    public static ArrayList<MQLFunctionDefinition> mqlFunctions = new ArrayList();

    protected MqlSqlWalker getWalker() {
        return this.walker;
    }

    protected void setWalker(MqlSqlWalker walker) {
        this.walker = walker;
    }

    public void setFather(MqlNode node) {
        this.father = node;
    }

    public MqlNode getFather() {
        return this.father;
    }

    public void setFirstChild(AST a) {
        super.setFirstChild(a);
        if (a != null) {
            ((MqlNode)a).setFather(this);
            this.addCheckedIds((MqlNode)a);
            this.oneMoreChild((MqlNode)a);
        }
    }

    public void setNextSibling(AST a) {
        super.setNextSibling(a);
        if (this.father != null) {
            this.father.addCheckedIds((MqlNode)a);
            this.father.oneMoreChild((MqlNode)a);
        }
    }

    private void addCheckedIds(MqlNode child) {
        if (child != null && child.checkAsIds != null) {
            if (this.getType() == 53) {
                this.walker.error = new SemanticException("cannot use AS identifiers in WHERE: " + child.checkAsIds, "", this.getLine(), this.getColumn());
            } else if (this.checkAsIds != null) {
                this.checkAsIds.addAll(child.checkAsIds);
            } else {
                this.checkAsIds = child.checkAsIds;
            }
        }
    }

    protected void oneMoreChild(MqlNode child) {
        if (this.walker.error != null || child == null) {
            return;
        }
        FieldDefinition tp = this.findMakType(child);
        if (tp != null) {
            this.makType = tp;
        }
        if (this.getType() == 38 && child.isParam()) {
            child.setMakType(this.makeBooleanFieldDefinition());
        }
        if ((this.getType() == 26 || this.getType() == 80) && child.getType() == 74) {
            MqlNode inListMember = (MqlNode)child.getFirstChild();
            boolean leftParam = this.checkParam(inListMember, (MqlNode)this.getFirstChild());
            if (!leftParam) {
                try {
                    this.checkAndRewriteOperand(inListMember, (MqlNode)this.getFirstChild());
                }
                catch (SemanticException e) {
                    this.walker.error = e;
                    return;
                }
            }
            do {
                if (!this.checkParam((MqlNode)this.getFirstChild(), inListMember)) continue;
                if (leftParam) {
                    this.walker.error = new SemanticException("cannot have paramters on both sides of IN", "", this.getLine(), this.getColumn());
                    return;
                }
                try {
                    this.checkAndRewriteOperand((MqlNode)this.getFirstChild(), inListMember);
                }
                catch (SemanticException e) {
                    this.walker.error = e;
                    return;
                }
            } while ((inListMember = (MqlNode)inListMember.getNextSibling()) != null);
        }
    }

    protected FieldDefinition findMakType(MqlNode child) {
        switch (this.getType()) {
            case 4: 
            case 5: 
            case 47: {
                return child.getMakType();
            }
            case 45: {
                if (child.getType() == 131) {
                    return child.getMakType();
                }
                return null;
            }
            case 131: {
                if (this.makType != null) {
                    return this.makType;
                }
                return child.getMakType();
            }
            case 78: {
                return this.getFunctionType(child);
            }
            case 68: 
            case 87: 
            case 88: {
                if (child.isParam()) {
                    child.setMakType(DataDefinitionProvider.getInstance().makeFieldDefinition("x", "int"));
                }
                return child.getMakType();
            }
            case 54: {
                if (child.getType() != 56) break;
                return ((MqlNode)this.getFirstChild().getFirstChild().getNextSibling()).getMakType();
            }
        }
        return null;
    }

    private FieldDefinition getFunctionType(MqlNode child) {
        String type = null;
        String name = child.getText();
        MQLFunctionDefinition functionDef = MQLFunctionDefinition.getByName(mqlFunctions, name);
        if (functionDef != null) {
            type = functionDef.getReturnType();
        }
        if (type != null) {
            child.setType(141);
            return DataDefinitionProvider.getInstance().makeFieldDefinition("x", type);
        }
        return null;
    }

    protected void setMakType(FieldDefinition fd) {
        if (fd.getType().equals("ptrIndex")) {
            fd = DataDefinitionProvider.getInstance().makeFieldDefinition("x", "ptr " + fd.getPointedType().getName());
        }
        this.makType = fd;
    }

    protected FieldDefinition getMakType() {
        return this.makType;
    }

    public void setText(String text) {
        super.setText(text);
        if (this.originalText == null && text.length() > 0) {
            this.originalText = text;
        }
    }

    public void setType(int type) {
        super.setType(type);
        String def = this.knownType();
        if (def != null) {
            this.setMakType(DataDefinitionProvider.getInstance().makeFieldDefinition("x", def));
        }
    }

    public void initialize(AST t) {
        super.initialize(t);
        if (t instanceof MqlNode) {
            MqlNode n = (MqlNode)t;
            this.makType = n.makType;
            this.father = n.father;
            this.originalText = n.originalText;
            this.textList = n.textList;
            this.checkAsIds = n.checkAsIds;
            this.walker = n.walker;
        }
    }

    String knownType() {
        switch (this.getType()) {
            case 12: 
            case 94: 
            case 118: {
                return "int";
            }
            case 92: 
            case 93: {
                return "real";
            }
            case 19: 
            case 20: 
            case 26: 
            case 38: 
            case 49: 
            case 76: 
            case 77: 
            case 80: {
                return "boolean";
            }
            case 119: {
                return "char[255]";
            }
        }
        return null;
    }

    protected void checkForOperandType(MqlNode ast) {
        if (!ast.isParam() && ast.getMakType() == null) {
            throw new IllegalStateException("No makumba type computed for " + MqlQueryAnalysis.showAst((AST)ast));
        }
    }

    boolean isParam() {
        return this.getType() == 142 || this.getType() == 117;
    }

    boolean isFunctionCall() {
        return this.getType() == 78 && this.getText().startsWith("methodCallPlaceholder_");
    }

    void checkOperandTypes(MqlNode left, MqlNode right) throws SemanticException {
        this.checkForOperandType(left);
        this.checkForOperandType(right);
        if (!(left.isParam() && left.getMakType() == null || right.getMakType().isAssignableFrom(left.getMakType()) || right.getMakType().isNumberType() && left.getMakType().isNumberType() || right.getMakType().isDateType() && left.getMakType().isDateType())) {
            throw new SemanticException("incompatible operands " + left.getText() + "(" + MqlNode.toStringType(left.getMakType()) + ") and " + right.getText() + " (" + MqlNode.toStringType(right.getMakType()) + ")", "", this.getLine(), this.getColumn());
        }
    }

    private static String toStringType(FieldDefinition makType) {
        String s = makType.toString();
        if (!s.equals("ptr")) {
            return s;
        }
        return s + " " + makType.getPointedType().getName();
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void writeTo(NameResolver.TextList t) {
        if (this.textList == null) {
            t.append(this.getText());
        } else {
            t.append(this.textList);
        }
    }

    public String toString() {
        if (this.textList != null) {
            return this.textList.toString();
        }
        return super.getText();
    }

    public void setTextList(NameResolver.TextList tl) {
        this.textList = tl;
    }

    protected boolean checkAndRewriteOperand(MqlNode left, MqlNode right) throws SemanticException {
        if (right.getType() == 119 && !left.isParam()) {
            if (right.getText().startsWith("methodCallPlaceholder_")) {
                return true;
            }
            String s = right.getText();
            String arg1 = s.substring(1, s.length() - 1);
            Object o = null;
            try {
                o = left.getMakType().checkValue(arg1);
            }
            catch (InvalidValueException e) {
                throw new SemanticException(e.getMessage(), "", this.getLine(), this.getColumn());
            }
            if (o instanceof Pointer) {
                o = new Long(((Pointer)o).longValue());
            }
            if (o instanceof Number) {
                right.setText(o.toString());
            } else {
                right.setText("'" + o + "'");
            }
            return true;
        }
        this.checkOperandTypes(left, right);
        return false;
    }

    protected boolean checkParam(MqlNode left, MqlNode right) {
        if (right.isParam()) {
            if (left.isParam()) {
                this.walker.error = new SemanticException("can't have two parameters in a non-logical binary operator", "", this.getLine(), this.getColumn());
                return true;
            }
            this.walker.setParameterType(right, left.getMakType());
            return true;
        }
        return false;
    }

    protected FieldDefinition makeBooleanFieldDefinition() {
        return DataDefinitionProvider.getInstance().makeFieldDefinition("x", "boolean");
    }

    static void initMQLFunctions() {
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("lower"));
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("upper"));
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("trim"));
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("rtrim"));
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("ltrim"));
        mqlFunctions.add(MQLFunctionDefinition.stringToStringFunction("reverse"));
        mqlFunctions.add(MQLFunctionDefinition.toStringFunction("concat", MQLFunctionArgument.multipleArgument("char[255]")));
        mqlFunctions.add(MQLFunctionDefinition.toStringFunction("concat_ws", new MQLFunctionArgument("char[255]"), MQLFunctionArgument.multipleArgument("char[255]")));
        mqlFunctions.add(MQLFunctionDefinition.toStringFunction("substring", new MQLFunctionArgument("char[255]"), new MQLFunctionArgument("int"), MQLFunctionArgument.optionalArgument("int")));
        mqlFunctions.add(MQLFunctionDefinition.toStringFunction("replace", "char[255]", "char[255]"));
        mqlFunctions.add(MQLFunctionDefinition.stringToIntFunction("ascii"));
        mqlFunctions.add(MQLFunctionDefinition.stringToIntFunction("character_length"));
        mqlFunctions.add(MQLFunctionDefinition.intToStringFunction("format"));
        mqlFunctions.add(MQLFunctionDefinition.intToStringFunction("char"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("dayOfMonth"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("dayOfWeek"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("week"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("weekday"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("dayOfYear"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("year"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("month"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("hour"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("minute"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("second"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("microsecond"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("quarter"));
        mqlFunctions.add(MQLFunctionDefinition.dateToIntFunction("to_days"));
        mqlFunctions.add(MQLFunctionDefinition.toIntFunction("datediff", "date", "date", "date"));
        mqlFunctions.add(MQLFunctionDefinition.toIntFunction("mod", "int", "int"));
        mqlFunctions.add(MQLFunctionDefinition.toIntFunction("extract", "char[255]", "date"));
        mqlFunctions.add(MQLFunctionDefinition.dateToStringFunction("monthName"));
        mqlFunctions.add(MQLFunctionDefinition.dateToStringFunction("dayName"));
        mqlFunctions.add(MQLFunctionDefinition.dateToDateFunction("last_day"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("current_date"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("current_time"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("current_timestamp"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("now"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("date_add", "char[255]", "date"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("date_sub", "char[255]", "date"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("makedate", "date", "date"));
        mqlFunctions.add(MQLFunctionDefinition.toDateFunction("maketime", "date", "date", "date"));
        mqlFunctions.add(MQLFunctionDefinition.intToDateFunction("from_days"));
        mqlFunctions.add(MQLFunctionDefinition.toRealFunction("rand"));
        mqlFunctions.add(MQLFunctionDefinition.intToRealFunction("rand"));
    }

    static {
        MqlNode.initMQLFunctions();
    }
}

